/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.runtime;

import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.Stack;

public abstract class StringUtil {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public static String concat(String[] strings, String separator) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return "";
        }
        int size = (strings.length - 1) * separator.length();
        int i = 0;
        while (i < strings.length) {
            size += strings[i].length();
            ++i;
        }
        StringBuffer buffer = new StringBuffer(size);
        int i2 = 0;
        while (i2 < strings.length) {
            if (i2 > 0) {
                buffer.append(separator);
            }
            buffer.append(strings[i2]);
            ++i2;
        }
        return buffer.toString();
    }

    public static boolean equalsIgnoreLeadingZeroes(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null ^ s2 == null) {
            return false;
        }
        return StringUtil.trimLeadingZeroes(s1, 0).equals(StringUtil.trimLeadingZeroes(s2, 0));
    }

    public static String escapeString(String text) {
        if (StringUtil.isEmpty(text)) {
            return "";
        }
        StringBuffer buffer = null;
        int i = 0;
        while (i < text.length()) {
            char character = text.charAt(i);
            String escapedCharacter = StringUtil.escapeChar(character);
            if (escapedCharacter != null) {
                if (buffer == null) {
                    buffer = new StringBuffer(2 * text.length());
                    int j = 0;
                    while (j < i) {
                        buffer.append(text.charAt(j));
                        ++j;
                    }
                }
                buffer.append(escapedCharacter);
            } else if (buffer != null) {
                buffer.append(character);
            }
            ++i;
        }
        return buffer == null ? text : buffer.toString();
    }

    public static String format(Object value, Format format) {
        if (value == null) {
            return "";
        }
        if (format != null) {
            return format.format(value);
        }
        return value.toString();
    }

    public static Format getFormatFor(Class type, Locale locale) {
        if (!StringUtil.isEditableType(type) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean) == type || Boolean.TYPE == type || (class$java$lang$Character == null ? (class$java$lang$Character = StringUtil.class$("java.lang.Character")) : class$java$lang$Character) == type || Character.TYPE == type || (class$java$lang$String == null ? (class$java$lang$String = StringUtil.class$("java.lang.String")) : class$java$lang$String) == type) {
            return null;
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = StringUtil.class$("java.util.Date")) : class$java$util$Date) == type) {
            DateFormat format = DateFormat.getDateTimeInstance(2, 3, locale);
            format.setLenient(false);
            return format;
        }
        return NumberFormat.getNumberInstance(locale);
    }

    public static boolean isEditableType(Class type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() && type != Void.TYPE || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean) == type || (class$java$lang$Character == null ? (class$java$lang$Character = StringUtil.class$("java.lang.Character")) : class$java$lang$Character) == type || (class$java$util$Date == null ? (class$java$util$Date = StringUtil.class$("java.util.Date")) : class$java$util$Date) == type || (class$java$lang$String == null ? (class$java$lang$String = StringUtil.class$("java.lang.String")) : class$java$lang$String) == type || (class$java$lang$Number == null ? (class$java$lang$Number = StringUtil.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type);
    }

    public static boolean isDigital(String text) {
        if (StringUtil.isEmpty(text)) {
            return true;
        }
        int i = 0;
        while (i < text.length()) {
            if (!Character.isDigit(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDyckWord(String text, String opening, String closing, String separators) {
        if (StringUtil.isEmpty(text)) {
            return true;
        }
        Stack<Integer> pendingParentheses = new Stack<Integer>();
        char lastNonWhite = ' ';
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!Character.isWhitespace(c)) {
                if (opening.indexOf(c) >= 0) {
                    pendingParentheses.push(new Integer(opening.indexOf(c)));
                } else if (closing.indexOf(c) >= 0 ? pendingParentheses.empty() || !new Integer(closing.indexOf(c)).equals(pendingParentheses.pop()) : separators.indexOf(c) >= 0 && c == lastNonWhite) {
                    return false;
                }
                lastNonWhite = c;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object parse(String text, Class type, Format format) throws ParseException, ClassCastException {
        if (!StringUtil.isEditableType(type)) {
            throw new IllegalArgumentException(type + " is not an editable type");
        }
        if (text != null) {
            text = text.trim();
        }
        if (StringUtil.isEmpty(text)) {
            if (type.isPrimitive()) {
                throw new ParseException(text, 0);
            }
            if (type != (class$java$lang$String == null ? (class$java$lang$String = StringUtil.class$("java.lang.String")) : class$java$lang$String)) return null;
            return "";
        }
        Object value = null;
        ParsePosition parsePosition = new ParsePosition(0);
        if (format == null) {
            if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean) == type || Boolean.TYPE == type) {
                value = Boolean.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Character == null ? (class$java$lang$Character = StringUtil.class$("java.lang.Character")) : class$java$lang$Character) == type || Character.TYPE == type) {
                value = new Character(text.charAt(0));
                parsePosition.setIndex(1);
            } else if ((class$java$lang$Byte == null ? (class$java$lang$Byte = StringUtil.class$("java.lang.Byte")) : class$java$lang$Byte) == type || Byte.TYPE == type) {
                value = Byte.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Double == null ? (class$java$lang$Double = StringUtil.class$("java.lang.Double")) : class$java$lang$Double) == type || Double.TYPE == type) {
                value = Double.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Float == null ? (class$java$lang$Float = StringUtil.class$("java.lang.Float")) : class$java$lang$Float) == type || Float.TYPE == type) {
                value = Float.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = StringUtil.class$("java.lang.Integer")) : class$java$lang$Integer) == type || Integer.TYPE == type) {
                value = Integer.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Long == null ? (class$java$lang$Long = StringUtil.class$("java.lang.Long")) : class$java$lang$Long) == type || Long.TYPE == type) {
                value = Long.valueOf(text);
                parsePosition.setIndex(text.length());
            } else if ((class$java$lang$Short == null ? (class$java$lang$Short = StringUtil.class$("java.lang.Short")) : class$java$lang$Short) == type || Short.TYPE == type) {
                value = Short.valueOf(text);
                parsePosition.setIndex(text.length());
            } else {
                if ((class$java$lang$String == null ? (class$java$lang$String = StringUtil.class$("java.lang.String")) : class$java$lang$String) != type) throw new ParseException(text, 0);
                value = text;
                parsePosition.setIndex(text.length());
            }
        } else if (format instanceof DateFormat) {
            if (type != (class$java$util$Date == null ? (class$java$util$Date = StringUtil.class$("java.util.Date")) : class$java$util$Date)) {
                throw new ClassCastException(type.getName());
            }
            value = (Date)format.parseObject(text, parsePosition);
        } else if (format instanceof NumberFormat) {
            Number parsedValue = (Number)format.parseObject(text, parsePosition);
            if (parsedValue == null) {
                value = null;
            } else if ((class$java$lang$Float == null ? (class$java$lang$Float = StringUtil.class$("java.lang.Float")) : class$java$lang$Float) == type || Float.TYPE == type) {
                value = new Float(parsedValue.floatValue());
            } else if ((class$java$lang$Double == null ? (class$java$lang$Double = StringUtil.class$("java.lang.Double")) : class$java$lang$Double) == type || Double.TYPE == type) {
                value = new Double(parsedValue.doubleValue());
            } else if ((class$java$lang$Byte == null ? (class$java$lang$Byte = StringUtil.class$("java.lang.Byte")) : class$java$lang$Byte) == type || Byte.TYPE == type) {
                value = new Byte(parsedValue.byteValue());
            } else if ((class$java$lang$Short == null ? (class$java$lang$Short = StringUtil.class$("java.lang.Short")) : class$java$lang$Short) == type || Short.TYPE == type) {
                value = new Short(parsedValue.shortValue());
            } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = StringUtil.class$("java.lang.Integer")) : class$java$lang$Integer) == type || Integer.TYPE == type) {
                value = new Integer(parsedValue.intValue());
            } else {
                if ((class$java$lang$Long == null ? (class$java$lang$Long = StringUtil.class$("java.lang.Long")) : class$java$lang$Long) != type) {
                    if (Long.TYPE != type) throw new ClassCastException(type.getName());
                }
                value = new Long(parsedValue.longValue());
            }
        }
        if (parsePosition.getIndex() == text.length()) return value;
        throw new ParseException(text, parsePosition.getIndex());
    }

    public static String[] divide(String text, char separator) {
        if (StringUtil.isEmpty(text)) {
            return new String[0];
        }
        int separators = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == separator) {
                ++separators;
            }
            ++i;
        }
        String[] array = new String[separators + 1];
        int offset = 0;
        int i2 = 0;
        while (i2 < separators) {
            int index = text.indexOf(separator, offset);
            array[i2] = text.substring(offset, index).trim();
            offset = index + 1;
            ++i2;
        }
        array[separators] = text.substring(offset).trim();
        return array;
    }

    public static String searchAndReplace(String text, String pattern, String substitute) {
        int i;
        int offset = 0;
        int index = text.indexOf(pattern, offset);
        if (index < 0 || pattern.equals(substitute)) {
            return text;
        }
        StringBuffer result = new StringBuffer(text.length() + text.length() / pattern.length() * substitute.length());
        while (index >= 0) {
            i = offset;
            while (i < index) {
                result.append(text.charAt(i));
                ++i;
            }
            result.append(substitute);
            offset = index + pattern.length();
            index = text.indexOf(pattern, offset);
        }
        i = offset;
        while (i < text.length()) {
            result.append(text.charAt(i));
            ++i;
        }
        return result.toString();
    }

    public static String toString(Object object) {
        return object != null ? object.toString() : "";
    }

    public static String toString(int[] path) {
        if (path == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("{");
        int i = 0;
        while (i < path.length) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(path[i]);
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static String trimLeadingZeroes(String no, int length) {
        if (length < 0 || StringUtil.isEmpty(no)) {
            return no;
        }
        int noLength = no.length();
        int firstNonZeroPosition = 0;
        while (firstNonZeroPosition < noLength - 1 && no.charAt(firstNonZeroPosition) == '0') {
            ++firstNonZeroPosition;
        }
        int i = firstNonZeroPosition;
        while (i < noLength) {
            if (!Character.isDigit(no.charAt(i))) {
                return no;
            }
            ++i;
        }
        if (noLength >= length) {
            int index = Math.min(noLength - length, firstNonZeroPosition);
            return no.substring(index);
        }
        StringBuffer buffer = new StringBuffer(length);
        int i2 = noLength;
        while (i2 < length) {
            buffer.append('0');
            ++i2;
        }
        buffer.append(no);
        return buffer.toString();
    }

    public static String getQualifiedClassName(String packageName, String unqualifiedClassName) {
        if (packageName == null || "".equals(packageName)) {
            return unqualifiedClassName;
        }
        return packageName + "." + unqualifiedClassName;
    }

    public static String getUnqualifiedClassName(Class clazz) {
        return StringUtil.getUnqualifiedClassName(clazz.getName());
    }

    public static String getUnqualifiedClassName(String qualifiedClassName) {
        if (qualifiedClassName == null) {
            return null;
        }
        int index = qualifiedClassName.lastIndexOf(46);
        return index < 0 ? qualifiedClassName : qualifiedClassName.substring(index + 1);
    }

    public static String getPackageName(Class clazz) {
        return StringUtil.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        return index < 0 ? "" : fullClassName.substring(0, index);
    }

    private static String escapeChar(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

