/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.runtime;

import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.framework.ModelClassMethodSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelClassPropertySettingDefintion;
import com.sap.ide.metamodel.webdynpro.framework.ModelClassSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelRelationRoleSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelRelationSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelSettingDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassMethod;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelClassSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.generation.runtime.BaseTemplateHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ModelTemplateHelper
extends BaseTemplateHelper {
    private final Comparator roleComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ModelRelationRole)o1).getName().compareTo(((ModelRelationRole)o2).getName());
        }
    };
    private final Comparator propertyComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Property)o1).getName().compareTo(((Property)o2).getName());
        }
    };
    private static final List legacyClasses = new ArrayList();

    public String getCMICardinality(CardinalityEnum cardinality) {
        if (CardinalityEnum._0_1.equals(cardinality)) {
            return "com.sap.tc.cmi.metadata.CMICardinality.CARDINALITY_ZERO_TO_ONE";
        }
        if (CardinalityEnum._0_N.equals(cardinality)) {
            return "com.sap.tc.cmi.metadata.CMICardinality.CARDINALITY_MANY";
        }
        if (CardinalityEnum._1_1.equals(cardinality)) {
            return "com.sap.tc.cmi.metadata.CMICardinality.CARDINALITY_ONE";
        }
        if (CardinalityEnum._1_N.equals(cardinality)) {
            return "com.sap.tc.cmi.metadata.CMICardinality.CARDINALITY_ONE_TO_MANY";
        }
        if (CardinalityEnum.NONE.equals(cardinality)) {
            throw new RuntimeException("Unsupported Cardinality: " + cardinality.toString());
        }
        throw new RuntimeException("Unsupported Cardinality: " + cardinality.toString());
    }

    public ModelRelationRole getOtherRole(ModelRelationRole role) {
        ModelRelation relation = role.getModelRelation();
        ModelRelationRole[] roles = relation.getModelRelationRoles();
        if (roles[0] == role) {
            return roles[1];
        }
        return roles[0];
    }

    public ModelClass[] getDerivedModelClasses(ModelClass modelClass) {
        ArrayList<ModelClass> result = new ArrayList<ModelClass>();
        Model model = modelClass.getModel();
        ModelClass[] modelClasses = model.getModelClasses();
        int i = 0;
        while (i < modelClasses.length) {
            if (modelClass.equals(modelClasses[i].getSuperClass())) {
                result.add(modelClasses[i]);
            }
            ++i;
        }
        if (result.isEmpty()) {
            return new ModelClass[0];
        }
        return result.toArray(new ModelClass[result.size()]);
    }

    public String getModelClassName(ModelRelationRole role) {
        return role.getModelClass().getName();
    }

    public ModelRelationRole[] getTargetRolesToN(ModelClass modelClass) {
        ArrayList<ModelRelationRole> targetRolesToN = new ArrayList<ModelRelationRole>();
        ModelRelationRole[] targetRoles = this.getAllTargetRoles(modelClass);
        int i = 0;
        while (i < targetRoles.length) {
            if (targetRoles[i].getNavigable() && (targetRoles[i].getCardinality() == CardinalityEnum._0_N || targetRoles[i].getCardinality() == CardinalityEnum._1_N)) {
                targetRolesToN.add(targetRoles[i]);
            }
            ++i;
        }
        if (targetRolesToN.isEmpty()) {
            return new ModelRelationRole[0];
        }
        return targetRolesToN.toArray(new ModelRelationRole[targetRolesToN.size()]);
    }

    public ModelRelationRole[] getTargetRolesTo1(ModelClass modelClass) {
        ArrayList<ModelRelationRole> targetRolesTo1 = new ArrayList<ModelRelationRole>();
        ModelRelationRole[] targetRoles = this.getAllTargetRoles(modelClass);
        int i = 0;
        while (i < targetRoles.length) {
            if (targetRoles[i].getNavigable() && (targetRoles[i].getCardinality() == CardinalityEnum._0_1 || targetRoles[i].getCardinality() == CardinalityEnum._1_1 || targetRoles[i].getCardinality() == CardinalityEnum.NONE)) {
                targetRolesTo1.add(targetRoles[i]);
            }
            ++i;
        }
        if (targetRolesTo1.isEmpty()) {
            return new ModelRelationRole[0];
        }
        return targetRolesTo1.toArray(new ModelRelationRole[targetRolesTo1.size()]);
    }

    public ModelRelationRole[] getAllNavigableTargetRoles(ModelClass modelClass) {
        ArrayList<ModelRelationRole> targetRolesNavigable = new ArrayList<ModelRelationRole>();
        ModelRelationRole[] targetRoles = this.getAllTargetRoles(modelClass);
        int i = 0;
        while (i < targetRoles.length) {
            if (targetRoles[i].getNavigable()) {
                targetRolesNavigable.add(targetRoles[i]);
            }
            ++i;
        }
        if (targetRolesNavigable.isEmpty()) {
            return new ModelRelationRole[0];
        }
        return targetRolesNavigable.toArray(new ModelRelationRole[targetRolesNavigable.size()]);
    }

    public ModelRelationRole[] getAllTargetRoles(ModelClass modelClass) {
        ArrayList<ModelRelationRole> targetRoles = new ArrayList<ModelRelationRole>();
        ModelRelation[] modelRelations = modelClass.getModel().getModelRelations();
        int i = 0;
        while (i < modelRelations.length) {
            ModelRelationRole[] roles = modelRelations[i].getModelRelationRoles();
            if (roles[0].getModelClass().equals(modelClass)) {
                targetRoles.add(roles[1]);
            }
            if (roles[1].getModelClass().equals(modelClass)) {
                targetRoles.add(roles[0]);
            }
            ++i;
        }
        if (targetRoles.isEmpty()) {
            return new ModelRelationRole[0];
        }
        Collections.sort(targetRoles, this.roleComparator);
        return targetRoles.toArray(new ModelRelationRole[targetRoles.size()]);
    }

    public Property[] getProperties(ModelClass modelClass) {
        Property[] properties = modelClass.getProperties();
        Arrays.sort(properties, this.propertyComparator);
        return properties;
    }

    public String getSettingValue(Model model, String settingName, String defaultValue) {
        String settingValue = null;
        try {
            if (model.hasSetting(settingName)) {
                settingValue = model.getSetting(settingName).getValue();
            }
            if (settingValue == null || settingValue.length() == 0) {
                ModelSettingDefinition def = model.getModelType().getModelSettingDefinition(settingName);
                return def.getDefaultValue();
            }
        }
        catch (NullPointerException nex) {
            return defaultValue;
        }
        return settingValue;
    }

    public boolean hasSettingValue(ModelClass modelClass, String settingName, String value) {
        String result = this.getSettingValue0(modelClass, settingName);
        return result == null ? value == null : result.equals(value);
    }

    public String getSettingValue(ModelClass modelClass, String settingName) {
        String result = this.getSettingValue0(modelClass, settingName);
        return result == null ? "" : result;
    }

    private String getSettingValue0(ModelClass modelClass, String settingName) {
        if (modelClass.hasSetting(settingName)) {
            return modelClass.getSetting(settingName).getValue();
        }
        Model model = modelClass.getModel();
        if (model.getModelType() == null) {
            return null;
        }
        ModelType modelType = model.getModelType();
        if (modelType.hasModelClassSettingDefinition(settingName)) {
            return modelType.getModelClassSettingDefinition(settingName).getDefaultValue();
        }
        return null;
    }

    public String getSettingValue(ModelClass modelClass, String settingName, String defaultValue) {
        String settingValue = null;
        try {
            if (modelClass.hasSetting(settingName)) {
                settingValue = modelClass.getSetting(settingName).getValue();
            }
            if (settingValue == null || settingValue.length() == 0) {
                ModelClassSettingDefinition def = modelClass.getModel().getModelType().getModelClassSettingDefinition(settingName);
                return def.getDefaultValue();
            }
        }
        catch (NullPointerException nex) {
            return defaultValue;
        }
        return settingValue;
    }

    public String getSettingValue(ModelRelation modelRelation, String settingName, String defaultValue) {
        String settingValue = null;
        try {
            if (modelRelation.hasSetting(settingName)) {
                settingValue = modelRelation.getSetting(settingName).getValue();
            }
            if (settingValue == null || settingValue.length() == 0) {
                ModelRelationSettingDefinition def = modelRelation.getModel().getModelType().getModelRelationSettingDefinition(settingName);
                return def.getDefaultValue();
            }
        }
        catch (NullPointerException nex) {
            return defaultValue;
        }
        return settingValue;
    }

    public String getSettingValue(ModelRelationRole modelRelationRole, String settingName, String defaultValue) {
        String settingValue = null;
        try {
            if (modelRelationRole.hasSetting(settingName)) {
                settingValue = modelRelationRole.getSetting(settingName).getValue();
            }
            if (settingValue == null || settingValue.length() == 0) {
                ModelRelationRoleSettingDefinition def = modelRelationRole.getModelClass().getModel().getModelType().getModelRelationRoleSettingDefinition(settingName);
                return def.getDefaultValue();
            }
        }
        catch (NullPointerException nex) {
            return defaultValue;
        }
        return settingValue;
    }

    public String getSettingValue(ModelClassProperty modelClassProp, String settingName, String defaultValue) {
        String settingValue = null;
        try {
            if (modelClassProp.hasSetting(settingName)) {
                settingValue = modelClassProp.getSetting(settingName).getValue();
            }
            if (settingValue == null || settingValue.length() == 0) {
                ModelClassPropertySettingDefintion def = ((ModelClass)modelClassProp.getAppClass()).getModel().getModelType().getModelClassPropertySettingDefinition(settingName);
                return def.getDefaultValue();
            }
        }
        catch (NullPointerException nex) {
            return defaultValue;
        }
        return settingValue;
    }

    public String getSettingValue(ModelClassMethod modelClassMethod, String settingName, String defaultValue) {
        String settingValue = null;
        try {
            if (modelClassMethod.hasSetting(settingName)) {
                settingValue = modelClassMethod.getSetting(settingName).getValue();
            }
            if (settingValue == null || settingValue.length() == 0) {
                ModelClassMethodSettingDefinition def = ((ModelClass)modelClassMethod.getAppClass()).getModel().getModelType().getModelClassMethodSettingDefinition(settingName);
                return def.getDefaultValue();
            }
        }
        catch (NullPointerException nex) {
            return defaultValue;
        }
        return settingValue;
    }

    public ModelClass[] getModelClassesWithSettingValue(Model model, String settingName, String settingValue) {
        ArrayList<ModelClass> result = new ArrayList<ModelClass>();
        ModelClass[] classes = model.getModelClasses();
        int i = 0;
        while (i < classes.length) {
            if (this.hasSettingValue(classes[i], settingName, settingValue)) {
                result.add(classes[i]);
            }
            ++i;
        }
        return result.toArray(new ModelClass[result.size()]);
    }

    public String getSingularName(String name) {
        if (name.equals("ParametersMappings")) {
            return "ParameterMapping";
        }
        if (name.endsWith("ies")) {
            return name.substring(0, name.length() - 3) + "y";
        }
        if (name.endsWith("s")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    public String getAPIName(ModelClass modelClass) {
        return modelClass.getQualifiedName();
    }

    public String getFPIName(ModelClass modelClass) {
        String className = modelClass.getQualifiedName();
        if (this.generateFPI(modelClass.getModel())) {
            return className + ".IFramework";
        }
        return className;
    }

    public boolean isMRO(ModelClass modelClass) {
        ModelClassSetting setting = modelClass.getSetting("isVersionable");
        return setting != null && setting.getValue().equals("true");
    }

    public boolean generateFPI(Model model) {
        return model.getName().equals("IWDProgmodelRepository");
    }

    public boolean generateLegacyAPI(ModelClass modelClass) {
        return modelClass.getPackage().equals("com.sap.tc.webdynpro.progmodel.repository") && legacyClasses.contains(modelClass.getName());
    }

    public boolean isTranslatable(Object dataType) {
        if (dataType instanceof DtSimpleType) {
            DtSimpleType simpleType = (DtSimpleType)dataType;
            if (simpleType.hasExternalRepresentation()) {
                BooleanEnum translateFlag = simpleType.getExternalRepresentation().getTranslateFlag();
                if (BooleanEnum.TRUE.equals(translateFlag)) {
                    return true;
                }
                if (BooleanEnum.FALSE.equals(translateFlag)) {
                    return false;
                }
            }
            if (simpleType.hasBaseType()) {
                return this.isTranslatable(simpleType.getBaseType());
            }
        }
        return false;
    }

    static {
        legacyClasses.add("IWDAbstractViewInfo");
        legacyClasses.add("IWDActionInfo");
        legacyClasses.add("IWDApplicationInfo");
        legacyClasses.add("IWDApplicationPropertyInfo");
        legacyClasses.add("IWDBusinessGraphicsInfo");
        legacyClasses.add("IWDComponentControllerUsageInfo");
        legacyClasses.add("IWDComponentInfo");
        legacyClasses.add("IWDComponentInterfaceDefinitionInfo");
        legacyClasses.add("IWDComponentInterfaceImplementationInfo");
        legacyClasses.add("IWDComponentInterfaceInfo");
        legacyClasses.add("IWDComponentUsageInfo");
        legacyClasses.add("IWDConfigurationInfo");
        legacyClasses.add("IWDContextAttributeMappingInfo");
        legacyClasses.add("IWDContextElementMappingInfo");
        legacyClasses.add("IWDControllerInfo");
        legacyClasses.add("IWDControllerUsageInfo");
        legacyClasses.add("IWDEmptyViewInfo");
        legacyClasses.add("IWDEventBindingInfo");
        legacyClasses.add("IWDEventHandlerInfo");
        legacyClasses.add("IWDFrameworkEventInfo");
        legacyClasses.add("IWDInboundPlugInfo");
        legacyClasses.add("IWDIncomingEventInfo");
        legacyClasses.add("IWDInterfaceViewInfo");
        legacyClasses.add("IWDNavigationLinkInfo");
        legacyClasses.add("IWDNavigationTargetReferenceInfo");
        legacyClasses.add("IWDOutboundPlugInfo");
        legacyClasses.add("IWDParameterInfo");
        legacyClasses.add("IWDParameterizedFeatureInfo");
        legacyClasses.add("IWDParameterMappingInfo");
        legacyClasses.add("IWDUIElementInfo");
        legacyClasses.add("IWDUIElementLibraryInfo");
        legacyClasses.add("IWDViewContainerAssignmentInfo");
        legacyClasses.add("IWDViewContainerInfo");
        legacyClasses.add("IWDViewInfo");
        legacyClasses.add("IWDViewUsageInfo");
        legacyClasses.add("IWDWindowInfo");
    }
}

