/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.runtime;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.ErrorHandler;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.generation.runtime.StringUtil;
import com.sap.ide.webdynpro.generation.runtime.TemplateHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class MigrateImports {
    String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$WebDynproRoot;

    private MigrateImports() {
    }

    private boolean isBeginMarker(String line) {
        if (!(line = line.trim()).startsWith("//@@begin")) {
            return false;
        }
        if (line.length() < 10 || !Character.isWhitespace(line.charAt(9))) {
            return false;
        }
        return line.substring(9).trim().equals("imports");
    }

    private boolean isEndMarker(String line) {
        line = line.trim();
        return line.equals("//@@end");
    }

    private String getImportType(String line) {
        if (!(line = line.trim()).startsWith("import") || line.indexOf(59) < 7) {
            return null;
        }
        if (line.length() < 7 || !Character.isWhitespace(line.charAt(6))) {
            return null;
        }
        return line.substring(6, line.indexOf(59)).trim();
    }

    /*
     * WARNING - void declaration
     */
    private void convert(Controller controller) {
        System.out.print("  controller '" + StringUtil.getQualifiedClassName(controller.getPackage(), controller.getName()) + "': ");
        String text = controller.getCodeBody();
        if (text == null) {
            System.out.println("no code body, skipped.");
            return;
        }
        System.out.println("migrating...");
        MyImportsHelper helper = new MyImportsHelper();
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(text));
            StringWriter outStr = new StringWriter();
            BufferedWriter out = new BufferedWriter(outStr);
            boolean importsSeen = false;
            while ((line = in.readLine()) != null) {
                void var7_9;
                if (!importsSeen && this.isBeginMarker((String)var7_9)) {
                    out.write((String)var7_9);
                    out.newLine();
                    List requiredImports = helper.getRequiredImports(controller, "true");
                    requiredImports.add(StringUtil.getQualifiedClassName(controller.getPackage(), "wdp.IPrivate" + helper.capitalize(controller.getName())));
                    line = in.readLine();
                    while (line != null && !this.isEndMarker(line)) {
                        int index;
                        String importType = this.getImportType(line);
                        if (importType != null && (index = requiredImports.indexOf(importType)) >= 0) {
                            requiredImports.remove(index);
                            System.out.println("    suppress existing import '" + importType + "' (" + index + ")");
                        }
                        out.write(line);
                        out.newLine();
                        line = in.readLine();
                    }
                    Iterator it = requiredImports.iterator();
                    if (it.hasNext()) {
                        out.newLine();
                        while (it.hasNext()) {
                            String importType = (String)it.next();
                            out.write("import " + importType + "; /* added by MigrateImports (" + this.timestamp + ") */");
                            out.newLine();
                            System.out.println("    import '" + importType + "' added");
                        }
                    } else {
                        System.out.println("    no missing imports found, skipped");
                        out.close();
                        return;
                    }
                    out.write("//@@end");
                    out.newLine();
                    importsSeen = true;
                } else {
                    out.write(line);
                }
                out.newLine();
            }
            out.close();
            controller.setCodeBody(outStr.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void convert(Component component) {
        System.out.println("component '" + StringUtil.getQualifiedClassName(component.getPackage(), component.getName()) + "':");
        Controller[] controllers = component.getControllers();
        int i = 0;
        while (i < controllers.length) {
            this.convert(controllers[i]);
            ++i;
        }
        controllers = component.getComponentInterface().getControllers();
        int i2 = 0;
        while (i2 < controllers.length) {
            this.convert(controllers[i2]);
            ++i2;
        }
    }

    private static void usage(String errorMsg) {
        System.out.println();
        if (errorMsg != null) {
            System.out.println("**** error: " + errorMsg);
            System.out.println();
        }
        System.out.println("usage: MigrateImports [-help] [-sourcepath <dir>] [-addpaths <dir>] [-package <java package>] (-component <name> | -all)");
        System.out.println("  -help                     display this message");
        System.out.println("  -sourcepath <dir>         directory where design time repository files can be found");
        System.out.println("  -addpaths <dir1>;<dir2>   list of directories/archives where additional");
        System.out.println("                            metamodel content is located (separated by semicolon)");
        System.out.println("  -package <pkg>            root package of the component");
        System.out.println("  -component <name>         name of a Web Dynpro component to be migrated");
        System.out.println("  -all                      indicates that all components found in the sourcepath should be migrated");
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] args) {
        ArrayList<Object> paths;
        File sourcePath = new File("src/packages");
        String rootPackage = "";
        String componentName = null;
        String[] addPaths = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-help")) {
                MigrateImports.usage(null);
                System.exit(1);
            } else if (args[i].equalsIgnoreCase("-sourcepath")) {
                if (i + 1 >= args.length) {
                    MigrateImports.usage("missing argument for option -sourcepath");
                }
                if (!(sourcePath = new File(args[++i])).isDirectory()) {
                    MigrateImports.usage("Source directory '" + sourcePath + "' does not exist");
                }
            } else if (args[i].equalsIgnoreCase("-addpaths")) {
                if (i + 1 >= args.length) {
                    MigrateImports.usage("missing argument for option -addpaths");
                }
                StringTokenizer tokenizer = new StringTokenizer(args[++i], ";", false);
                paths = new ArrayList();
                while (tokenizer.hasMoreTokens()) {
                    paths.add(tokenizer.nextToken());
                }
                addPaths = paths.toArray(new String[0]);
                System.out.println("[info] " + addPaths.length + " add paths found");
                int j = 0;
                while (j < addPaths.length) {
                    System.out.println("[info] " + addPaths[j]);
                    ++j;
                }
            } else if (args[i].equalsIgnoreCase("-package")) {
                if (i + 1 >= args.length) {
                    MigrateImports.usage("missing argument for option -package");
                }
                rootPackage = args[++i];
            } else if (args[i].equalsIgnoreCase("-component")) {
                if (i + 1 >= args.length) {
                    MigrateImports.usage("missing argument for option -component");
                }
                componentName = args[++i];
            } else if (args[i].equalsIgnoreCase("-all")) {
                componentName = "*";
            } else {
                MigrateImports.usage("illegal option or argument '" + args[i] + "'");
            }
            ++i;
        }
        if (componentName == null) {
            MigrateImports.usage("required argument -component <comp> or -all missing");
        }
        MigrateImports converter = new MigrateImports();
        try {
            paths = new ArrayList<Object>();
            ArrayList<void> archives = new ArrayList<void>();
            int i2 = 0;
            while (i2 < addPaths.length) {
                if (addPaths[i2].endsWith(".jar") || addPaths[i2].endsWith(".zip")) {
                    archives.add(addPaths[i2]);
                } else {
                    paths.add(addPaths[i2]);
                }
                ++i2;
            }
            Metamodel metamodel = new Metamodel("DesignTime", sourcePath.getPath(), paths.toArray(new String[paths.size()]));
            int i3 = 0;
            while (i3 < archives.size()) {
                metamodel.addArchive(new File((String)archives.get(i3)).getAbsolutePath());
                ++i3;
            }
            metamodel.createRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = MigrateImports.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot);
            WebDynproRoot wdRoot = (WebDynproRoot)metamodel.createRoot(class$com$sap$ide$metamodel$webdynpro$WebDynproRoot == null ? (class$com$sap$ide$metamodel$webdynpro$WebDynproRoot = MigrateImports.class$("com.sap.ide.metamodel.webdynpro.WebDynproRoot")) : class$com$sap$ide$metamodel$webdynpro$WebDynproRoot);
            if (componentName.equals("*")) {
                Component[] components = wdRoot.getComponents();
                int i4 = 0;
                while (i4 < components.length) {
                    converter.convert(components[i4]);
                    ++i4;
                }
            } else {
                Component component = wdRoot.getComponent(rootPackage, componentName);
                converter.convert(component);
            }
            metamodel.commitChanges();
        }
        catch (MetamodelException e) {
            System.err.println("failed to load design time repository from '" + sourcePath.getPath() + "/" + componentName + "' due to exception:");
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MyImportsHelper
    extends TemplateHelper {
        private MyImportsHelper() {
        }

        public List getRequiredImports(Controller controller, String includeContext) {
            HashSet imports = new HashSet();
            Method[] methods = controller.getMethods();
            int i = 0;
            while (i < methods.length) {
                this.checkAndAddImport(imports, (Procedure)methods[i]);
                ++i;
            }
            ErrorHandler[] errorHandlers = controller.getErrorHandlers();
            int i2 = 0;
            while (i2 < errorHandlers.length) {
                this.checkAndAddImport(imports, (Procedure)errorHandlers[i2]);
                ++i2;
            }
            EventHandler[] eventHandlers = controller.getEventHandlers();
            int i3 = 0;
            while (i3 < eventHandlers.length) {
                this.checkAndAddImport(imports, (Procedure)eventHandlers[i3]);
                ++i3;
            }
            ControllerUsage[] controllerUsages = controller.getOutgoingControllerUsages();
            int i4 = 0;
            while (i4 < controllerUsages.length) {
                this.checkAndAddImport(imports, controllerUsages[i4]);
                ++i4;
            }
            if ("true".equals(includeContext)) {
                this.checkAndAddImport(imports, (ContextNode)controller.getContext());
            }
            ArrayList result = new ArrayList(imports);
            Collections.sort(result);
            return result;
        }

        private boolean requiresImport(DevelopmentObject dataType) {
            String typeClass = this.getQualifiedJavaClassName(dataType);
            int p = typeClass.lastIndexOf(46);
            if (p >= 0) {
                return !"java.lang".equals(typeClass.substring(0, p));
            }
            return false;
        }

        private void checkAndAddImport(Set imports, DevelopmentObject type) {
            if (this.requiresImport(type)) {
                imports.add(this.getQualifiedJavaClassName(type));
            }
        }

        private void checkAndAddImport(Set imports, Procedure proc) {
            if (proc.getReturnType() != null) {
                this.checkAndAddImport(imports, proc.getReturnType());
            }
            Parameter[] parameters = proc.getParameters();
            int i = 0;
            while (i < parameters.length) {
                this.checkAndAddImport(imports, parameters[i].getType());
                ++i;
            }
        }

        private void checkAndAddImport(Set imports, ControllerUsage cu) {
            if (!cu.hasComponentUsage()) {
                imports.add(StringUtil.getQualifiedClassName(cu.getUsedController().getPackage(), "wdp.IPublic" + cu.getUsedController().getName()));
            } else if (cu.hasUsedController()) {
                if (cu.getUsedController() == cu.getComponentUsage().getUsedComponent().getInterfaceController()) {
                    imports.add(StringUtil.getQualifiedClassName(cu.getComponentUsage().getUsedComponent().getInterfaceController().getPackage(), "wdp.IPublic" + cu.getComponentUsage().getUsedComponent().getInterfaceController().getName()));
                } else {
                    imports.add(StringUtil.getQualifiedClassName(cu.getComponentUsage().getUsedComponent().getConfigurationController().getPackage(), "wdp.IPublic" + cu.getComponentUsage().getUsedComponent().getConfigurationController().getName()));
                }
            }
        }

        private void checkAndAddImport(Set imports, ContextNode node) {
            if (node instanceof ContextModelNode) {
                this.checkAndAddImport(imports, (DevelopmentObject)((ContextModelNode)node).getModelClass());
            }
            AbstractContextNode[] children = node.getChildNodes();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof ContextNode) {
                    this.checkAndAddImport(imports, (ContextNode)children[i]);
                }
                ++i;
            }
            ContextAttribute[] attributes = node.getAttributes();
            int i2 = 0;
            while (i2 < attributes.length) {
                this.checkAndAddImport(imports, this.getDesignTimeType(attributes[i2]));
                ++i2;
            }
        }
    }
}

