/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.runtime;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MMConvert {
    private String rootPath;
    private List conversionsWhat = new ArrayList();
    private List conversionsWith = new ArrayList();
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$WebDynproRoot;

    private MMConvert(String rootPath) {
        this.rootPath = rootPath;
    }

    /*
     * WARNING - void declaration
     */
    private String replaceJavaWord(String line, String what, String with) {
        int p;
        int pos = 0;
        while (pos < line.length() && (p = line.indexOf(what, pos)) > 0) {
            void var5_5;
            if (!(var5_5 != false && Character.isJavaIdentifierPart(line.charAt((int)(var5_5 - true))) || var5_5 + what.length() < line.length() && Character.isJavaIdentifierPart(line.charAt((int)(var5_5 + what.length()))))) {
                line = line.substring(0, (int)var5_5) + with + line.substring((int)(var5_5 + what.length()));
            }
            pos = var5_5 + with.length();
        }
        return line;
    }

    /*
     * WARNING - void declaration
     */
    private String convert(String text) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(text));
            StringWriter outStr = new StringWriter();
            BufferedWriter out = new BufferedWriter(outStr);
            while ((line = in.readLine()) != null) {
                int i = 0;
                while (i < this.conversionsWhat.size()) {
                    void var5_6;
                    line = this.replaceJavaWord((String)var5_6, (String)this.conversionsWhat.get(i), (String)this.conversionsWith.get(i));
                    ++i;
                }
                out.write(line);
                out.newLine();
            }
            out.close();
            return outStr.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private String modifyString(String in, String pattern) {
        int pos = pattern.indexOf(42);
        if (pos < 0) {
            return pattern;
        }
        if (pos > 0) {
            in = pattern.substring(0, pos) + in;
        }
        if (pos + 1 < pattern.length()) {
            in = in + pattern.substring(pos + 1);
        }
        return in;
    }

    public String getFileName(MainDevelopmentObject mdo, String packagePattern, String namePattern, String extPattern) {
        String lPackage = mdo.getPackage();
        String lName = mdo.getName();
        String lExt = ".???";
        if (packagePattern != null && lPackage != null) {
            lPackage = this.modifyString(lPackage, packagePattern);
        }
        if (namePattern != null && lName != null) {
            lName = this.modifyString(lName, namePattern);
        }
        if (extPattern != null && lExt != null) {
            lExt = this.modifyString(lExt, extPattern);
        }
        String file = lName;
        if (lPackage != null && lPackage.length() > 0) {
            file = lPackage + "." + file;
        }
        file = file.replace('.', '/');
        if (lExt != null && lExt.length() > 0) {
            file = file + "." + lExt;
        }
        return this.rootPath + "/" + file;
    }

    private void deleteSource(Controller controller, String packagePattern, String filePattern, String extPattern) {
        String fileName = this.getFileName((MainDevelopmentObject)controller, packagePattern, filePattern, extPattern);
        File file = new File(fileName);
        if (file.exists()) {
            System.out.println("delete " + file);
            file.delete();
        } else {
            System.out.println("warning: file " + file + " not found");
        }
    }

    private void convert(Controller controller) {
        this.conversionsWhat.clear();
        this.conversionsWith.clear();
        ControllerUsage[] cus = controller.getOutgoingControllerUsages();
        int i = 0;
        while (i < cus.length) {
            if (cus[i].hasUsedController()) {
                this.conversionsWhat.add("fw.get" + cus[i].getUsedController().getName());
                this.conversionsWith.add("wdThis.wdGet" + cus[i].getUsedController().getName() + "Controller");
                this.conversionsWhat.add("I" + cus[i].getUsedController().getName());
                this.conversionsWith.add("IPublic" + cus[i].getUsedController().getName());
                this.conversionsWhat.add("I" + cus[i].getUsedController().getName() + "Context");
                this.conversionsWith.add("IPublic" + cus[i].getUsedController().getName() + ".IContextNode");
            } else if (cus[i].hasComponentUsage()) {
                this.conversionsWhat.add("fw.get" + cus[i].getComponentUsage().getName());
                this.conversionsWith.add("wdThis.wdGet" + cus[i].getComponentUsage().getName() + "Controller");
                this.conversionsWhat.add("I" + cus[i].getComponentUsage().getName());
                this.conversionsWith.add("IPublic" + cus[i].getComponentUsage().getName());
                this.conversionsWhat.add("I" + cus[i].getComponentUsage().getName() + "Context");
                this.conversionsWith.add("IPublic" + cus[i].getComponentUsage().getName() + ".IContextNode");
            }
            ++i;
        }
        this.conversionsWhat.add("fw");
        this.conversionsWith.add("wdThis");
        this.conversionsWhat.add("context");
        this.conversionsWith.add("wdContext");
        this.conversionsWhat.add("doInit()");
        this.conversionsWith.add("wdDoInit()");
        this.conversionsWhat.add("doExit()");
        this.conversionsWith.add("wdDoExit()");
        this.conversionsWhat.add("doModifyView()");
        this.conversionsWith.add("wdDoModifyView()");
        controller.setCodeBody(this.convert(controller.getCodeBody()));
        this.deleteSource(controller, "*", "*Impl", "java");
        if (!controller.getType().equals(ControllerTypeEnum.VIEW)) {
            this.deleteSource(controller, "*", "I*", "java");
        }
        this.deleteSource(controller, "*", "*", "java");
        this.deleteSource(controller, "*", "*Context", "java");
        this.deleteSource(controller, "*", "I*Context", "java");
    }

    private void convert(Component component) {
        Controller[] controllers = component.getControllers();
        int i = 0;
        while (i < controllers.length) {
            this.convert(controllers[i]);
            ++i;
        }
    }

    private static void usage(String errorMsg) {
        System.out.println();
        if (errorMsg != null) {
            System.out.println("**** error: " + errorMsg);
            System.out.println();
        }
        System.out.println("usage: java com.sap.ide.webdynpro.generation.runtime.MMConvert [-help] [-sourcepath <dir>] [-addpaths <dir>] [-d <dir>] [-package <java package>] [-app <appName>]");
        System.out.println("  -help                     display this message");
        System.out.println("  -sourcepath <dir>         directory where design time repository files can be found");
        System.out.println("  -addpaths <dir1>;<dir2>   list of directories where additional metamodel content is located (separated by semicolon)");
        System.out.println("  -d <dir>                  directory where java files will be generated");
        System.out.println("  -package <pkg>            root package of application");
        System.out.println("  -app   <applicationName>  WebDynpro application name");
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] args) {
        File sourcePath = new File(".");
        File targetPath = null;
        String rootPackage = "";
        String appName = null;
        String[] addPaths = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-help")) {
                MMConvert.usage(null);
                System.exit(1);
            } else if (args[i].equalsIgnoreCase("-sourcepath")) {
                if (i + 1 >= args.length) {
                    MMConvert.usage("missing argument for option -sourcepath");
                }
                if (!(sourcePath = new File(args[++i])).isDirectory()) {
                    MMConvert.usage("Source directory '" + sourcePath + "' does not exist");
                }
            } else if (args[i].equalsIgnoreCase("-addpaths")) {
                if (i + 1 >= args.length) {
                    MMConvert.usage("missing argument for option -addpaths");
                }
                StringTokenizer tokenizer = new StringTokenizer(args[++i], ";", false);
                ArrayList<String> paths = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    paths.add(tokenizer.nextToken());
                }
                addPaths = paths.toArray(new String[0]);
                System.out.println("[info] " + addPaths.length + " add paths found");
                int j = 0;
                while (j < addPaths.length) {
                    System.out.println("[info] " + addPaths[j]);
                    ++j;
                }
            } else if (args[i].equalsIgnoreCase("-d")) {
                if (i + 1 >= args.length) {
                    MMConvert.usage("missing argument for option -d");
                }
                if (!(targetPath = new File(args[++i])).exists()) {
                    if (targetPath.mkdirs()) {
                        System.out.println("[info] Destination directory '" + targetPath.toString() + "' created (because it didn't exist)");
                    } else {
                        MMConvert.usage("Couldn't create target dir '" + targetPath + "'");
                    }
                } else if (!targetPath.isDirectory()) {
                    MMConvert.usage("Path '" + targetPath + "' is not a directory");
                }
            } else if (args[i].equalsIgnoreCase("-package")) {
                if (i + 1 >= args.length) {
                    MMConvert.usage("missing argument for option -package");
                }
                rootPackage = args[++i];
            } else if (args[i].equalsIgnoreCase("-app")) {
                if (i + 1 >= args.length) {
                    MMConvert.usage("missing argument for option -app");
                }
                appName = args[++i];
            } else {
                MMConvert.usage("illegal option or argument '" + args[i] + "'");
            }
            ++i;
        }
        if (targetPath == null) {
            System.out.println("target not defined, set to sourcepath " + sourcePath);
            targetPath = sourcePath;
        }
        if (appName == null) {
            MMConvert.usage("required argument -app missing");
        }
        MMConvert converter = new MMConvert(targetPath.getPath());
        try {
            Metamodel metamodel = new Metamodel("DesignTime", sourcePath.getPath(), addPaths);
            metamodel.createRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = MMConvert.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot);
            WebDynproRoot wdRoot = (WebDynproRoot)metamodel.createRoot(class$com$sap$ide$metamodel$webdynpro$WebDynproRoot == null ? (class$com$sap$ide$metamodel$webdynpro$WebDynproRoot = MMConvert.class$("com.sap.ide.metamodel.webdynpro.WebDynproRoot")) : class$com$sap$ide$metamodel$webdynpro$WebDynproRoot);
            Component component = wdRoot.getComponent(rootPackage, appName);
            converter.convert(component);
            metamodel.commitChanges();
        }
        catch (MetamodelException e) {
            System.err.println("failed to load design time repository from '" + sourcePath.getPath() + "/" + appName + "' due to exception:");
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

