/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.runtime;

import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import com.sap.ide.webdynpro.generation.runtime.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class BaseTemplateHelper {
    private static final int LOWER_CASE = -1;
    private static final int BOUNDARY = 0;
    private static final int UPPER_CASE = 1;
    private static final Map javaWrapperTypeForPrimitiveType = new HashMap();
    private static final Map runtimeTypeForBuiltInType;

    protected void check(boolean condition, String failureMessage) {
        if (!condition) {
            throw new IllegalStateException("assertion failed: " + failureMessage);
        }
    }

    public int toInt(Integer value, int defaultValue) {
        return value == null ? defaultValue : value;
    }

    public String replaceDotsWithSlashes(String source) {
        return source.replace('.', '/');
    }

    public boolean isEmpty(String str) {
        return StringUtil.isEmpty(str);
    }

    public String capitalize(String str) {
        if (this.isEmpty(str) || Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public String decapitalize(String str) {
        if (this.isEmpty(str) || Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public String escapeString(String text) {
        return StringUtil.escapeString(text);
    }

    public String toUpperCaseConst(String value) {
        return value.toUpperCase();
    }

    public String toMultiWordUpperCase(String value) {
        if (this.isEmpty(value)) {
            return value;
        }
        StringBuffer buf = new StringBuffer();
        int len = value.length();
        int lastCharWas = 0;
        int i = 0;
        while (i < len) {
            char c = Character.toUpperCase(value.charAt(i));
            int charIs = -1;
            if (value.charAt(i) == '_') {
                charIs = 0;
            } else if (Character.isUpperCase(value.charAt(i))) {
                charIs = 1;
            }
            if (charIs == 0) {
                buf.append('_').append(c);
            } else if (lastCharWas == -1 && charIs == 1) {
                buf.append('_').append(c);
            } else if (lastCharWas == 1 && charIs == 1 && i + 1 < len && Character.isLowerCase(value.charAt(i + 1))) {
                buf.append('_').append(c);
            } else {
                buf.append(c);
            }
            lastCharWas = charIs;
            ++i;
        }
        return buf.toString();
    }

    public boolean isJavaPrimitive(String qualifiedType) {
        return javaWrapperTypeForPrimitiveType.containsKey(qualifiedType);
    }

    public boolean isJavaPrimitive(DevelopmentObject dataType) {
        return this.isJavaPrimitive(this.getQualifiedJavaClassName(dataType));
    }

    public String getJavaPrimitive(DevelopmentObject dataType) {
        String type = this.getQualifiedJavaClassName(dataType);
        return this.isJavaPrimitive(type) ? type : null;
    }

    public String getJavaClassForPrimitive(String primitiveName) {
        if (javaWrapperTypeForPrimitiveType.containsKey(primitiveName)) {
            return (String)javaWrapperTypeForPrimitiveType.get(primitiveName);
        }
        throw new RuntimeException("can't find object type corresponding to Java primitive " + primitiveName);
    }

    public String getQualifiedTypeName(DevelopmentObject devObj) {
        if (devObj == null) {
            return "java:java.lang.Object";
        }
        if (devObj instanceof ModelClass) {
            String result = StringUtil.getQualifiedClassName(((ModelClass)devObj).getPackage(), devObj.getName());
            return "java:" + result.replace('/', '.');
        }
        if (devObj instanceof JavaNativeType) {
            String result = StringUtil.getQualifiedClassName(((JavaNativeType)devObj).getJavaPackage(), devObj.getName());
            return "java:" + result.replace('/', '.');
        }
        if (devObj instanceof DtSimpleType || devObj instanceof DtStructure) {
            MainDevelopmentObject mainDevObj = (MainDevelopmentObject)devObj;
            DtLogicalDictionary logicalDictionary = ((DtDataType)devObj).getLogicalDictionary();
            String name = StringUtil.getQualifiedClassName(mainDevObj.getPackage(), mainDevObj.getName());
            if (logicalDictionary == null) {
                return "ddic:" + name;
            }
            return "extern:" + logicalDictionary.getQualifiedName() + ':' + name;
        }
        throw new RuntimeException("Couldn't determine design time type for " + devObj.getName() + "(" + devObj + ")");
    }

    public String getQualifiedJavaClassName(DevelopmentObject dataType) {
        if (dataType == null) {
            return "java.lang.Object";
        }
        if (dataType instanceof ModelClass) {
            String result = StringUtil.getQualifiedClassName(((ModelClass)dataType).getPackage(), dataType.getName());
            return result;
        }
        if (dataType instanceof JavaNativeType) {
            JavaNativeType nativeType = (JavaNativeType)dataType;
            String result = StringUtil.getQualifiedClassName(nativeType.getJavaPackage(), dataType.getName());
            int dim = nativeType.getArrayDimensions();
            while (dim > 0) {
                result = result + "[]";
                --dim;
            }
            return result;
        }
        if (dataType instanceof DtSimpleType) {
            return this.getQualifiedJavaClassName((DtSimpleType)dataType);
        }
        throw new RuntimeException("Couldn't determine Java type for " + dataType.getName() + "(" + dataType + ")");
    }

    public String getUnqualifiedJavaClassName(DevelopmentObject dataType) {
        return StringUtil.getUnqualifiedClassName(this.getQualifiedJavaClassName(dataType));
    }

    private String getQualifiedJavaClassName(DtSimpleType simpleType) {
        if (simpleType == null) {
            return null;
        }
        if (simpleType.hasHint("java")) {
            return simpleType.getHint("java").getLanguageDataType();
        }
        String builtinType = simpleType.getBuiltInType();
        if (runtimeTypeForBuiltInType.containsKey(builtinType)) {
            return (String)runtimeTypeForBuiltInType.get(builtinType);
        }
        if (simpleType.hasBaseType()) {
            return this.getQualifiedJavaClassName(simpleType.getBaseType());
        }
        System.out.println("WARNING: found no valid Java class for simple type " + StringUtil.getQualifiedClassName(simpleType.getPackage(), simpleType.getName()));
        return null;
    }

    public String getReturnTypeName(Method method) {
        return method.getReturnType() != null ? this.getQualifiedJavaClassName(method.getReturnType()) : "void";
    }

    public String getBaseType(String qualifiedTypeName) {
        if (this.isJavaPrimitive(qualifiedTypeName)) {
            return qualifiedTypeName;
        }
        if (qualifiedTypeName.equals("java.lang.String")) {
            return "String";
        }
        return "Object";
    }

    public String convertToObject(String expression, String type) {
        String baseType = this.getBaseType(type);
        if (baseType.equals("String")) {
            return expression;
        }
        if (baseType.equals("int")) {
            return "new Integer(" + expression + ')';
        }
        if (baseType.equals("long")) {
            return "new Long(" + expression + ')';
        }
        if (baseType.equals("boolean")) {
            return "new Boolean(" + expression + ')';
        }
        if (baseType.equals("double")) {
            return "new Double(" + expression + ')';
        }
        if (baseType.equals("char")) {
            return "new Character(" + expression + ')';
        }
        if (baseType.equals("byte")) {
            return "new Byte(" + expression + ')';
        }
        if (baseType.equals("short")) {
            return "new Short(" + expression + ')';
        }
        if (baseType.equals("float")) {
            return "new Float(" + expression + ')';
        }
        return expression;
    }

    public String convertFromObject(String expression, String type) {
        String baseType = this.getBaseType(type);
        if (baseType.equals("String")) {
            return "(String)" + expression;
        }
        if (baseType.equals("int")) {
            return "((Number)" + expression + ").intValue()";
        }
        if (baseType.equals("long")) {
            return "((Number)" + expression + ").longValue()";
        }
        if (baseType.equals("boolean")) {
            return "((Boolean)" + expression + ").booleanValue()";
        }
        if (baseType.equals("double")) {
            return "((Number)" + expression + ").doubleValue()";
        }
        if (baseType.equals("char")) {
            return "((Character)" + expression + ").charValue()";
        }
        if (baseType.equals("byte")) {
            return "((Number)" + expression + ").byteValue()";
        }
        if (baseType.equals("short")) {
            return "((Number)" + expression + ").shortValue()";
        }
        if (baseType.equals("float")) {
            return "((Number)" + expression + ").floatValue()";
        }
        return '(' + type + ')' + expression;
    }

    static {
        javaWrapperTypeForPrimitiveType.put("boolean", "Boolean");
        javaWrapperTypeForPrimitiveType.put("char", "Character");
        javaWrapperTypeForPrimitiveType.put("byte", "Byte");
        javaWrapperTypeForPrimitiveType.put("short", "Short");
        javaWrapperTypeForPrimitiveType.put("int", "Integer");
        javaWrapperTypeForPrimitiveType.put("long", "Long");
        javaWrapperTypeForPrimitiveType.put("float", "Float");
        javaWrapperTypeForPrimitiveType.put("double", "Double");
        runtimeTypeForBuiltInType = new HashMap();
        runtimeTypeForBuiltInType.put("binary", "byte[]");
        runtimeTypeForBuiltInType.put("boolean", "boolean");
        runtimeTypeForBuiltInType.put("date", "java.sql.Date");
        runtimeTypeForBuiltInType.put("decimal", "java.math.BigDecimal");
        runtimeTypeForBuiltInType.put("double", "double");
        runtimeTypeForBuiltInType.put("float", "float");
        runtimeTypeForBuiltInType.put("integer", "int");
        runtimeTypeForBuiltInType.put("long", "long");
        runtimeTypeForBuiltInType.put("short", "short");
        runtimeTypeForBuiltInType.put("string", "java.lang.String");
        runtimeTypeForBuiltInType.put("time", "java.sql.Time");
        runtimeTypeForBuiltInType.put("timestamp", "java.sql.Timestamp");
    }
}

