/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.types.mdi2metamodel;

import com.sap.dictionary.types.mdi.conversions.TypeConversionService;
import com.sap.dictionary.types.mdi.util.DataTypeMapping;
import com.sap.dictionary.types.mdi.util.TextServices;
import com.sap.dictionary.types.mdi2metamodel.NamingConversion;
import com.sap.dictionary.types.mdi2metamodel.model.DictionaryElement;
import com.sap.dictionary.types.mdi2metamodel.model.NestedStructure;
import com.sap.dictionary.types.mdi2metamodel.model.SimpleType;
import com.sap.dictionary.types.mdi2metamodel.model.Structure;
import com.sap.dictionary.types.services.NamingService;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtDbProperty;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtEnumerationValue;
import com.sap.ide.metamodel.dictionary.datatype.DtExternalRepresentation;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtPrimaryKey;
import com.sap.ide.metamodel.dictionary.datatype.DtSchemaType;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.dictionary.datatype.DtTechnicalInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtTextObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.MetaDataAccessNotScalarException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import com.sap.mdi.Rfm;
import com.sap.mdi.RfmParameter;
import com.sap.mdi.ddtypes.DDBuiltInType;
import com.sap.mdi.ddtypes.DDDatabaseStructure;
import com.sap.mdi.ddtypes.DDDataelement;
import com.sap.mdi.ddtypes.DDDomain;
import com.sap.mdi.ddtypes.DDFactory;
import com.sap.mdi.ddtypes.DDField;
import com.sap.mdi.ddtypes.DDFixedValue;
import com.sap.mdi.ddtypes.DDFlatStructure;
import com.sap.mdi.ddtypes.DDObject;
import com.sap.mdi.ddtypes.DDReferenceType;
import com.sap.mdi.ddtypes.DDScalarField;
import com.sap.mdi.ddtypes.DDStructure;
import com.sap.mdi.ddtypes.DDTabletype;
import com.sap.mdi.ddtypes.DDTypeNotFoundException;
import com.sap.mw.jco.JCO;
import java.util.Iterator;
import java.util.Locale;

public class R3ToMetamodelDictionaryConverterWithNestedStructures {
    ObjectFactory mObjectFactory;
    String mPackageName;
    DtDictionaryRoot mRoot;
    DtLogicalDictionary mLogicalDictionary;

    public R3ToMetamodelDictionaryConverterWithNestedStructures(DtDictionaryRoot root, String packageName, String dictionaryName, String logicalSystemName, ObjectFactory objectFactory) throws CreateException, LoadException {
        this.mObjectFactory = objectFactory;
        this.mPackageName = packageName;
        this.mRoot = root;
        this.mLogicalDictionary = this.createLogicalDictionary(dictionaryName, logicalSystemName);
    }

    public R3ToMetamodelDictionaryConverterWithNestedStructures(DtDictionaryRoot root, String packageName, String dictionaryName, String logicalSystemName, JCO.Client client) throws ObjectFactoryException, CreateException, LoadException {
        this.mObjectFactory = new ObjectFactory(client);
        this.mPackageName = packageName;
        this.mRoot = root;
        this.mLogicalDictionary = this.createLogicalDictionary(dictionaryName, logicalSystemName);
    }

    private DtLogicalDictionary createLogicalDictionary(String dictionaryName, String logicalSystemName) throws CreateException, LoadException {
        if (dictionaryName.equals("Java Dictionary")) {
            throw new CreateException("Dictionary name: Java Dictionary not allowed");
        }
        if (this.mRoot.hasLogicalDictionary(this.mPackageName, dictionaryName)) {
            return this.mRoot.getLogicalDictionary(this.mPackageName, dictionaryName);
        }
        DtLogicalDictionary logDic = this.mRoot.createLogicalDictionary(this.mPackageName, dictionaryName);
        logDic.setLogicalSystemName(logicalSystemName);
        return logDic;
    }

    public DtLogicalDictionary getLogicalDictionary() {
        return this.mLogicalDictionary;
    }

    public boolean hasDdicObject(String javaName) {
        if (this.mRoot.hasSimpleType(this.mPackageName, javaName)) {
            return true;
        }
        return this.mRoot.hasStructure(this.mPackageName, javaName);
    }

    public boolean hasDdicObject(RfmParameter parameter) throws CreateException {
        DDObject ddObject = parameter.getDDObject();
        if (ddObject instanceof DDScalarField) {
            ddObject = ddObject.getChild();
        } else if (ddObject instanceof DDTabletype) {
            ddObject = ddObject.getChild();
        }
        String javaName = NamingConversion.getJavaName(ddObject);
        return this.hasDdicObject(javaName);
    }

    public boolean hasDdicObject(DDObject ddObject) throws CreateException {
        if (ddObject instanceof DDScalarField) {
            ddObject = ddObject.getChild();
        } else if (ddObject instanceof DDTabletype) {
            ddObject = ddObject.getChild();
        }
        String javaName = NamingConversion.getJavaName(ddObject);
        return this.hasDdicObject(javaName);
    }

    public DictionaryElement getDdicObject(String javaName) throws LoadException {
        if (this.mRoot.hasSimpleType(this.mPackageName, javaName)) {
            return new SimpleType(this.mRoot.getSimpleType(this.mPackageName, javaName));
        }
        if (this.mRoot.hasStructure(this.mPackageName, javaName)) {
            return new Structure((DtStructure)this.mRoot.getStructure(this.mPackageName, javaName));
        }
        return null;
    }

    public DictionaryElement getDdicObject(RfmParameter parameter) throws LoadException, CreateException {
        String javaName;
        DictionaryElement element;
        DDObject ddObject = null;
        try {
            ddObject = parameter.getDDObject();
        }
        catch (NullPointerException e) {
            try {
                String abapName = DataTypeMapping.getExternalAbapType((String)parameter.getScalarDataTypeABAP());
                String backendName = NamingService.Type.getBackendNameFromABAPName((String)abapName);
                String simpleTypeName = NamingService.Type.getJavaNameFromBackendName((String)backendName);
                DtSimpleType st = this.mRoot.getSimpleType(this.mPackageName, simpleTypeName);
                if (st == null) {
                    return null;
                }
                return new SimpleType(st);
            }
            catch (MetaDataAccessNotScalarException e2) {
                throw new CreateException((Exception)((Object)e2));
            }
        }
        if (ddObject instanceof DDScalarField) {
            if ((ddObject = ddObject.getChild()) instanceof DDBuiltInType) {
                String r3BuiltInType = ((DDBuiltInType)ddObject).getDatatype();
                String javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
                return new SimpleType(this.mRoot.getSimpleType("com.sap.dictionary", javaBuiltInType));
            }
        } else if (ddObject instanceof DDTabletype) {
            if ((ddObject = ddObject.getChild()) instanceof DDBuiltInType) {
                String r3BuiltInType = ((DDBuiltInType)ddObject).getDatatype();
                String javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
                return new SimpleType(this.mRoot.getSimpleType("com.sap.dictionary", javaBuiltInType));
            }
            String javaName2 = NamingConversion.getJavaName(ddObject);
            Structure structure = (Structure)this.getDdicObject(javaName2);
            if (structure != null) {
                structure.setIsTable(true);
            }
            return structure;
        }
        if ((element = this.getDdicObject(javaName = NamingConversion.getJavaName(ddObject))) != null && parameter.isTable() && element instanceof Structure) {
            Structure structure = (Structure)element;
            structure.setIsTable(true);
            return structure;
        }
        return element;
    }

    public DictionaryElement getDdicObject(DDObject ddObject) throws CreateException, LoadException {
        if (ddObject instanceof DDScalarField) {
            ddObject = ddObject.getChild();
        } else if (ddObject instanceof DDTabletype) {
            String javaName = NamingConversion.getJavaName(ddObject = ddObject.getChild());
            Structure structure = (Structure)this.getDdicObject(javaName);
            if (structure != null) {
                structure.setIsTable(true);
            }
            return structure;
        }
        String javaName = NamingConversion.getJavaName(ddObject);
        return this.getDdicObject(javaName);
    }

    public DictionaryElement createDdicObject(String name) throws CreateException {
        DDFactory ddFactory = this.mObjectFactory.getDDFactory();
        DDObject ddObject = ddFactory.getDDObject(name);
        return this.createDdicObject(ddObject);
    }

    public DictionaryElement createDdicObject(RfmParameter parameter) throws CreateException {
        DDObject ddObject;
        block6: {
            ddObject = null;
            try {
                ddObject = parameter.getDDObject();
            }
            catch (NullPointerException e) {
                if (ddObject != null) break block6;
                try {
                    String javaBuiltinType = DataTypeMapping.getJavaBuiltInType((String)parameter.getScalarDataTypeABAP());
                    if (javaBuiltinType == null) {
                        throw new CreateException("Type not found");
                    }
                    String abapName = DataTypeMapping.getExternalAbapType((String)parameter.getScalarDataTypeABAP());
                    return this.createSimpleTypeForAbapType(abapName, javaBuiltinType);
                }
                catch (MetaDataAccessNotScalarException e2) {
                    throw new CreateException((Exception)((Object)e2));
                }
            }
        }
        DictionaryElement element = this.createDdicObject(ddObject);
        if (element != null && parameter.isTable() && element instanceof Structure) {
            Structure structure = (Structure)element;
            structure.setIsTable(true);
            return structure;
        }
        return element;
    }

    private SimpleType createSimpleTypeForAbapType(String abapName, String javaBuiltinType) throws CreateException {
        String backendName = NamingService.Type.getBackendNameFromABAPName((String)abapName);
        String simpleTypeName = NamingService.Type.getJavaNameFromBackendName((String)backendName);
        DtSimpleType simpleType = this.mRoot.createSimpleType(this.mPackageName, simpleTypeName);
        simpleType.setTypeName(simpleTypeName);
        simpleType.setLogicalDictionary(this.mLogicalDictionary);
        simpleType.setBuiltInType(javaBuiltinType);
        simpleType.setToDeploy(true);
        simpleType.setBackendName(backendName);
        simpleType.createSchemaType();
        simpleType.createExternalRepresentation();
        simpleType.createTexts();
        this.createDbProperty(simpleType);
        this.createTechnicalInfo(simpleType);
        return new SimpleType(simpleType);
    }

    public DictionaryElement createDdicObject(DDObject ddObject) throws CreateException {
        if (ddObject instanceof DDDataelement) {
            return this.createSimpleType((DDDataelement)ddObject);
        }
        if (ddObject instanceof DDScalarField) {
            DDScalarField sfield = (DDScalarField)ddObject;
            DDObject child = sfield.getChild();
            if (child instanceof DDDataelement) {
                return this.createSimpleType((DDDataelement)child);
            }
            if (child instanceof DDBuiltInType) {
                DDBuiltInType bit = (DDBuiltInType)child;
                String r3BuiltInType = bit.getDatatype();
                String javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
                try {
                    return new SimpleType(this.mRoot.getSimpleType("com.sap.dictionary", javaBuiltInType));
                }
                catch (LoadException e) {
                    new CreateException((Exception)((Object)e));
                }
            }
        } else {
            if (ddObject instanceof DDFlatStructure) {
                return this.createStructure((DDStructure)ddObject);
            }
            if (ddObject instanceof DDTabletype) {
                String ddName = ddObject.getName();
                if ((ddObject = ddObject.getChild()) instanceof DDDataelement) {
                    throw new CreateException("table type definition is not supported for object " + ddName);
                }
                Structure structure = (Structure)this.createDdicObject(ddObject);
                structure.setIsTable(true);
                return structure;
            }
            if (ddObject instanceof DDDatabaseStructure) {
                return this.createNestedStructure((DDStructure)ddObject);
            }
            if (ddObject instanceof DDStructure) {
                return this.createNestedStructure((DDStructure)ddObject);
            }
        }
        if (ddObject == null) {
            throw new CreateException("ddic object not found");
        }
        throw new CreateException("ddic object not supported");
    }

    private Structure createDbTable(DDDatabaseStructure ddObject) throws CreateException {
        String tableName = ddObject.getName();
        String backEndName = NamingService.Structure.getBackendNameFromABAPName((String)tableName);
        tableName = NamingService.Structure.getJavaNameFromBackendName((String)backEndName);
        DtDbTable dtDbTable = this.mRoot.createTable("", tableName);
        dtDbTable.setBackendName(backEndName);
        dtDbTable.setLogicalDictionary(this.mLogicalDictionary);
        dtDbTable.setDescription(ddObject.getDescription());
        if (dtDbTable.getDescriptionAsTranslatableText() != null) {
            dtDbTable.getDescriptionAsTranslatableText().setDoNotTranslate(true);
        }
        int fieldCount = ddObject.getNumberOfFields();
        int i = 1;
        while (i <= fieldCount) {
            block20: {
                int r3Decimals;
                int r3Length;
                String r3BuiltInType;
                DtField field;
                block19: {
                    DDObject child;
                    block18: {
                        DDScalarField scField;
                        DDField ddField = ddObject.getField(i);
                        String fieldName = ddField.getName();
                        String backendFieldName = NamingService.Field.getBackendNameFromABAPName((String)fieldName);
                        fieldName = NamingService.Field.getJavaNameFromBackendName((String)backendFieldName);
                        field = dtDbTable.createStructureElementAsDtField(fieldName);
                        field.setBackendName(backendFieldName);
                        if (ddField instanceof DDScalarField && (scField = (DDScalarField)ddField).isKeyfield()) {
                            DtPrimaryKey prKey = null;
                            prKey = !dtDbTable.hasPrimaryKey() ? dtDbTable.createPrimaryKey() : dtDbTable.getPrimaryKey();
                            prKey.addKeyElement((DtStructureElement)field);
                        }
                        field.setPosition(ddField.getPosition() - 1);
                        field.setDescription(ddField.getFieldtext());
                        if (field.getDescriptionAsTranslatableText() != null) {
                            field.getDescriptionAsTranslatableText().setDoNotTranslate(true);
                        }
                        child = ddField.getChild();
                        r3BuiltInType = null;
                        r3Length = 0;
                        r3Decimals = 0;
                        if (child instanceof DDReferenceType) {
                            DDReferenceType refType = (DDReferenceType)child;
                            if ((child = child.getChild()) instanceof DDDatabaseStructure || child instanceof DDTabletype || child instanceof DDFlatStructure) {
                                // empty if block
                            }
                        }
                        if (child instanceof DDDataelement) {
                            child = child.getChild();
                        }
                        if (!(child instanceof DDDomain)) break block18;
                        DDDomain domain = (DDDomain)child;
                        DDObject domainChild = domain.getChild();
                        if (domainChild instanceof DDBuiltInType) {
                            DDBuiltInType builtInType = (DDBuiltInType)domainChild;
                            r3BuiltInType = builtInType.getDatatype();
                            r3Length = builtInType.getDDLeng();
                            r3Decimals = builtInType.getDecimals();
                        }
                        break block19;
                    }
                    if (!(child instanceof DDBuiltInType)) break block20;
                    DDBuiltInType builtInType = (DDBuiltInType)child;
                    r3BuiltInType = builtInType.getDatatype();
                    r3Length = builtInType.getDDLeng();
                    r3Decimals = builtInType.getDecimals();
                }
                String javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
                if (javaBuiltInType == null) {
                    javaBuiltInType = "";
                }
                field.setBuiltInType(javaBuiltInType);
                try {
                    field.setReferencedType((DtDataType)this.mRoot.getSimpleType("com.sap.dictionary", javaBuiltInType));
                }
                catch (LoadException e) {
                    throw new CreateException((Exception)((Object)e));
                }
                if (DataTypeMapping.hasTotalDigits((String)r3BuiltInType)) {
                    int j = DataTypeMapping.getTotalDigits((String)r3BuiltInType);
                    if (j > 0) {
                        field.setTotalDigits(j);
                    } else if (r3Length > 0) {
                        field.setTotalDigits(r3Length);
                    }
                    field.setFractionDigits(r3Decimals);
                } else if (javaBuiltInType.equals("binary") || javaBuiltInType.equals("decimal") || javaBuiltInType.equals("string")) {
                    field.setLength(r3Length);
                }
            }
            ++i;
        }
        dtDbTable.setToDeploy(true);
        Structure struct = new Structure((DtStructure)dtDbTable);
        struct.setIsTable(true);
        return struct;
    }

    private Structure createStructure(DDStructure dDStructure) throws CreateException {
        String structureName = dDStructure.getName();
        String backendName = NamingService.Structure.getBackendNameFromABAPName((String)structureName);
        structureName = NamingService.Structure.getJavaNameFromBackendName((String)backendName);
        DtGeneralStructure structure = this.mRoot.createStructure(this.mPackageName, structureName);
        structure.setLogicalDictionary(this.mLogicalDictionary);
        structure.setDescription(dDStructure.getDescription());
        if (structure.getDescriptionAsTranslatableText() != null) {
            structure.getDescriptionAsTranslatableText().setDoNotTranslate(true);
        }
        int fieldCount = dDStructure.getNumberOfFields();
        int i = 1;
        while (i <= fieldCount) {
            block23: {
                int r3Decimals;
                int r3Length;
                String r3BuiltInType;
                DtField field;
                block22: {
                    DDObject child;
                    block21: {
                        DDField ddField = dDStructure.getField(i);
                        String fieldName = ddField.getName();
                        String backendFieldName = NamingService.Field.getBackendNameFromABAPName((String)fieldName);
                        fieldName = NamingService.Field.getJavaNameFromBackendName((String)backendFieldName);
                        field = structure.createStructureElementAsDtField(fieldName);
                        field.setBackendName(backendFieldName);
                        field.setPosition(ddField.getPosition() - 1);
                        field.setDescription(ddField.getFieldtext());
                        if (field.getDescriptionAsTranslatableText() != null) {
                            field.getDescriptionAsTranslatableText().setDoNotTranslate(true);
                        }
                        child = ddField.getChild();
                        r3BuiltInType = null;
                        r3Length = 0;
                        r3Decimals = 0;
                        if (child instanceof DDReferenceType) {
                            DDReferenceType refType = (DDReferenceType)child;
                            if ((child = child.getChild()) instanceof DDDatabaseStructure || child instanceof DDTabletype || child instanceof DDFlatStructure) {
                                // empty if block
                            }
                        }
                        if (child instanceof DDDataelement) {
                            DtSimpleType st = null;
                            if (this.mRoot.hasSimpleType(this.mPackageName, NamingConversion.getJavaName(child))) {
                                try {
                                    st = this.mRoot.getSimpleType(this.mPackageName, NamingConversion.getJavaName(child));
                                }
                                catch (LoadException e) {
                                    throw new CreateException((Exception)((Object)e));
                                }
                            } else {
                                st = this.createSimpleType((DDDataelement)child).getSimpleType();
                            }
                            field.setReferencedType((DtDataType)st);
                        }
                        if (!(child instanceof DDDomain)) break block21;
                        DDDomain domain = (DDDomain)child;
                        DDObject domainChild = domain.getChild();
                        if (domainChild instanceof DDBuiltInType) {
                            DDBuiltInType builtInType = (DDBuiltInType)domainChild;
                            r3BuiltInType = builtInType.getDatatype();
                            r3Length = builtInType.getDDLeng();
                            r3Decimals = builtInType.getDecimals();
                        }
                        break block22;
                    }
                    if (!(child instanceof DDBuiltInType)) break block23;
                    DDBuiltInType builtInType = (DDBuiltInType)child;
                    r3BuiltInType = builtInType.getDatatype();
                    r3Length = builtInType.getDDLeng();
                    r3Decimals = builtInType.getDecimals();
                }
                String javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
                if (javaBuiltInType == null) {
                    javaBuiltInType = "";
                }
                field.setBuiltInType(javaBuiltInType);
                try {
                    field.setReferencedType((DtDataType)this.mRoot.getSimpleType("com.sap.dictionary", javaBuiltInType));
                }
                catch (LoadException e) {
                    throw new CreateException((Exception)((Object)e));
                }
                if (DataTypeMapping.hasTotalDigits((String)r3BuiltInType)) {
                    int j = DataTypeMapping.getTotalDigits((String)r3BuiltInType);
                    if (j > 0) {
                        field.setTotalDigits(j);
                    } else if (r3Length > 0) {
                        field.setTotalDigits(r3Length);
                    }
                    field.setFractionDigits(r3Decimals);
                } else if (javaBuiltInType.equals("binary") || javaBuiltInType.equals("decimal") || javaBuiltInType.equals("string")) {
                    field.setLength(r3Length);
                }
            }
            ++i;
        }
        structure.setToDeploy(true);
        structure.setBackendName(backendName);
        return new Structure((DtStructure)structure);
    }

    private DictionaryElement createNestedStructure(DDStructure ddObject) throws CreateException {
        String structureName = ddObject.getName();
        String backendName = NamingService.Structure.getBackendNameFromABAPName((String)structureName);
        structureName = NamingService.Structure.getJavaNameFromBackendName((String)backendName);
        DtGeneralStructure structure = this.mRoot.createStructure(this.mPackageName, structureName);
        NestedStructure returnValue = new NestedStructure((DtStructure)structure);
        structure.setLogicalDictionary(this.mLogicalDictionary);
        structure.setDescription(ddObject.getDescription());
        if (structure.getDescriptionAsTranslatableText() != null) {
            structure.getDescriptionAsTranslatableText().setDoNotTranslate(true);
        }
        int fieldCount = ddObject.getNumberOfFields();
        int pos = 0;
        int i = 1;
        while (i <= fieldCount) {
            block32: {
                int r3Decimals;
                int r3Length;
                String r3BuiltInType;
                DtField field;
                block34: {
                    DDObject child;
                    block33: {
                        String backendFieldName;
                        String fieldName;
                        DDField ddField;
                        block31: {
                            ddField = ddObject.getField(i);
                            fieldName = ddField.getName();
                            backendFieldName = NamingService.Field.getBackendNameFromABAPName((String)fieldName);
                            fieldName = NamingService.Field.getJavaNameFromBackendName((String)backendFieldName);
                            child = ddField.getChild();
                            if (child instanceof DDReferenceType) {
                                child = child.getChild();
                            }
                            if (child != null && child instanceof DDTabletype) {
                                DDObject child2 = child.getChild();
                                if (child2 instanceof DDBuiltInType) {
                                    child = child2;
                                } else if (child2 instanceof DDReferenceType) {
                                    child = child2.getChild();
                                }
                            }
                            if (!(child instanceof DDFlatStructure) && !(child instanceof DDDatabaseStructure) && !(child instanceof DDTabletype) && !(child instanceof DDStructure)) break block31;
                            DictionaryElement el = null;
                            if (this.hasDdicObject(child)) {
                                try {
                                    el = this.getDdicObject(child);
                                }
                                catch (LoadException e) {
                                    throw new CreateException((Exception)((Object)e));
                                }
                            } else {
                                el = this.createDdicObject(child);
                            }
                            if (el instanceof Structure) {
                                Structure str = (Structure)el;
                                str.setName(fieldName, backendFieldName);
                                returnValue.addNestedStructure(str);
                            }
                            break block32;
                        }
                        field = structure.createStructureElementAsDtField(fieldName);
                        field.setBackendName(backendFieldName);
                        field.setPosition(pos);
                        ++pos;
                        field.setDescription(ddField.getFieldtext());
                        if (field.getDescriptionAsTranslatableText() != null) {
                            field.getDescriptionAsTranslatableText().setDoNotTranslate(true);
                        }
                        r3BuiltInType = null;
                        r3Length = 0;
                        r3Decimals = 0;
                        if (child instanceof DDReferenceType) {
                            DDReferenceType refType = (DDReferenceType)child;
                            if ((child = child.getChild()) instanceof DDDatabaseStructure || child instanceof DDTabletype || child instanceof DDFlatStructure) {
                                // empty if block
                            }
                        }
                        if (child instanceof DDDataelement) {
                            DtSimpleType st = null;
                            if (this.mRoot.hasSimpleType(this.mPackageName, NamingConversion.getJavaName(child))) {
                                try {
                                    st = this.mRoot.getSimpleType(this.mPackageName, NamingConversion.getJavaName(child));
                                }
                                catch (LoadException e) {
                                    throw new CreateException((Exception)((Object)e));
                                }
                            } else {
                                st = this.createSimpleType((DDDataelement)child).getSimpleType();
                            }
                            field.setReferencedType((DtDataType)st);
                        }
                        if (!(child instanceof DDDomain)) break block33;
                        DDDomain domain = (DDDomain)child;
                        DDObject domainChild = domain.getChild();
                        if (domainChild instanceof DDBuiltInType) {
                            DDBuiltInType builtInType = (DDBuiltInType)domainChild;
                            r3BuiltInType = builtInType.getDatatype();
                            r3Length = builtInType.getDDLeng();
                            r3Decimals = builtInType.getDecimals();
                        }
                        break block34;
                    }
                    if (!(child instanceof DDBuiltInType)) break block32;
                    DDBuiltInType builtInType = (DDBuiltInType)child;
                    r3BuiltInType = builtInType.getDatatype();
                    r3Length = builtInType.getDDLeng();
                    r3Decimals = builtInType.getDecimals();
                }
                String javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
                if (javaBuiltInType == null) {
                    javaBuiltInType = "";
                }
                field.setBuiltInType(javaBuiltInType);
                try {
                    field.setReferencedType((DtDataType)this.mRoot.getSimpleType("com.sap.dictionary", javaBuiltInType));
                }
                catch (LoadException e) {
                    throw new CreateException((Exception)((Object)e));
                }
                if (DataTypeMapping.hasTotalDigits((String)r3BuiltInType)) {
                    int j = DataTypeMapping.getTotalDigits((String)r3BuiltInType);
                    if (j > 0) {
                        field.setTotalDigits(j);
                    } else if (r3Length > 0) {
                        field.setTotalDigits(r3Length);
                    }
                    field.setFractionDigits(r3Decimals);
                } else if (javaBuiltInType.equals("binary") || javaBuiltInType.equals("decimal") || javaBuiltInType.equals("string")) {
                    field.setLength(r3Length);
                }
            }
            ++i;
        }
        structure.setToDeploy(true);
        structure.setBackendName(backendName);
        return returnValue;
    }

    private SimpleType createSimpleType(DDDataelement dDDataelement) throws CreateException {
        String simpleTypeName = dDDataelement.getName();
        String backendName = NamingService.Type.getBackendNameFromABAPName((String)simpleTypeName);
        simpleTypeName = NamingService.Type.getJavaNameFromBackendName((String)backendName);
        DDObject child = dDDataelement.getChild();
        String r3BuiltInType = null;
        int r3Length = 0;
        int r3Decimals = 0;
        Iterator fixedValues = null;
        String javaBuiltInType = null;
        if (child instanceof DDReferenceType) {
            if ((child = child.getChild()) instanceof DDDataelement) {
                child = child.getChild();
            }
            if (child instanceof DDStructure) {
                throw new CreateException("Type is not supported:" + child.getName());
            }
        }
        if (child instanceof DDDomain) {
            DDDomain domain = (DDDomain)child;
            fixedValues = domain.fixedValuesIterator();
            javaBuiltInType = TypeConversionService.convertDataElementWithDomainToJava((DDDataelement)dDDataelement, (DDDomain)domain);
            DDObject domainChild = domain.getChild();
            if (domainChild instanceof DDBuiltInType) {
                DDBuiltInType builtInType = (DDBuiltInType)domainChild;
                r3BuiltInType = builtInType.getDatatype();
                r3Length = builtInType.getDDLeng();
                r3Decimals = builtInType.getDecimals();
            }
        } else if (child instanceof DDBuiltInType) {
            r3BuiltInType = ((DDBuiltInType)child).getDatatype();
            r3Length = ((DDBuiltInType)child).getDDLeng();
            r3Decimals = ((DDBuiltInType)child).getDecimals();
        } else {
            return null;
        }
        if (javaBuiltInType == null) {
            javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
        }
        if (javaBuiltInType == null) {
            javaBuiltInType = "";
        }
        DtSimpleType simpleType = this.mRoot.createSimpleType(this.mPackageName, simpleTypeName);
        simpleType.setTypeName(simpleTypeName);
        simpleType.setLogicalDictionary(this.mLogicalDictionary);
        simpleType.setBuiltInType(javaBuiltInType);
        this.createSchemaType(simpleType, r3BuiltInType, r3Length, r3Decimals, fixedValues);
        JCO.Client client = this.mObjectFactory.getConnection();
        Locale locale = new Locale(client.getLanguage().toLowerCase(), client.getLanguage());
        this.createTextServices(simpleType, (DDObject)dDDataelement, locale);
        this.createExternalRepresentation(simpleType, dDDataelement);
        this.createDbProperty(simpleType);
        this.createTechnicalInfo(simpleType);
        simpleType.setToDeploy(true);
        simpleType.setBackendName(backendName);
        return new SimpleType(simpleType);
    }

    private void createTechnicalInfo(DtSimpleType simpleType) throws CreateException {
        DtTechnicalInfo dtTechnicalInfo = simpleType.createTechnicalInfo();
    }

    private void createDbProperty(DtSimpleType simpleType) throws CreateException {
        DtDbProperty dtDbProperty = simpleType.createDbProperty();
    }

    private void createExternalRepresentation(DtSimpleType simpleType, DDDataelement dataElement) throws CreateException {
        DtExternalRepresentation exRep = simpleType.createExternalRepresentation();
        String javaBuiltInType = simpleType.getBuiltInType();
        if (!(javaBuiltInType.equals("float") || javaBuiltInType.equals("double") || javaBuiltInType.equals("date") || javaBuiltInType.equals("time") || javaBuiltInType.equals("timestamp") || javaBuiltInType.equals("boolean"))) {
            exRep.setMaxExternalLength(dataElement.getOutputlen());
        }
        if (simpleType.getBuiltInType().equals("string")) {
            BooleanEnum value = BooleanEnum.valueOf((String)new Boolean(!dataElement.isLowercaseSet()).toString());
            exRep.setUppercase(value);
        }
    }

    private void createTextServices(DtSimpleType simpleType, DDObject ddObject, Locale locale) throws CreateException {
        try {
            TextServices textservices = new TextServices(ddObject, locale);
            DtTextObject textObject = simpleType.createTexts();
            textObject.setDescription(textservices.getDescription());
            if (textObject.getDescriptionAsTranslatableText() != null) {
                textObject.getDescriptionAsTranslatableText().setDoNotTranslate(true);
            }
            textObject.setColumnLabel(textservices.getColumnLabel());
            if (textObject.getColumnLabelAsTranslatableText() != null) {
                textObject.getColumnLabelAsTranslatableText().setDoNotTranslate(true);
            }
            textObject.setFieldLabel(textservices.getFieldLabel());
            if (textObject.getFieldLabelAsTranslatableText() != null) {
                textObject.getFieldLabelAsTranslatableText().setDoNotTranslate(true);
            }
            textObject.setQuickInfo(textservices.getQuickInfo());
            if (textObject.getQuickInfoAsTranslatableText() != null) {
                textObject.getQuickInfoAsTranslatableText().setDoNotTranslate(true);
            }
        }
        catch (DDTypeNotFoundException e) {
            throw new CreateException((Exception)((Object)e));
        }
    }

    private void createSchemaType(DtSimpleType simpleType, String r3BuiltInType, int r3Length, int r3Decimal, Iterator fixedValues) throws CreateException {
        int i;
        DtSchemaType schemaType = simpleType.createSchemaType();
        if (TypeConversionService.hasSchemaType((String)simpleType.getBuiltInType())) {
            if (DataTypeMapping.hasMaxLength((String)r3BuiltInType)) {
                if (r3Length > 0) {
                    schemaType.setMaxLength(r3Length);
                }
            } else if (DataTypeMapping.hasTotalDigits((String)r3BuiltInType)) {
                i = DataTypeMapping.getTotalDigits((String)r3BuiltInType);
                if (i > 0) {
                    schemaType.setTotalDigits(i);
                } else if (r3Length > 0) {
                    schemaType.setTotalDigits(r3Length);
                }
                schemaType.setFractionDigits(r3Decimal);
            } else {
                i = DataTypeMapping.getLength((String)r3BuiltInType);
                if (i >= 0) {
                    schemaType.setLength(i);
                }
            }
        }
        if (TypeConversionService.hasEnumerationValues((String)simpleType.getBuiltInType()) && fixedValues != null) {
            i = 0;
            while (fixedValues.hasNext()) {
                String valueH;
                DDFixedValue value = (DDFixedValue)fixedValues.next();
                DtEnumerationValue enumValue = schemaType.createEnumerationValue(Integer.toString(i));
                String valueL = value.getFixedValueLow();
                enumValue.setValue(valueL);
                enumValue.setDescription(value.getDescription());
                if (enumValue.getDescriptionAsTranslatableText() != null) {
                    enumValue.getDescriptionAsTranslatableText().setDoNotTranslate(true);
                }
                if ((valueH = value.getFixedValueHigh()).length() > 0) {
                    try {
                        enumValue.delete();
                    }
                    catch (DeleteException e) {
                        e.printStackTrace();
                    }
                    --i;
                }
                ++i;
            }
        }
    }

    public void test() {
        Rfm rfm = null;
        try {
            rfm = this.mObjectFactory.getRfm("UBTEST_F01");
        }
        catch (MetaDataAccessException ex) {
            System.out.println("Exception caught: " + ex.getMessage());
        }
        try {
            RfmParameter rfmParam = rfm.getRfmParameter("F3");
            this.createDdicObject(rfmParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean checkTexts(MainDevelopmentObject oldMdo) {
        if (oldMdo == null) {
            return true;
        }
        TextPool pool = oldMdo.getTextPool();
        if (pool == null) {
            return true;
        }
        TranslatableText[] texts = pool.getTexts();
        int i = 0;
        while (i < texts.length) {
            if (!texts[i].getDoNotTranslate()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

