/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.types.mdi2metamodel;

import com.sap.dictionary.types.mdi.conversions.TypeConversionService;
import com.sap.dictionary.types.mdi.util.DataTypeMapping;
import com.sap.dictionary.types.mdi.util.TextServices;
import com.sap.dictionary.types.mdi2metamodel.NamingConversion;
import com.sap.dictionary.types.services.NamingService;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtDbProperty;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtEnumerationValue;
import com.sap.ide.metamodel.dictionary.datatype.DtExternalRepresentation;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtPrimaryKey;
import com.sap.ide.metamodel.dictionary.datatype.DtSchemaType;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.dictionary.datatype.DtTechnicalInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtTextObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import com.sap.mdi.RfmParameter;
import com.sap.mdi.ddtypes.DDBuiltInType;
import com.sap.mdi.ddtypes.DDDatabaseStructure;
import com.sap.mdi.ddtypes.DDDataelement;
import com.sap.mdi.ddtypes.DDDomain;
import com.sap.mdi.ddtypes.DDFactory;
import com.sap.mdi.ddtypes.DDField;
import com.sap.mdi.ddtypes.DDFixedValue;
import com.sap.mdi.ddtypes.DDFlatStructure;
import com.sap.mdi.ddtypes.DDObject;
import com.sap.mdi.ddtypes.DDReferenceType;
import com.sap.mdi.ddtypes.DDScalarField;
import com.sap.mdi.ddtypes.DDStructure;
import com.sap.mdi.ddtypes.DDTabletype;
import com.sap.mdi.ddtypes.DDTypeNotFoundException;
import com.sap.mw.jco.JCO;
import java.util.Iterator;
import java.util.Locale;

public class R3ToMetamodelDictionaryConverter {
    ObjectFactory mObjectFactory;
    String mPackageName;
    DtDictionaryRoot mRoot;
    DtLogicalDictionary mLogicalDictionary;

    public R3ToMetamodelDictionaryConverter(DtDictionaryRoot root, String packageName, String dictionaryName, String logicalSystemName, ObjectFactory objectFactory) throws CreateException, LoadException {
        this.mObjectFactory = objectFactory;
        this.mPackageName = packageName;
        this.mRoot = root;
        this.mLogicalDictionary = this.createLogicalDictionary(dictionaryName, logicalSystemName);
    }

    public R3ToMetamodelDictionaryConverter(DtDictionaryRoot root, String packageName, String dictionaryName, String logicalSystemName, JCO.Client client) throws ObjectFactoryException, CreateException, LoadException {
        this.mObjectFactory = new ObjectFactory(client);
        this.mPackageName = packageName;
        this.mRoot = root;
        this.mLogicalDictionary = this.createLogicalDictionary(dictionaryName, logicalSystemName);
    }

    private DtLogicalDictionary createLogicalDictionary(String dictionaryName, String logicalSystemName) throws CreateException, LoadException {
        if (dictionaryName.equals("Java Dictionary")) {
            throw new CreateException("Dictionary name: Java Dictionary not allowed");
        }
        if (this.mRoot.hasLogicalDictionary(this.mPackageName, dictionaryName)) {
            return this.mRoot.getLogicalDictionary(this.mPackageName, dictionaryName);
        }
        DtLogicalDictionary logDic = this.mRoot.createLogicalDictionary(this.mPackageName, dictionaryName);
        logDic.setLogicalSystemName(logicalSystemName);
        return logDic;
    }

    public DtLogicalDictionary getLogicalDictionary() {
        return this.mLogicalDictionary;
    }

    public boolean hasDdicObject(String javaName) {
        if (this.mRoot.hasSimpleType(this.mPackageName, javaName)) {
            return true;
        }
        if (this.mRoot.hasStructure(this.mPackageName, javaName)) {
            return true;
        }
        if (this.mRoot.hasTable("", javaName)) {
            return true;
        }
        return this.mRoot.hasView("", javaName);
    }

    public boolean hasDdicObject(RfmParameter parameter) throws CreateException {
        DDObject ddObject = parameter.getDDObject();
        if (ddObject instanceof DDScalarField) {
            ddObject = ddObject.getChild();
        }
        String javaName = NamingConversion.getJavaName(ddObject);
        return this.hasDdicObject(javaName);
    }

    public boolean hasDdicObject(DDObject ddObject) throws CreateException {
        String javaName = NamingConversion.getJavaName(ddObject);
        return this.hasDdicObject(javaName);
    }

    public DtDataType getDdicObject(String javaName) throws LoadException {
        if (this.mRoot.hasSimpleType(this.mPackageName, javaName)) {
            return this.mRoot.getSimpleType(this.mPackageName, javaName);
        }
        if (this.mRoot.hasStructure(this.mPackageName, javaName)) {
            return this.mRoot.getStructure(this.mPackageName, javaName);
        }
        if (this.mRoot.hasTable("", javaName)) {
            return this.mRoot.getTable("", javaName);
        }
        if (this.mRoot.hasView("", javaName)) {
            return this.mRoot.getView("", javaName);
        }
        return null;
    }

    public DtDataType getDdicObject(RfmParameter parameter) throws LoadException, CreateException {
        DDObject ddObject = parameter.getDDObject();
        if (ddObject instanceof DDScalarField) {
            ddObject = ddObject.getChild();
        }
        String javaName = NamingConversion.getJavaName(ddObject);
        return this.getDdicObject(javaName);
    }

    public DtDataType getDdicObject(DDObject ddObject) throws CreateException, LoadException {
        String javaName = NamingConversion.getJavaName(ddObject);
        return this.getDdicObject(javaName);
    }

    public DtDataType createDdicObject(String name) throws CreateException {
        DDFactory ddFactory = this.mObjectFactory.getDDFactory();
        DDObject ddObject = ddFactory.getDDObject(name);
        return this.createObject(ddObject);
    }

    public DtDataType createDdicObject(RfmParameter parameter) throws CreateException {
        DDObject ddObject = parameter.getDDObject();
        return this.createObject(ddObject);
    }

    public DtDataType createObject(DDObject ddObject) throws CreateException {
        if (ddObject instanceof DDDataelement) {
            return this.createSimpleType((DDDataelement)ddObject);
        }
        if (ddObject instanceof DDScalarField) {
            DDScalarField sfield = (DDScalarField)ddObject;
            return this.createSimpleType((DDDataelement)sfield.getChild());
        }
        if (ddObject instanceof DDFlatStructure) {
            return this.createStructure((DDStructure)ddObject);
        }
        if (ddObject instanceof DDTabletype) {
            if ((ddObject = ddObject.getChild()) instanceof DDFlatStructure) {
                return this.createStructure((DDStructure)ddObject);
            }
        } else if (ddObject instanceof DDDatabaseStructure) {
            return this.createDbTable((DDDatabaseStructure)ddObject);
        }
        if (ddObject == null) {
            throw new CreateException("ddic object not found");
        }
        throw new CreateException("ddic object not supported");
    }

    private DtDataType createDbTable(DDDatabaseStructure ddObject) throws CreateException {
        String tableName = ddObject.getName();
        String backEndName = NamingService.Structure.getBackendNameFromABAPName((String)tableName);
        tableName = NamingService.Structure.getJavaNameFromBackendName((String)backEndName);
        DtDbTable dtDbTable = this.mRoot.createTable("", tableName);
        dtDbTable.setBackendName(backEndName);
        dtDbTable.setLogicalDictionary(this.mLogicalDictionary);
        dtDbTable.setDescription(ddObject.getDescription());
        int fieldCount = ddObject.getNumberOfFields();
        int i = 1;
        while (i <= fieldCount) {
            block18: {
                int r3Decimals;
                int r3Length;
                String r3BuiltInType;
                DtField field;
                block17: {
                    DDObject child;
                    block16: {
                        DDScalarField scField;
                        DDField ddField = ddObject.getField(i);
                        String fieldName = ddField.getName();
                        String backendFieldName = NamingService.Field.getBackendNameFromABAPName((String)fieldName);
                        fieldName = NamingService.Field.getJavaNameFromBackendName((String)backendFieldName);
                        field = dtDbTable.createStructureElementAsDtField(fieldName);
                        field.setBackendName(backendFieldName);
                        if (ddField instanceof DDScalarField && (scField = (DDScalarField)ddField).isKeyfield()) {
                            DtPrimaryKey prKey = null;
                            prKey = !dtDbTable.hasPrimaryKey() ? dtDbTable.createPrimaryKey() : dtDbTable.getPrimaryKey();
                            prKey.addKeyElement((DtStructureElement)field);
                        }
                        field.setPosition(ddField.getPosition() - 1);
                        field.setDescription(ddField.getFieldtext());
                        child = ddField.getChild();
                        r3BuiltInType = null;
                        r3Length = 0;
                        r3Decimals = 0;
                        if (child instanceof DDReferenceType) {
                            DDReferenceType refType = (DDReferenceType)child;
                            if ((child = child.getChild()) instanceof DDDatabaseStructure || child instanceof DDTabletype || child instanceof DDFlatStructure) {
                                // empty if block
                            }
                        }
                        if (child instanceof DDDataelement) {
                            child = child.getChild();
                        }
                        if (!(child instanceof DDDomain)) break block16;
                        DDDomain domain = (DDDomain)child;
                        DDObject domainChild = domain.getChild();
                        if (domainChild instanceof DDBuiltInType) {
                            DDBuiltInType builtInType = (DDBuiltInType)domainChild;
                            r3BuiltInType = builtInType.getDatatype();
                            r3Length = builtInType.getDDLeng();
                            r3Decimals = builtInType.getDecimals();
                        }
                        break block17;
                    }
                    if (!(child instanceof DDBuiltInType)) break block18;
                    DDBuiltInType builtInType = (DDBuiltInType)child;
                    r3BuiltInType = builtInType.getDatatype();
                    r3Length = builtInType.getDDLeng();
                    r3Decimals = builtInType.getDecimals();
                }
                String javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
                if (javaBuiltInType == null) {
                    javaBuiltInType = "";
                }
                field.setBuiltInType(javaBuiltInType);
                try {
                    field.setReferencedType((DtDataType)this.mRoot.getSimpleType("com.sap.dictionary", javaBuiltInType));
                }
                catch (LoadException e) {
                    throw new CreateException((Exception)((Object)e));
                }
                if (DataTypeMapping.hasTotalDigits((String)r3BuiltInType)) {
                    int j = DataTypeMapping.getTotalDigits((String)r3BuiltInType);
                    if (j > 0) {
                        field.setTotalDigits(j);
                    } else if (r3Length > 0) {
                        field.setTotalDigits(r3Length);
                    }
                    field.setFractionDigits(r3Decimals);
                } else if (javaBuiltInType.equals("binary") || javaBuiltInType.equals("decimal") || javaBuiltInType.equals("string")) {
                    field.setLength(r3Length);
                }
            }
            ++i;
        }
        dtDbTable.setToDeploy(true);
        return dtDbTable;
    }

    private DtDataType createStructure(DDStructure dDStructure) throws CreateException {
        String structureName = dDStructure.getName();
        String backendName = NamingService.Structure.getBackendNameFromABAPName((String)structureName);
        structureName = NamingService.Structure.getJavaNameFromBackendName((String)backendName);
        DtGeneralStructure structure = this.mRoot.createStructure(this.mPackageName, structureName);
        structure.setLogicalDictionary(this.mLogicalDictionary);
        structure.setDescription(dDStructure.getDescription());
        int fieldCount = dDStructure.getNumberOfFields();
        int i = 1;
        while (i <= fieldCount) {
            block21: {
                int r3Decimals;
                int r3Length;
                String r3BuiltInType;
                DtField field;
                block20: {
                    DDObject child;
                    block19: {
                        DDField ddField = dDStructure.getField(i);
                        String fieldName = ddField.getName();
                        String backendFieldName = NamingService.Field.getBackendNameFromABAPName((String)fieldName);
                        fieldName = NamingService.Field.getJavaNameFromBackendName((String)backendFieldName);
                        field = structure.createStructureElementAsDtField(fieldName);
                        field.setBackendName(backendFieldName);
                        field.setPosition(ddField.getPosition() - 1);
                        field.setDescription(ddField.getFieldtext());
                        child = ddField.getChild();
                        r3BuiltInType = null;
                        r3Length = 0;
                        r3Decimals = 0;
                        if (child instanceof DDReferenceType) {
                            DDReferenceType refType = (DDReferenceType)child;
                            if ((child = child.getChild()) instanceof DDDatabaseStructure || child instanceof DDTabletype || child instanceof DDFlatStructure) {
                                // empty if block
                            }
                        }
                        if (child instanceof DDDataelement) {
                            DtSimpleType st = null;
                            if (this.mRoot.hasSimpleType(this.mPackageName, NamingConversion.getJavaName(child))) {
                                try {
                                    st = this.mRoot.getSimpleType(this.mPackageName, NamingConversion.getJavaName(child));
                                }
                                catch (LoadException e) {
                                    throw new CreateException((Exception)((Object)e));
                                }
                            } else {
                                st = (DtSimpleType)this.createSimpleType((DDDataelement)child);
                            }
                            field.setReferencedType((DtDataType)st);
                        }
                        if (!(child instanceof DDDomain)) break block19;
                        DDDomain domain = (DDDomain)child;
                        DDObject domainChild = domain.getChild();
                        if (domainChild instanceof DDBuiltInType) {
                            DDBuiltInType builtInType = (DDBuiltInType)domainChild;
                            r3BuiltInType = builtInType.getDatatype();
                            r3Length = builtInType.getDDLeng();
                            r3Decimals = builtInType.getDecimals();
                        }
                        break block20;
                    }
                    if (!(child instanceof DDBuiltInType)) break block21;
                    DDBuiltInType builtInType = (DDBuiltInType)child;
                    r3BuiltInType = builtInType.getDatatype();
                    r3Length = builtInType.getDDLeng();
                    r3Decimals = builtInType.getDecimals();
                }
                String javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
                if (javaBuiltInType == null) {
                    javaBuiltInType = "";
                }
                field.setBuiltInType(javaBuiltInType);
                try {
                    field.setReferencedType((DtDataType)this.mRoot.getSimpleType("com.sap.dictionary", javaBuiltInType));
                }
                catch (LoadException e) {
                    throw new CreateException((Exception)((Object)e));
                }
                if (DataTypeMapping.hasTotalDigits((String)r3BuiltInType)) {
                    int j = DataTypeMapping.getTotalDigits((String)r3BuiltInType);
                    if (j > 0) {
                        field.setTotalDigits(j);
                    } else if (r3Length > 0) {
                        field.setTotalDigits(r3Length);
                    }
                    field.setFractionDigits(r3Decimals);
                } else if (javaBuiltInType.equals("binary") || javaBuiltInType.equals("decimal") || javaBuiltInType.equals("string")) {
                    field.setLength(r3Length);
                }
            }
            ++i;
        }
        structure.setToDeploy(true);
        structure.setBackendName(backendName);
        return structure;
    }

    private DtDataType createSimpleType(DDDataelement dDDataelement) throws CreateException {
        String simpleTypeName = dDDataelement.getName();
        String backendName = NamingService.Type.getBackendNameFromABAPName((String)simpleTypeName);
        simpleTypeName = NamingService.Type.getJavaNameFromBackendName((String)backendName);
        DDObject child = dDDataelement.getChild();
        String r3BuiltInType = null;
        int r3Length = 0;
        int r3Decimals = 0;
        Iterator fixedValues = null;
        String javaBuiltInType = null;
        if (child instanceof DDDomain) {
            DDDomain domain = (DDDomain)child;
            fixedValues = domain.fixedValuesIterator();
            javaBuiltInType = TypeConversionService.convertDataElementWithDomainToJava((DDDataelement)dDDataelement, (DDDomain)domain);
            DDObject domainChild = domain.getChild();
            if (domainChild instanceof DDBuiltInType) {
                DDBuiltInType builtInType = (DDBuiltInType)domainChild;
                r3BuiltInType = builtInType.getDatatype();
                r3Length = builtInType.getDDLeng();
                r3Decimals = builtInType.getDecimals();
            }
        } else if (child instanceof DDBuiltInType) {
            r3BuiltInType = ((DDBuiltInType)child).getDatatype();
            r3Length = ((DDBuiltInType)child).getDDLeng();
            r3Decimals = ((DDBuiltInType)child).getDecimals();
        } else {
            return null;
        }
        if (javaBuiltInType == null) {
            javaBuiltInType = DataTypeMapping.getJavaBuiltInType((String)r3BuiltInType);
        }
        if (javaBuiltInType == null) {
            javaBuiltInType = "";
        }
        DtSimpleType simpleType = this.mRoot.createSimpleType(this.mPackageName, simpleTypeName);
        simpleType.setTypeName(simpleTypeName);
        simpleType.setLogicalDictionary(this.mLogicalDictionary);
        simpleType.setBuiltInType(javaBuiltInType);
        this.createSchemaType(simpleType, r3BuiltInType, r3Length, r3Decimals, fixedValues);
        JCO.Client client = this.mObjectFactory.getConnection();
        Locale locale = new Locale(client.getLanguage().toLowerCase(), client.getLanguage());
        this.createTextServices(simpleType, (DDObject)dDDataelement, locale);
        this.createExternalRepresentation(simpleType, dDDataelement);
        this.createDbProperty(simpleType);
        this.createTechnicalInfo(simpleType);
        simpleType.setToDeploy(true);
        simpleType.setBackendName(backendName);
        return simpleType;
    }

    private void createTechnicalInfo(DtSimpleType simpleType) throws CreateException {
        DtTechnicalInfo dtTechnicalInfo = simpleType.createTechnicalInfo();
    }

    private void createDbProperty(DtSimpleType simpleType) throws CreateException {
        DtDbProperty dtDbProperty = simpleType.createDbProperty();
    }

    private void createExternalRepresentation(DtSimpleType simpleType, DDDataelement dataElement) throws CreateException {
        DtExternalRepresentation exRep = simpleType.createExternalRepresentation();
        String javaBuiltInType = simpleType.getBuiltInType();
        if (!(javaBuiltInType.equals("float") || javaBuiltInType.equals("double") || javaBuiltInType.equals("date") || javaBuiltInType.equals("time") || javaBuiltInType.equals("timestamp") || javaBuiltInType.equals("boolean"))) {
            exRep.setMaxExternalLength(dataElement.getOutputlen());
        }
        if (simpleType.getBuiltInType().equals("string")) {
            BooleanEnum value = BooleanEnum.valueOf((String)new Boolean(!dataElement.isLowercaseSet()).toString());
            exRep.setUppercase(value);
        }
    }

    private void createTextServices(DtSimpleType simpleType, DDObject ddObject, Locale locale) throws CreateException {
        try {
            TextServices textservices = new TextServices(ddObject, locale);
            DtTextObject textObject = simpleType.createTexts();
            textObject.setDescription(textservices.getDescription());
            textObject.setColumnLabel(textservices.getColumnLabel());
            textObject.setFieldLabel(textservices.getFieldLabel());
            textObject.setQuickInfo(textservices.getQuickInfo());
        }
        catch (DDTypeNotFoundException e) {
            throw new CreateException((Exception)((Object)e));
        }
    }

    private void createSchemaType(DtSimpleType simpleType, String r3BuiltInType, int r3Length, int r3Decimal, Iterator fixedValues) throws CreateException {
        int i;
        DtSchemaType schemaType = simpleType.createSchemaType();
        if (TypeConversionService.hasSchemaType((String)simpleType.getBuiltInType())) {
            if (DataTypeMapping.hasMaxLength((String)r3BuiltInType)) {
                if (r3Length > 0) {
                    schemaType.setMaxLength(r3Length);
                }
            } else if (DataTypeMapping.hasTotalDigits((String)r3BuiltInType)) {
                i = DataTypeMapping.getTotalDigits((String)r3BuiltInType);
                if (i > 0) {
                    schemaType.setTotalDigits(i);
                } else if (r3Length > 0) {
                    schemaType.setTotalDigits(r3Length);
                }
                schemaType.setFractionDigits(r3Decimal);
            } else {
                i = DataTypeMapping.getLength((String)r3BuiltInType);
                if (i >= 0) {
                    schemaType.setLength(i);
                }
            }
        }
        if (TypeConversionService.hasEnumerationValues((String)simpleType.getBuiltInType()) && fixedValues != null) {
            i = 0;
            while (fixedValues.hasNext()) {
                DDFixedValue value = (DDFixedValue)fixedValues.next();
                DtEnumerationValue enumValue = schemaType.createEnumerationValue(Integer.toString(i));
                String valueL = value.getFixedValueLow();
                enumValue.setValue(valueL);
                enumValue.setDescription(value.getDescription());
                String valueH = value.getFixedValueHigh();
                if (valueH.length() > 0) {
                    enumValue = schemaType.createEnumerationValue(Integer.toString(++i));
                    enumValue.setValue(valueH);
                    enumValue.setDescription(value.getDescription());
                }
                ++i;
            }
        }
    }
}

