/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc;

import com.sap.lcr.namealloc.api.NameSyntaxViolation;

public class VendorPropertySyntaxChecker {
    private static final int MAX_NAME_LENGTH = 20;
    private static final String[] INNER_CHARSET = new String[]{"AlphaNum", ".", "-"};
    private static final String[] START_CHARSET = new String[]{"Alpha"};
    private static final int ZERO_CHAR = Character.getNumericValue('0');
    private static final int NINE_CHAR = Character.getNumericValue('9');
    private static final int CAPITAL_A_CHAR = Character.getNumericValue('A');
    private static final int CAPITAL_Z_CHAR = Character.getNumericValue('Z');
    private static final int LOWER_A_CHAR = Character.getNumericValue('a');
    private static final int LOWER_Z_CHAR = Character.getNumericValue('z');

    public static void checkVendorSyntax(String vendorName) throws NameSyntaxViolation {
        if (vendorName == null || vendorName.length() < 1) {
            throw new NameSyntaxViolation("Empty vendor name is not allowed");
        }
        if (vendorName.length() > 20) {
            throw new NameSyntaxViolation("Vendor name too long (max. of 20 characters): " + vendorName);
        }
        if (!vendorName.equals(vendorName.toLowerCase())) {
            throw new NameSyntaxViolation("Vendor name must be spelled lower case: " + vendorName);
        }
        int j = 0;
        while (j < vendorName.length()) {
            char nextChar = vendorName.charAt(j);
            boolean valid = j == 0 ? VendorPropertySyntaxChecker.isInsideCharacterSet(nextChar, START_CHARSET) : VendorPropertySyntaxChecker.isInsideCharacterSet(nextChar, INNER_CHARSET);
            if (!valid) {
                throw new NameSyntaxViolation("Illegal character \"" + nextChar + "\" at position " + j + " in vendor name \"" + vendorName + "\"");
            }
            ++j;
        }
    }

    public static boolean isInsideCharacterSet(char aChar, String[] aCharSet) {
        int k = 0;
        while (k < aCharSet.length) {
            if (aCharSet[k].length() == 1) {
                if (aCharSet[k].charAt(0) == aChar) {
                    return true;
                }
            } else {
                int nuc;
                if (aCharSet[k].equalsIgnoreCase("ALL")) {
                    return true;
                }
                if (aCharSet[k].equalsIgnoreCase("ALPHANUM") ? (nuc = Character.getNumericValue(aChar)) >= ZERO_CHAR && nuc <= NINE_CHAR || nuc >= CAPITAL_A_CHAR && nuc <= CAPITAL_Z_CHAR || nuc >= LOWER_A_CHAR && nuc <= LOWER_Z_CHAR : (aCharSet[k].equalsIgnoreCase("ALPHA") ? (nuc = Character.getNumericValue(aChar)) >= CAPITAL_A_CHAR && nuc <= CAPITAL_Z_CHAR || nuc >= LOWER_A_CHAR && nuc <= LOWER_Z_CHAR : (aCharSet[k].equals("A-Z") ? (nuc = Character.getNumericValue(aChar)) >= CAPITAL_A_CHAR && nuc <= CAPITAL_Z_CHAR : (aCharSet[k].equals("a-z") ? (nuc = Character.getNumericValue(aChar)) >= LOWER_A_CHAR && nuc <= LOWER_Z_CHAR : aCharSet[k].equals("0-9") && (nuc = Character.getNumericValue(aChar)) >= ZERO_CHAR && nuc <= NINE_CHAR)))) {
                    return true;
                }
            }
            ++k;
        }
        return false;
    }
}

