/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc;

import com.sap.lcr.api.cimclient.CIMHttp;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.NameCharacteristic;
import com.sap.lcr.namealloc.api.AllocationState;
import com.tssap.dtr.client.lib.protocol.URL;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.naming.CompoundName;

public class TstAlloc {
    public static void main(String[] args) {
        NameAllocator allocator = null;
        BufferedReader in = null;
        String nameCategory = "X";
        String name = "Y";
        try {
            String pwd;
            String user;
            int iport;
            String port;
            in = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Enter connect parameters to name server:");
            System.out.println("");
            System.out.print(" host = ");
            String host = in.readLine();
            if (host.equals("p58468")) {
                port = "1080";
                iport = 1080;
                user = "Administrator";
                pwd = "";
            } else {
                System.out.print(" port = ");
                port = in.readLine();
                iport = Integer.parseInt(port);
                System.out.print(" user = ");
                user = in.readLine();
                System.out.print(" password = ");
                pwd = in.readLine();
            }
            System.out.println("");
            System.out.println("Enter name reservation parameters:");
            System.out.println("");
            System.out.print(" category = ");
            nameCategory = in.readLine();
            System.out.print(" name = ");
            name = in.readLine();
            allocator = new NameAllocator(host, iport, user, pwd);
            URL stdURL = new URL("http", host, iport, "");
            URL expURL = CIMHttp.setPartition((URL)stdURL, (String)"sld/extra");
            CIMHttp.getPartition((URL)expURL);
            URL xURL = new URL("http://testserver:56789/sld/cimom?p1=v1&p2=v2&p3=v3#xRef");
            URL xexpURL = CIMHttp.setPartition((URL)xURL, (String)"sld/extra");
            CIMHttp.getPartition((URL)xexpURL);
            URL strippedURL = CIMHttp.setPartition((URL)xexpURL, null);
            CIMHttp.getPartition((URL)strippedURL);
            AllocationState result = allocator.createContext("firstcontext");
            TstAlloc.printAllocationState(result, "Create first context");
            result = allocator.createContext("firstcontext");
            TstAlloc.printAllocationState(result, "Recreate first context");
            System.out.println("");
            System.out.println("Allowed prefixes for category " + nameCategory);
            System.out.println("-----------------------------------------------------");
            CompoundName[] compoundNames = allocator.listAllowedPrefixes(nameCategory, true);
            int i = 0;
            while (i < compoundNames.length) {
                System.out.println("Allowed prefix = " + compoundNames[i].toString());
                ++i;
            }
            System.out.println("");
            System.out.println("-----------------------------------------------------");
            result = allocator.getAllocationState(nameCategory, name);
            TstAlloc.printAllocationState(result, " get current allocation state");
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        try {
            AllocationState result = allocator.reservePreliminary(nameCategory, name, "TestUser", "Test reservation", "XXX", null, null);
            TstAlloc.printAllocationState(result, " preliminary reservation state");
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        try {
            System.out.println("");
            System.out.println("Enter test category for prefix overlap:");
            System.out.println("");
            System.out.print(" category = ");
            String overlapCategory = in.readLine();
            System.out.println("");
            System.out.println("Enter first test prefix for overlap test:");
            System.out.println("");
            System.out.print(" prefix_1 = ");
            String sprefix1 = in.readLine();
            System.out.println("");
            System.out.println("Enter second test prefix for overlap test:");
            System.out.println("");
            System.out.print(" prefix_2 = ");
            String sprefix2 = in.readLine();
            NameCharacteristic namcha = allocator.getNameCharacteristic(overlapCategory);
            CompoundName prefix1 = allocator.getMyNameServerUtil().createCompoundNameFromString(sprefix1, namcha);
            CompoundName prefix2 = allocator.getMyNameServerUtil().createCompoundNameFromString(sprefix2, namcha);
            boolean overlapping = allocator.arePrefixesDisjoint(prefix1, prefix2);
            System.out.println("");
            System.out.println("-----------------------------------------------------");
            System.out.println("Prefixes intersection free = " + overlapping);
            CompoundName[] clashingPrefixes = allocator.evaluatePrefixIntersections(overlapCategory, sprefix1);
            int jov = 0;
            while (jov < clashingPrefixes.length) {
                System.out.println("Overlap with prefix 1: " + clashingPrefixes[jov]);
                ++jov;
            }
            clashingPrefixes = allocator.evaluatePrefixIntersections(overlapCategory, sprefix2);
            int jov2 = 0;
            while (jov2 < clashingPrefixes.length) {
                System.out.println("Overlap with prefix 2: " + clashingPrefixes[jov2]);
                ++jov2;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public static void printAllocationState(AllocationState state, String action) {
        System.out.println(" >>>>> Result of " + action + " <<<<<");
        System.out.println("Context           = " + state.getContext());
        System.out.println("Context key       = " + state.getContextKey());
        System.out.println("Context open      = " + state.isContextOpen());
        System.out.println("Name category     = " + state.getNameCategory());
        System.out.println("Flat name         = " + state.getFlatName());
        System.out.println("CIM name          = " + state.getCimName());
        CompoundName compname = state.getCompoundName();
        if (compname != null) {
            System.out.println("Compound name     = " + compname.toString());
        }
        if (state.isFlatName()) {
            System.out.println("Name type         = flat name");
        } else {
            System.out.println("Name type         = compound name");
            if (state.isGrowingProtected()) {
                System.out.println("Branch protection = yes");
            } else {
                System.out.println("Branch protection = no");
            }
        }
        System.out.println("Caption           = " + state.getCaption());
        System.out.println("Description       = " + state.getDescription());
        System.out.println("Reservation key   = " + state.getReservationKey());
        System.out.println("Owner             = " + state.getUserId());
        if (state.isReserved()) {
            if (state.isReservedFinally()) {
                System.out.println("State             = finally reserved");
            } else {
                System.out.println("State             = preliminary reserved");
            }
        } else {
            System.out.println("State             = not reserved");
        }
    }
}

