/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc;

import com.sap.lcr.namealloc.NameCharacteristic;
import com.sap.lcr.namealloc.NameServerUtil;
import com.sap.lcr.namealloc.api.IExtendedSyntaxCheck;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import javax.naming.CompoundName;

public class SoftwareComponentSyntaxChecker
implements IExtendedSyntaxCheck {
    private static final int MAX_NAME_LENGTH = 30;

    public void checkSyntax(CompoundName compoundName) throws NameSyntaxViolation {
        String secondComp;
        if (compoundName.size() < 1) {
            throw new NameSyntaxViolation("Empty software component name is not allowed");
        }
        int i = 1;
        while (i < compoundName.size()) {
            if (compoundName.get(i).length() < 1) {
                throw new NameSyntaxViolation("Empty name component (" + i + ") is not allowed, software component name = " + compoundName.toString());
            }
            ++i;
        }
        char firstChar = '\u0000';
        String firstComp = compoundName.get(0);
        if (firstComp.length() > 0) {
            firstChar = firstComp.charAt(0);
        } else if (compoundName.size() > 1 && (secondComp = compoundName.get(1)).length() > 0) {
            firstChar = secondComp.charAt(0);
        }
        if (Character.isDigit(firstChar)) {
            throw new NameSyntaxViolation("First character must not be a digit (" + firstChar + ") in software component name " + compoundName.toString());
        }
        String flatName = compoundName.toString();
        if (flatName.length() > 30) {
            throw new NameSyntaxViolation("SC name too long (max. of 30 characters): " + flatName);
        }
        if (!this.checkNameSpelledUpperCase(compoundName)) {
            throw new NameSyntaxViolation("Name must be spelled upper case: " + compoundName.toString());
        }
    }

    private boolean checkNameSpelledUpperCase(CompoundName compoundName) {
        int i = 0;
        while (i < compoundName.size()) {
            String comp = compoundName.get(i);
            if (!comp.equals(comp.toUpperCase())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void checkNameSyntax(String scName) throws NameSyntaxViolation {
        NameCharacteristic namcha = new NameCharacteristic("SAP_SoftwareComponentName");
        namcha.setMyCharacterSet(new String[]{"AlphaNum", "_", "$", ".", "-", "!", "~"});
        namcha.setMyCompoundFlag(true);
        namcha.setMyIgnoreCase(true);
        namcha.setMySeparator("/");
        namcha.setMyExtendedSyntaxCheck(new SoftwareComponentSyntaxChecker());
        CompoundName scCompoundName = NameServerUtil.createCompoundNameWithCharacteristic(scName, namcha);
        NameServerUtil.checkNameSyntax(scCompoundName, namcha);
    }
}

