/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMPropertyArray;
import com.sap.lcr.api.cim.CIMValue;
import com.sap.lcr.api.cim.CIMValueArray;
import com.sap.lcr.namealloc.NameAllocationConstants;
import com.sap.lcr.namealloc.api.IExtendedSyntaxCheck;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import java.util.Iterator;

public class NameCharacteristic
implements NameAllocationConstants {
    private String myNameCategory;
    private boolean myCompoundFlag = false;
    private String mySeparator = null;
    private String myEscape = null;
    private boolean myIgnoreCase = false;
    String[] myCharacterSet = null;
    CIMClass myCIMClass = null;
    IExtendedSyntaxCheck myExtendedSyntaxCheck = null;

    public NameCharacteristic(String category) {
        this.myNameCategory = category;
    }

    public static NameCharacteristic createCharacteristicFromCIMClass(CIMClass aClass) throws NameSyntaxViolation {
        CIMValueArray charSetVA;
        NameCharacteristic result = new NameCharacteristic(aClass.getClassname());
        result.myCIMClass = aClass;
        Iterator propIter = aClass.getPropertyIterator();
        while (propIter.hasNext()) {
            CIMValue nextValue;
            CIMProperty nextProperty = (CIMProperty)propIter.next();
            String propName = nextProperty.getName();
            if (propName.equalsIgnoreCase("CompoundName")) {
                nextValue = nextProperty.getCIMValue();
                if (nextValue == null) continue;
                result.myCompoundFlag = nextValue.isTrue();
                continue;
            }
            if (propName.equalsIgnoreCase("Separator")) {
                result.mySeparator = nextProperty.getValue();
                continue;
            }
            if (propName.equalsIgnoreCase("Escape")) {
                result.myEscape = nextProperty.getValue();
                continue;
            }
            if (!propName.equalsIgnoreCase("IgnoreCase") || (nextValue = nextProperty.getCIMValue()) == null) continue;
            result.myIgnoreCase = nextValue.isTrue();
        }
        CIMPropertyArray charSetPA = aClass.getPropertyArrayByName("CharacterSet");
        if (charSetPA != null && (charSetVA = charSetPA.getValueArray()) != null) {
            String[] charSetStrA = new String[charSetVA.size()];
            int i = 0;
            while (i < charSetVA.size()) {
                CIMValue nextVal = charSetVA.get(i);
                charSetStrA[i] = nextVal.getStringvalue();
                ++i;
            }
            result.myCharacterSet = charSetStrA;
        }
        if (result.mySeparator == null && result.myCompoundFlag) {
            throw new NameSyntaxViolation("Missing separator for name category " + result.getMyNameCategory());
        }
        return result;
    }

    public String getMyNameCategory() {
        return this.myNameCategory;
    }

    public CIMClass getMyCIMClass() {
        return this.myCIMClass;
    }

    public boolean getMyCompoundFlag() {
        return this.myCompoundFlag;
    }

    public void setMyCompoundFlag(boolean flag) {
        this.myCompoundFlag = flag;
    }

    public String getMySeparator() {
        return this.mySeparator;
    }

    public void setMySeparator(String separator) {
        this.mySeparator = separator;
    }

    public String getMyEscape() {
        return this.myEscape;
    }

    public void setMyEscape(String escape) {
        this.myEscape = escape;
    }

    public boolean getMyIgnoreCase() {
        return this.myIgnoreCase;
    }

    public void setMyIgnoreCase(boolean flag) {
        this.myIgnoreCase = flag;
    }

    public String[] getMyCharacterSet() {
        return this.myCharacterSet;
    }

    public void setMyCharacterSet(String[] charset) {
        this.myCharacterSet = charset;
    }

    public IExtendedSyntaxCheck getMyExtendedSyntaxCheck() {
        return this.myExtendedSyntaxCheck;
    }

    public void setMyExtendedSyntaxCheck(IExtendedSyntaxCheck extCheck) {
        this.myExtendedSyntaxCheck = extCheck;
    }
}

