/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lcr.namealloc;

import com.sap.lcr.api.cim.CIMClass;
import com.sap.lcr.api.cim.CIMFactory;
import com.sap.lcr.api.cim.CIMInstance;
import com.sap.lcr.api.cim.CIMInstancename;
import com.sap.lcr.api.cim.CIMKeybinding;
import com.sap.lcr.api.cim.CIMKeybindingList;
import com.sap.lcr.api.cim.CIMLocalnamespacepath;
import com.sap.lcr.api.cim.CIMNamespacepath;
import com.sap.lcr.api.cim.CIMProperty;
import com.sap.lcr.api.cim.CIMValueNamedInstance;
import com.sap.lcr.api.cim.CIMValueObjectWithPath;
import com.sap.lcr.api.cim.CIMValueReference;
import com.sap.lcr.api.cim.ICIMObjectContainer;
import com.sap.lcr.api.cim.ItemConstructionExcp;
import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientException;
import com.sap.lcr.api.cimclient.CIMServerPing;
import com.sap.lcr.api.cimclient.CIMTraceUtil;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.cimclient.IRequestSender;
import com.sap.lcr.api.cimclient.LcrException;
import com.sap.lcr.api.cimclient.UnauthorizedUserException;
import com.sap.lcr.api.log.Logger;
import com.sap.lcr.namealloc.DBTableSyntaxChecker;
import com.sap.lcr.namealloc.DesignTimePackageSyntaxChecker;
import com.sap.lcr.namealloc.DevelopmentComponentSyntaxChecker;
import com.sap.lcr.namealloc.NameAllocationConstants;
import com.sap.lcr.namealloc.NameCharacteristic;
import com.sap.lcr.namealloc.NameServerUtil;
import com.sap.lcr.namealloc.NamespacePrefix;
import com.sap.lcr.namealloc.SoftwareComponentSyntaxChecker;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.lcr.namealloc.api.ForeignContextException;
import com.sap.lcr.namealloc.api.INameAllocation;
import com.sap.lcr.namealloc.api.NameNotFoundException;
import com.sap.lcr.namealloc.api.NameSyntaxViolation;
import com.sap.lcr.namealloc.api.NotOwnerException;
import com.sap.lcr.namealloc.api.ReservedBeforeException;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.URL;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.naming.CompoundName;

public class NameAllocator
implements INameAllocation,
NameAllocationConstants {
    private static final Logger myLogger = Logger.getLogger((String)(class$com$sap$lcr$namealloc$NameAllocator == null ? (class$com$sap$lcr$namealloc$NameAllocator = NameAllocator.class$("com.sap.lcr.namealloc.NameAllocator")) : class$com$sap$lcr$namealloc$NameAllocator).getName());
    private static final Random myRandom = new Random();
    private CIMClient myCIMClient;
    private String myServerHost;
    private int myServerPort;
    private String myConnectUser;
    private HashMap myCategoryMap = new HashMap();
    private HashMap myPrefixMap = new HashMap();
    private NameServerUtil myNameServerUtil;
    private String myObjectServerName = null;
    private CIMValueNamedInstance[] allAllowedPrefixes = null;
    private boolean branchProtectionOpenForOwner = true;
    static /* synthetic */ Class class$com$sap$lcr$namealloc$NameAllocator;

    public NameAllocator(java.net.URL aUrl, String aUser, String aPwd) throws CommunicationFailureException {
        try {
            ClientFactory clientfactory = ClientFactory.newInstance();
            this.myCIMClient = new CIMClient(clientfactory.createClient(aUrl, aUser, aPwd));
            this.myServerHost = this.myCIMClient.getHost();
            this.myServerPort = this.myCIMClient.getPort();
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        this.initAll(aUser);
    }

    public NameAllocator(URL aUrl, String aUser, String aPwd) throws CommunicationFailureException {
        try {
            ClientFactory clientfactory = ClientFactory.newInstance();
            this.myCIMClient = new CIMClient(clientfactory.createClient(aUrl, aUser, aPwd));
            this.myServerHost = this.myCIMClient.getHost();
            this.myServerPort = this.myCIMClient.getPort();
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        this.initAll(aUser);
    }

    public NameAllocator(java.net.URL aUrl, String aUser, String aPwd, KeyStore scstore) throws CommunicationFailureException {
        try {
            ClientFactory clientfactory = ClientFactory.newInstance();
            this.myCIMClient = new CIMClient(clientfactory.createClient(aUrl, scstore, aUser, aPwd));
            this.myServerHost = this.myCIMClient.getHost();
            this.myServerPort = this.myCIMClient.getPort();
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        this.initAll(aUser);
    }

    public NameAllocator(URL aUrl, String aUser, String aPwd, KeyStore scstore) throws CommunicationFailureException {
        try {
            ClientFactory clientfactory = ClientFactory.newInstance();
            this.myCIMClient = new CIMClient(clientfactory.createClient(aUrl, scstore, aUser, aPwd));
            this.myServerHost = this.myCIMClient.getHost();
            this.myServerPort = this.myCIMClient.getPort();
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        this.initAll(aUser);
    }

    public NameAllocator(java.net.URL aUrl, String aUser, String aPwd, String trustStore, String keyStore) throws CommunicationFailureException {
        try {
            ClientFactory clientfactory = ClientFactory.newInstance();
            clientfactory.configureEngineKeyStores(trustStore, keyStore);
            this.myCIMClient = new CIMClient(clientfactory.createClient(aUrl, aUser, aPwd));
            this.myServerHost = this.myCIMClient.getHost();
            this.myServerPort = this.myCIMClient.getPort();
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        this.initAll(aUser);
    }

    public NameAllocator(URL aUrl, String aUser, String aPwd, String trustStore, String keyStore) throws CommunicationFailureException {
        try {
            ClientFactory clientfactory = ClientFactory.newInstance();
            clientfactory.configureEngineKeyStores(trustStore, keyStore);
            this.myCIMClient = new CIMClient(clientfactory.createClient(aUrl, aUser, aPwd));
            this.myServerHost = this.myCIMClient.getHost();
            this.myServerPort = this.myCIMClient.getPort();
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        this.initAll(aUser);
    }

    public NameAllocator(String aHost, int aPort, String aUser, String aPwd) throws CommunicationFailureException {
        try {
            this.myCIMClient = new CIMClient(ClientFactory.newInstance().createClient(ClientFactory.newSAPHttpURL((String)aHost, (int)aPort), aUser, aPwd));
            this.myServerHost = aHost;
            this.myServerPort = aPort;
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        this.initAll(aUser);
    }

    public NameAllocator(CIMClient aCIMClient, String aUser) throws CommunicationFailureException {
        this.myCIMClient = aCIMClient;
        this.myServerHost = aCIMClient.getHost();
        this.myServerPort = aCIMClient.getPort();
        this.initAll(aUser);
    }

    public NameAllocator(IRequestSender aRequestSender, String aUser) throws CommunicationFailureException {
        this.myCIMClient = new CIMClient(aRequestSender);
        this.myServerHost = "localhost";
        this.myServerPort = 0;
        this.initAll(aUser);
    }

    private void initAll(String aUser) throws CommunicationFailureException {
        this.myConnectUser = aUser;
        this.myNameServerUtil = new NameServerUtil(this);
        this.init();
        this.initExtendedSyntaxChecks();
    }

    public void setLocalNameServerPath(ArrayList pathFragments) {
        this.myCIMClient.setLocalNamespacePath(pathFragments);
    }

    public boolean isBranchProtectionOpenForOwner() {
        return this.branchProtectionOpenForOwner;
    }

    public void setBranchProtectionOpenForOwner(boolean flag) {
        this.branchProtectionOpenForOwner = flag;
    }

    public static boolean pingNameServer(String aHost, int aPort) throws IOException {
        return CIMServerPing.ping((String)aHost, (int)aPort);
    }

    public static boolean pingNameServer(java.net.URL aUrl) throws IOException {
        return CIMServerPing.ping((java.net.URL)aUrl);
    }

    public static boolean pingNameServer(URL aUrl) throws IOException {
        java.net.URL javaURL = new java.net.URL(aUrl.toString());
        return CIMServerPing.ping((java.net.URL)javaURL);
    }

    public static boolean pingNameServer(URL aUrl, KeyStore scstore) throws IOException, HTTPException {
        return CIMServerPing.ping((URL)aUrl, (KeyStore)scstore);
    }

    public static boolean checkUserOnNameServer(String aHost, int aPort, String aUser, String aPwd) throws CommunicationFailureException {
        CIMClient testClient;
        try {
            testClient = new CIMClient(ClientFactory.newInstance().createClient(ClientFactory.newSAPHttpURL((String)aHost, (int)aPort), aUser, aPwd));
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        try {
            testClient.ping();
        }
        catch (UnauthorizedUserException uaue) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Unauthorized user exception in check user on name server.", (Throwable)uaue);
            }
            return false;
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        return true;
    }

    public static boolean checkUserOnNameServer(java.net.URL aUrl, String aUser, String aPwd) throws CommunicationFailureException {
        CIMClient testClient;
        try {
            testClient = new CIMClient(ClientFactory.newInstance().createClient(aUrl, aUser, aPwd));
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        try {
            testClient.ping();
        }
        catch (UnauthorizedUserException uaue) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Unauthorized user exception in check user on name server.", (Throwable)uaue);
            }
            return false;
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        return true;
    }

    public static boolean checkUserOnNameServer(java.net.URL aUrl, String aUser, String aPwd, KeyStore scstore) throws CommunicationFailureException {
        CIMClient testClient;
        try {
            testClient = new CIMClient(ClientFactory.newInstance().createClient(aUrl, scstore, aUser, aPwd));
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        try {
            testClient.ping();
        }
        catch (UnauthorizedUserException uaue) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Unauthorized user exception in check user on name server.", (Throwable)uaue);
            }
            return false;
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        return true;
    }

    public static boolean checkUserOnNameServer(URL aUrl, String aUser, String aPwd) throws CommunicationFailureException {
        CIMClient testClient;
        try {
            testClient = new CIMClient(ClientFactory.newInstance().createClient(aUrl, aUser, aPwd));
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        try {
            testClient.ping();
        }
        catch (UnauthorizedUserException uaue) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Unauthorized user exception in check user on name server.", (Throwable)uaue);
            }
            return false;
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        return true;
    }

    public static boolean checkUserOnNameServer(URL aUrl, String aUser, String aPwd, KeyStore scstore) throws CommunicationFailureException {
        CIMClient testClient;
        try {
            testClient = new CIMClient(ClientFactory.newInstance().createClient(aUrl, scstore, aUser, aPwd));
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        try {
            testClient.ping();
        }
        catch (UnauthorizedUserException uaue) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Unauthorized user exception in check user on name server.", (Throwable)uaue);
            }
            return false;
        }
        catch (CIMClientException cce) {
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        return true;
    }

    public boolean existsNamePrefix(String category, String prefix) throws NameSyntaxViolation, CommunicationFailureException {
        NameCharacteristic namcha = this.getNameCharacteristic(category);
        CompoundName prefix1 = this.myNameServerUtil.createCompoundNameFromString(prefix, namcha);
        CompoundName[] existingPrefixes = this.getCompletePrefixList(category);
        int i = 0;
        while (i < existingPrefixes.length) {
            CompoundName prefix2 = existingPrefixes[i];
            if (prefix1.equals(prefix2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CompoundName[] evaluatePrefixIntersections(String category, String prefix) throws NameSyntaxViolation, CommunicationFailureException {
        NamespacePrefix[] collisions = this.evaluatePrefixCollisions(category, prefix);
        CompoundName[] result = new CompoundName[collisions.length];
        int i = 0;
        while (i < collisions.length) {
            result[i] = collisions[i].getMyCompoundName();
            ++i;
        }
        return result;
    }

    public NamespacePrefix[] evaluatePrefixCollisions(String category, String prefix) throws NameSyntaxViolation, CommunicationFailureException {
        ArrayList overlappingPrefixes = new ArrayList();
        if (category.equals("All")) {
            NamespacePrefix[] checkPrefixes = this.myNameServerUtil.generatePrefixesByConvention(prefix);
            int i = 0;
            while (i < checkPrefixes.length) {
                CompoundName nextPrefix1 = checkPrefixes[i].getMyCompoundName();
                this.addOverlappingPrefixes(checkPrefixes[i].getMyCharacteristic(), nextPrefix1, overlappingPrefixes);
                ++i;
            }
        } else {
            NameCharacteristic namcha = this.getNameCharacteristic(category);
            CompoundName prefix1 = this.myNameServerUtil.createCompoundNameFromString(prefix, namcha);
            this.addOverlappingPrefixes(namcha, prefix1, overlappingPrefixes);
        }
        return overlappingPrefixes.toArray(new NamespacePrefix[0]);
    }

    private void addOverlappingPrefixes(NameCharacteristic namcha, CompoundName prefix1, ArrayList overlappingPrefixes) throws CommunicationFailureException {
        CompoundName[] existingPrefixes = this.getCompletePrefixList(namcha.getMyNameCategory());
        int i = 0;
        while (i < existingPrefixes.length) {
            CompoundName prefix2 = existingPrefixes[i];
            if (!this.arePrefixesDisjoint(prefix1, prefix2)) {
                NamespacePrefix collPrefix = new NamespacePrefix(namcha, prefix2);
                if (prefix1.equals(prefix2)) {
                    collPrefix.setMyCreationState(3);
                }
                overlappingPrefixes.add(collPrefix);
            }
            ++i;
        }
    }

    boolean arePrefixesDisjoint(CompoundName prefix1, CompoundName prefix2) {
        if (prefix1 == null || prefix2 == null) {
            return false;
        }
        boolean compDisFound = false;
        int k = 0;
        while (k < Math.min(prefix1.size(), prefix2.size())) {
            if (this.areComponentsDisjoint(prefix1.get(k), prefix2.get(k))) {
                compDisFound = true;
                break;
            }
            ++k;
        }
        return compDisFound;
    }

    private boolean areComponentsDisjoint(String comp1, String comp2) {
        boolean cmpExact2;
        String cmpComp2;
        boolean cmpExact1;
        String cmpComp1;
        if (comp1 == null || comp2 == null) {
            return false;
        }
        if (comp1.endsWith("*")) {
            if (comp1.equals("*")) {
                return false;
            }
            cmpComp1 = comp1.substring(0, comp1.length() - 1);
            cmpExact1 = false;
        } else {
            cmpComp1 = comp1;
            cmpExact1 = true;
        }
        if (comp2.endsWith("*")) {
            if (comp2.equals("*")) {
                return false;
            }
            cmpComp2 = comp2.substring(0, comp2.length() - 1);
            cmpExact2 = false;
        } else {
            cmpComp2 = comp2;
            cmpExact2 = true;
        }
        if (cmpExact1 ? cmpComp1.equals(cmpComp2) : cmpComp2.startsWith(cmpComp1)) {
            return false;
        }
        return !(cmpExact2 ? cmpComp2.equals(cmpComp1) : cmpComp1.startsWith(cmpComp2));
    }

    private AllocationState allocateName(String nameCategory, CompoundName name, String userId, String caption, String description, boolean protectGrowth, boolean openSubNames, String context, String contextKey) throws CommunicationFailureException, NotOwnerException, NameSyntaxViolation, ForeignContextException, ReservedBeforeException {
        AllocationState resultState;
        NameCharacteristic namcha = this.getNameCharacteristic(nameCategory);
        CIMValueNamedInstance serverNameVNI = null;
        CIMInstance serverNameInstance = null;
        AllocationState serverNameState = null;
        CIMValueObjectWithPath serverAssociatedContextOWP = null;
        CIMInstance serverAssociatedContextInstance = null;
        CIMValueNamedInstance serverContextVNI = null;
        AllocationState theNewContextState = null;
        String flatName = name.toString();
        serverNameVNI = this.myNameServerUtil.getNameValueNamedInstance(nameCategory, flatName);
        serverNameInstance = serverNameVNI.getInstance();
        if (serverNameInstance != null && (serverAssociatedContextOWP = this.myNameServerUtil.getAssociatedContextInstance(nameCategory, flatName)) != null) {
            serverAssociatedContextInstance = serverAssociatedContextOWP.getInstance();
        }
        serverNameState = this.myNameServerUtil.createAllocationState(namcha, flatName, serverNameInstance, serverAssociatedContextInstance);
        if (serverNameInstance != null) {
            String owner = serverNameState.getUserId();
            if (owner != null && owner.equalsIgnoreCase(this.getMyConnectUser())) {
                if (serverNameState.isReservedFinally()) {
                    throw new NotOwnerException("Name already reserved finally; caption: " + serverNameState.getCaption());
                }
                throw new ReservedBeforeException("Name already reserved by yourself before; caption: " + serverNameState.getCaption(), serverNameState, false);
            }
            throw new NotOwnerException("Name already reserved by somebody else; caption: " + serverNameState.getCaption());
        }
        if (userId == null || userId.length() == 0) {
            throw new NameSyntaxViolation("No owner supplied for name " + nameCategory + ":" + flatName);
        }
        if (caption == null || caption.length() == 0) {
            throw new NameSyntaxViolation("No caption supplied for name " + nameCategory + ":" + flatName);
        }
        if (context != null && ((serverContextVNI = this.myNameServerUtil.checkContextBeforeModify(context, contextKey)) == null || serverContextVNI.getInstance() == null)) {
            theNewContextState = this.createContext(context);
        }
        this.myNameServerUtil.checkForAllowedNamePrefix(nameCategory, name);
        this.myNameServerUtil.checkForTextualSyntax(name, namcha);
        if (!openSubNames) {
            this.myNameServerUtil.checkForProtectedBranch(nameCategory, name, this.branchProtectionOpenForOwner);
        }
        CIMValueNamedInstance theNewValueNamedInstance = this.myNameServerUtil.createValueNamedInstanceForName(nameCategory, name, userId, caption, description, protectGrowth, namcha, serverNameState, serverNameVNI);
        CIMInstance theContextInstance = null;
        if (context != null && serverAssociatedContextInstance == null) {
            String validContextKey;
            if (serverContextVNI.getInstance() != null) {
                validContextKey = contextKey;
                theContextInstance = serverContextVNI.getInstance();
            } else {
                validContextKey = theNewContextState.getContextKey();
                theContextInstance = this.myNameServerUtil.getContextValueNamedInstance(context).getInstance();
            }
            this.myNameServerUtil.associateNameWithContext(nameCategory, flatName, context, validContextKey);
        }
        if ((resultState = this.myNameServerUtil.createAllocationState(namcha, flatName, theNewValueNamedInstance.getInstance(), theContextInstance)).getReservationKey() == null && theNewValueNamedInstance.getInstance() != null) {
            resultState.setReservationKey(this.myNameServerUtil.getKeyFromNameInstance(theNewValueNamedInstance.getInstance()));
            if (resultState.getContextKey() == null && theNewContextState != null) {
                resultState.setContextKey(theNewContextState.getContextKey());
            }
        }
        return resultState;
    }

    public AllocationState createContext(String context) throws CommunicationFailureException, ForeignContextException {
        AllocationState result;
        CIMValueNamedInstance contextValueNamedInstance = this.myNameServerUtil.getContextValueNamedInstance(context);
        CIMInstance contextInstance = contextValueNamedInstance.getInstance();
        if (contextInstance != null) {
            CIMValueObjectWithPath[] currRefs;
            CIMInstancename contextInstanceName = contextValueNamedInstance.getInstancename();
            try {
                currRefs = this.myCIMClient.references(contextInstanceName, CIMFactory.classname((String)"SAP_DTContextMember"), null, false, false, null);
            }
            catch (CIMClientException cce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("Client exception in get references of context " + context, (Throwable)cce);
                }
                throw new CommunicationFailureException((Exception)((Object)cce));
            }
            catch (LcrException lce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("LCR exception in get references of context " + context, (Throwable)lce);
                }
                throw new CommunicationFailureException((Exception)((Object)lce));
            }
            if (currRefs.length > 0) {
                throw new ForeignContextException("Context " + context + " already exists with " + currRefs.length + " name reservations");
            }
        } else {
            try {
                contextInstance = CIMFactory.instance((String)"SAP_DesignTimeContext");
                CIMProperty pk1 = CIMFactory.property((String)"Name", (String)"string", (String)context);
                CIMProperty p1 = CIMFactory.property((String)"Key", (String)"string", (String)Integer.toString(myRandom.nextInt(100000000)));
                CIMProperty p2 = CIMFactory.property((String)"Open", (String)"boolean", (String)"true");
                CIMProperty p3 = CIMFactory.property((String)"Caption", (String)"string", (String)("DT Context " + context));
                contextInstance.addProperty(pk1);
                contextInstance.addProperty(p1);
                contextInstance.addProperty(p2);
                contextInstance.addProperty(p3);
                this.myCIMClient.createInstance(contextInstance);
            }
            catch (CIMClientException cce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("Client exception in create context " + context, (Throwable)cce);
                }
                throw new CommunicationFailureException((Exception)((Object)cce));
            }
            catch (LcrException lce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("LCR exception in create context " + context, (Throwable)lce);
                }
                throw new CommunicationFailureException((Exception)((Object)lce));
            }
            catch (ItemConstructionExcp ice) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("Item construction exception in create context " + context, (Throwable)ice);
                }
                throw new CommunicationFailureException((Exception)((Object)ice));
            }
        }
        try {
            result = this.myNameServerUtil.createAllocationState(null, null, null, contextInstance);
        }
        catch (NameSyntaxViolation nsve) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Unexpected name syntax violation in create context.", (Throwable)((Object)nsve));
            }
            result = new AllocationState();
        }
        result.setContextKey(this.myNameServerUtil.getKeyFromContextInstance(contextInstance));
        return result;
    }

    public CompoundName[] listAllowedPrefixes(String nameCategory, boolean refresh) throws CommunicationFailureException {
        CIMNamespacepath nameServerHandle;
        String objServerName = this.getMyObjectServerName(refresh);
        try {
            nameServerHandle = CIMFactory.namespacepath((String)objServerName, (CIMLocalnamespacepath)this.myCIMClient.getLocalnamespacepath());
            if (refresh || this.allAllowedPrefixes == null) {
                this.allAllowedPrefixes = this.myCIMClient.enumerateInstances("SAP_AllowedNamespacePrefix", false, true, false, false, null);
            }
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in enumerate allowed prefixes", (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in enumerate allowed prefixes", (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
        catch (NullPointerException npe) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Invalid name server handle in enumerate allowed prefixes", (Throwable)npe);
            }
            throw new CommunicationFailureException(npe);
        }
        return this.extractLocalPrefixes(nameCategory, nameServerHandle);
    }

    public void checkName(String nameCategory, CompoundName name) throws CommunicationFailureException, NameSyntaxViolation {
        NameCharacteristic namcha = this.getNameCharacteristic(nameCategory);
        this.myNameServerUtil.checkForAllowedNamePrefix(nameCategory, name);
        this.myNameServerUtil.checkForTextualSyntax(name, namcha);
    }

    public void checkName(String nameCategory, String name) throws CommunicationFailureException, NameSyntaxViolation {
        NameCharacteristic namcha = this.getNameCharacteristic(nameCategory);
        CompoundName compoundName = this.myNameServerUtil.createCompoundNameFromString(name, namcha);
        this.myNameServerUtil.checkForAllowedNamePrefix(nameCategory, compoundName);
        this.myNameServerUtil.checkForTextualSyntax(compoundName, namcha);
    }

    public AllocationState reservePreliminary(String nameCategory, CompoundName name, String userId, String caption, String description, boolean protectGrowth, String context, String contextKey) throws CommunicationFailureException, NotOwnerException, NameSyntaxViolation, ForeignContextException, ReservedBeforeException {
        return this.allocateName(nameCategory, name, userId, caption, description, protectGrowth, false, context, contextKey);
    }

    public AllocationState reservePreliminary(String nameCategory, String name, String userId, String caption, String description, String context, String contextKey) throws CommunicationFailureException, NotOwnerException, NameSyntaxViolation, ForeignContextException, ReservedBeforeException {
        NameCharacteristic namcha = this.getNameCharacteristic(nameCategory);
        CompoundName compoundName = this.myNameServerUtil.createCompoundNameFromString(name, namcha);
        return this.allocateName(nameCategory, compoundName, userId, caption, description, false, false, context, contextKey);
    }

    public AllocationState reserveSubNamePreliminary(String nameCategory, CompoundName name, String userId, String caption, String description, boolean protectGrowth, String context, String contextKey) throws CommunicationFailureException, NotOwnerException, NameSyntaxViolation, ForeignContextException, ReservedBeforeException {
        return this.allocateName(nameCategory, name, userId, caption, description, protectGrowth, true, context, contextKey);
    }

    public AllocationState getAllocationState(String nameCategory, CompoundName name) throws CommunicationFailureException, NameNotFoundException {
        return this.getAllocationState(nameCategory, name.toString());
    }

    public AllocationState getAllocationState(String nameCategory, String name) throws CommunicationFailureException, NameNotFoundException {
        AllocationState resultState;
        CIMInstance nameInstance = this.myNameServerUtil.getNameValueNamedInstance(nameCategory, name).getInstance();
        if (nameInstance == null) {
            throw new NameNotFoundException("Name not found: " + nameCategory + ":" + name);
        }
        CIMInstance contextInstance = null;
        CIMValueObjectWithPath contextInstanceOwP = this.myNameServerUtil.getAssociatedContextInstance(nameCategory, name);
        if (contextInstanceOwP != null) {
            contextInstance = contextInstanceOwP.getInstance();
        }
        NameCharacteristic namcha = this.getNameCharacteristic(nameCategory);
        try {
            resultState = this.myNameServerUtil.createAllocationState(namcha, name, nameInstance, contextInstance);
        }
        catch (NameSyntaxViolation nsve) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Name syntax violation in get allocation state.", (Throwable)((Object)nsve));
            }
            throw new NameNotFoundException((Exception)((Object)nsve));
        }
        return resultState;
    }

    public void changeUserId(String nameCategory, CompoundName name, String reservationKey, String userId) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        this.changeUserId(nameCategory, name.toString(), reservationKey, userId);
    }

    public void changeUserId(String nameCategory, String name, String reservationKey, String userId) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        CIMValueNamedInstance currValueNamedInstance = this.myNameServerUtil.checkNameBeforeModify(nameCategory, name, reservationKey);
        this.myNameServerUtil.modifyNameInstanceProperty(currValueNamedInstance.getInstance(), currValueNamedInstance.getInstancename(), nameCategory, name, "UserId", "string", userId);
    }

    public void changeCaption(String nameCategory, CompoundName name, String reservationKey, String caption) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        this.changeCaption(nameCategory, name.toString(), reservationKey, caption);
    }

    public void changeCaption(String nameCategory, String name, String reservationKey, String caption) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        CIMValueNamedInstance currValueNamedInstance = this.myNameServerUtil.checkNameBeforeModify(nameCategory, name, reservationKey);
        this.myNameServerUtil.modifyNameInstanceProperty(currValueNamedInstance.getInstance(), currValueNamedInstance.getInstancename(), nameCategory, name, "Caption", "string", caption);
    }

    public void changeDescription(String nameCategory, CompoundName name, String reservationKey, String description) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        this.changeDescription(nameCategory, name.toString(), reservationKey, description);
    }

    public void changeDescription(String nameCategory, String name, String reservationKey, String description) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        CIMValueNamedInstance currValueNamedInstance = this.myNameServerUtil.checkNameBeforeModify(nameCategory, name, reservationKey);
        this.myNameServerUtil.modifyNameInstanceProperty(currValueNamedInstance.getInstance(), currValueNamedInstance.getInstancename(), nameCategory, name, "Description", "string", description);
    }

    public void changeContext(String nameCategory, CompoundName name, String reservationKey, String oldContext, String oldContextKey, String newContext, String newContextKey) throws CommunicationFailureException, NameNotFoundException, NotOwnerException, ForeignContextException {
        this.changeContext(nameCategory, name.toString(), reservationKey, oldContext, oldContextKey, newContext, newContextKey);
    }

    public void changeContext(String nameCategory, String name, String reservationKey, String oldContext, String oldContextKey, String newContext, String newContextKey) throws CommunicationFailureException, NameNotFoundException, NotOwnerException, ForeignContextException {
        boolean currentlyAssociated;
        CIMValueNamedInstance currValueNamedInstance = this.myNameServerUtil.checkNameBeforeModify(nameCategory, name, reservationKey);
        CIMValueObjectWithPath currAssocContextOwP = this.myNameServerUtil.getAssociatedContextInstance(nameCategory, name);
        if (currAssocContextOwP != null) {
            String currAssocContextKey = this.myNameServerUtil.getKeyFromContextInstance(currAssocContextOwP.getInstance());
            if (currAssocContextKey == null || !currAssocContextKey.equals(oldContextKey)) {
                throw new ForeignContextException("Wrong key submitted for currently associated context");
            }
            currentlyAssociated = true;
        } else {
            currentlyAssociated = false;
        }
        if (currentlyAssociated) {
            try {
                CIMValueReference memberValueReference = CIMFactory.valueReference((CIMInstancename)currValueNamedInstance.getInstancename());
                CIMKeybinding memberKeyBinding = CIMFactory.keybinding((String)"Member", (CIMValueReference)memberValueReference);
                CIMInstancename oldContextInstanceName = currAssocContextOwP.getInstancename();
                CIMKeybinding oldCollectionKeyBinding = CIMFactory.keybinding((String)"Collection", (CIMValueReference)CIMFactory.valueReference((CIMInstancename)oldContextInstanceName));
                CIMKeybindingList oldKeyBindingList = CIMFactory.keybindingList();
                oldKeyBindingList.addKeybinding(memberKeyBinding);
                oldKeyBindingList.addKeybinding(oldCollectionKeyBinding);
                this.myCIMClient.deleteInstance(CIMFactory.instancename((String)"SAP_DTContextMember", (CIMKeybindingList)oldKeyBindingList));
            }
            catch (CIMClientException cce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("Client exception in change context of name " + nameCategory + ":" + name, (Throwable)cce);
                }
                throw new CommunicationFailureException((Exception)((Object)cce));
            }
            catch (LcrException lce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("LCR exception in change context of name " + nameCategory + ":" + name, (Throwable)lce);
                }
                throw new CommunicationFailureException((Exception)((Object)lce));
            }
        }
        this.myNameServerUtil.associateNameWithContext(nameCategory, name, newContext, newContextKey);
    }

    public AllocationState revert(String nameCategory, CompoundName name, String reservationKey) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        String flatName = name.toString();
        NameCharacteristic namcha = this.getNameCharacteristic(nameCategory);
        CIMValueNamedInstance currValueNamedInstance = this.myNameServerUtil.checkNameBeforeStateTransition(nameCategory, name, reservationKey);
        CIMInstancename delInstanceName = currValueNamedInstance.getInstancename();
        this.myNameServerUtil.removeNameInstance(delInstanceName, nameCategory, flatName);
        AllocationState resultState = new AllocationState();
        try {
            resultState = this.myNameServerUtil.createAllocationState(namcha, flatName, currValueNamedInstance.getInstance(), null);
        }
        catch (NameSyntaxViolation nsve) {
            if (CIMTraceUtil.traceLevel >= 3) {
                myLogger.debug("Name syntax violation in revert.", (Throwable)((Object)nsve));
            }
            resultState.setNameCategory(nameCategory);
            resultState.setCompoundName(name);
            resultState.setFlatName(flatName);
            resultState.setCimName(this.myNameServerUtil.createNameInCIMKey(flatName, namcha));
        }
        resultState.setUnreserved();
        return resultState;
    }

    public AllocationState revert(String nameCategory, String name, String reservationKey) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        CompoundName compoundName;
        NameCharacteristic namcha = this.getNameCharacteristic(nameCategory);
        try {
            compoundName = this.myNameServerUtil.createCompoundNameFromString(name, namcha);
        }
        catch (NameSyntaxViolation nsve) {
            throw new NameNotFoundException((Exception)((Object)nsve));
        }
        return this.revert(nameCategory, compoundName, reservationKey);
    }

    public AllocationState reserveFinally(String nameCategory, CompoundName name, String reservationKey, String comment) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        String flatName = name.toString();
        NameCharacteristic namcha = this.getNameCharacteristic(nameCategory);
        CIMValueNamedInstance currValueNamedInstance = this.myNameServerUtil.checkNameBeforeStateTransition(nameCategory, name, reservationKey);
        CIMInstance modInstance = this.myNameServerUtil.modifyNameInstanceProperty(currValueNamedInstance.getInstance(), currValueNamedInstance.getInstancename(), nameCategory, flatName, "AllocationState", "string", "FINRES");
        if (comment != null) {
            modInstance = this.myNameServerUtil.modifyNameInstanceProperty(modInstance, currValueNamedInstance.getInstancename(), nameCategory, flatName, "UsageComment", "string", comment);
        }
        AllocationState resultState = null;
        try {
            resultState = this.myNameServerUtil.createAllocationState(namcha, flatName, modInstance, null);
        }
        catch (NameSyntaxViolation nsve) {
            throw new NameNotFoundException((Exception)((Object)nsve));
        }
        return resultState;
    }

    public AllocationState reserveFinally(String nameCategory, String name, String reservationKey, String comment) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        CompoundName compoundName;
        NameCharacteristic namcha = this.getNameCharacteristic(nameCategory);
        try {
            compoundName = this.myNameServerUtil.createCompoundNameFromString(name, namcha);
        }
        catch (NameSyntaxViolation nsve) {
            throw new NameNotFoundException((Exception)((Object)nsve));
        }
        return this.reserveFinally(nameCategory, compoundName, reservationKey, comment);
    }

    public AllocationState[] revertContext(String context, String contextKey) throws CommunicationFailureException, ForeignContextException {
        AllocationState[] resultStates = new AllocationState[]{};
        ArrayList<AllocationState> resultList = new ArrayList<AllocationState>();
        CIMValueNamedInstance delContextVNI = this.myNameServerUtil.checkContextBeforeModify(context, contextKey);
        if (delContextVNI == null || delContextVNI.getInstance() == null) {
            throw new ForeignContextException("Failed to revert the non existing context " + context);
        }
        CIMInstance delContextInstance = delContextVNI.getInstance();
        CIMValueObjectWithPath[] delNameOWP = this.myNameServerUtil.getAssociatedNameInstances(context);
        boolean allRemoved = true;
        int i = 0;
        while (i < delNameOWP.length) {
            CIMInstancename nextInstanceName = delNameOWP[i].getInstancename();
            String nextCreationClassName = this.myNameServerUtil.getCreationClassNameFromInstanceName(nextInstanceName);
            CIMInstance nextInstance = delNameOWP[i].getInstance();
            String nextName = null;
            try {
                nextName = this.myNameServerUtil.getNameFromNameInstance(nextInstance);
            }
            catch (NameSyntaxViolation nsve) {
                if (CIMTraceUtil.traceLevel >= 3) {
                    myLogger.debug("Name syntax violation in revert context.", (Throwable)((Object)nsve));
                }
                nextName = this.myNameServerUtil.getCimNameFromInstanceName(nextInstanceName);
            }
            NameCharacteristic namcha = this.getNameCharacteristic(nextCreationClassName);
            String currReservationState = this.myNameServerUtil.getStateFromNameInstance(nextInstance);
            boolean toBeRemoved = true;
            if (!currReservationState.equals("PRERES")) {
                toBeRemoved = false;
                allRemoved = false;
            } else {
                this.myNameServerUtil.removeNameInstance(nextInstanceName, nextCreationClassName, nextName);
            }
            AllocationState nextResultState = new AllocationState();
            try {
                nextResultState = this.myNameServerUtil.createAllocationState(namcha, nextName, nextInstance, delContextInstance);
            }
            catch (NameSyntaxViolation nsve) {
                if (CIMTraceUtil.traceLevel >= 3) {
                    myLogger.debug("Name syntax violation(2) in revert context.", (Throwable)((Object)nsve));
                }
                nextResultState.setNameCategory(nextCreationClassName);
                nextResultState.setFlatName(nextName);
                nextResultState.setCimName(this.myNameServerUtil.createNameInCIMKey(nextName, namcha));
            }
            if (toBeRemoved) {
                nextResultState.setUnreserved();
            }
            resultList.add(nextResultState);
            ++i;
        }
        if (allRemoved) {
            this.myNameServerUtil.removeContextInstance(delContextVNI.getInstancename(), context);
        }
        return resultList.toArray(resultStates);
    }

    public AllocationState[] reserveContextFinally(String context, String contextKey, String comment) throws CommunicationFailureException, ForeignContextException {
        AllocationState[] resultStates = new AllocationState[]{};
        ArrayList<AllocationState> resultList = new ArrayList<AllocationState>();
        CIMValueNamedInstance updContextVNI = this.myNameServerUtil.checkContextBeforeModify(context, contextKey);
        if (updContextVNI == null || updContextVNI.getInstance() == null) {
            throw new ForeignContextException("Failed to reserve finally the non existing context " + context);
        }
        CIMInstance updContextInstance = updContextVNI.getInstance();
        CIMValueObjectWithPath[] updNameOWP = this.myNameServerUtil.getAssociatedNameInstances(context);
        boolean allUpdated = true;
        int i = 0;
        while (i < updNameOWP.length) {
            CIMInstancename nextInstanceName = updNameOWP[i].getInstancename();
            String nextCreationClassName = this.myNameServerUtil.getCreationClassNameFromInstanceName(nextInstanceName);
            CIMInstance nextInstance = updNameOWP[i].getInstance();
            String nextName = null;
            boolean toBeUpdated = true;
            CIMInstance modInstance = null;
            try {
                nextName = this.myNameServerUtil.getNameFromNameInstance(nextInstance);
            }
            catch (NameSyntaxViolation nsve) {
                if (CIMTraceUtil.traceLevel >= 3) {
                    myLogger.debug("Name syntax violation in reserve context finally.", (Throwable)((Object)nsve));
                }
                toBeUpdated = false;
                allUpdated = false;
            }
            NameCharacteristic namcha = this.getNameCharacteristic(nextCreationClassName);
            String currReservationState = this.myNameServerUtil.getStateFromNameInstance(nextInstance);
            if (!currReservationState.equals("PRERES")) {
                toBeUpdated = false;
                allUpdated = false;
            } else if (toBeUpdated) {
                modInstance = this.myNameServerUtil.modifyNameInstanceProperty(nextInstance, nextInstanceName, nextCreationClassName, nextName, "AllocationState", "string", "FINRES");
                if (comment != null) {
                    modInstance = this.myNameServerUtil.modifyNameInstanceProperty(modInstance, nextInstanceName, nextCreationClassName, nextName, "UsageComment", "string", comment);
                }
            }
            AllocationState nextResultState = new AllocationState();
            try {
                nextResultState = toBeUpdated ? this.myNameServerUtil.createAllocationState(namcha, nextName, modInstance, updContextInstance) : this.myNameServerUtil.createAllocationState(namcha, nextName, nextInstance, updContextInstance);
            }
            catch (NameSyntaxViolation nsve) {
                if (CIMTraceUtil.traceLevel >= 3) {
                    myLogger.debug("Name syntax violation(2) in reserve context finally.", (Throwable)((Object)nsve));
                }
                nextResultState.setNameCategory(nextCreationClassName);
                nextResultState.setFlatName(nextName);
                nextResultState.setCimName(this.myNameServerUtil.createNameInCIMKey(nextName, namcha));
            }
            resultList.add(nextResultState);
            ++i;
        }
        if (allUpdated) {
            this.myNameServerUtil.modifyContextInstanceProperty(updContextInstance, updContextVNI.getInstancename(), context, "Open", "boolean", "false");
        }
        return resultList.toArray(resultStates);
    }

    public AllocationState[] listReservations(String context) throws CommunicationFailureException {
        return this.listReservations(context, null, (String)null, false, false);
    }

    public AllocationState[] listReservations(String context, String nameCategory) throws CommunicationFailureException {
        return this.listReservations(context, nameCategory, (String)null, false, false);
    }

    public AllocationState[] listReservations(String context, String nameCategory, CompoundName name, boolean suppressPrelim, boolean suppressFinal) throws CommunicationFailureException {
        return this.listReservations(context, nameCategory, name.toString(), suppressPrelim, suppressFinal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AllocationState[] listReservations(String context, String nameCategory, String name, boolean suppressPrelim, boolean suppressFinal) throws CommunicationFailureException {
        AllocationState[] resultStates = new AllocationState[]{};
        ArrayList<AllocationState> selectionList = new ArrayList<AllocationState>();
        if (context != null) {
            CIMValueNamedInstance contextValueNamedInstance = this.myNameServerUtil.getContextValueNamedInstance(context);
            CIMInstance contextInstance = contextValueNamedInstance.getInstance();
            if (contextInstance == null) return resultStates;
            CIMValueObjectWithPath[] associatedNameObjects = this.myNameServerUtil.getAssociatedNameInstances(context);
            int i = 0;
            while (i < associatedNameObjects.length) {
                block9: {
                    if (this.myNameServerUtil.isNameToBeSelected((ICIMObjectContainer)associatedNameObjects[i], nameCategory, name, suppressPrelim, suppressFinal)) {
                        CIMInstancename nextInstanceName = associatedNameObjects[i].getInstancename();
                        CIMInstance nextInstance = associatedNameObjects[i].getInstance();
                        String nextCreationClassName = this.myNameServerUtil.getCreationClassNameFromInstanceName(nextInstanceName);
                        String nextName = null;
                        try {
                            nextName = this.myNameServerUtil.getNameFromNameInstance(nextInstance);
                            AllocationState nextAllocationState = this.myNameServerUtil.createAllocationState(this.getNameCharacteristic(nextCreationClassName), nextName, nextInstance, contextInstance);
                            selectionList.add(nextAllocationState);
                        }
                        catch (NameSyntaxViolation nsve) {
                            if (CIMTraceUtil.traceLevel < 3) break block9;
                            myLogger.debug("Syntax violation found for name " + nextCreationClassName + ":" + nextName + " (" + this.myNameServerUtil.getCimNameFromInstanceName(nextInstanceName) + ") during list reservations (name ignored)", (Throwable)((Object)nsve));
                        }
                    }
                }
                ++i;
            }
            return selectionList.toArray(resultStates);
        }
        CIMValueNamedInstance[] categoryNameInstances = this.myNameServerUtil.getNamesOfCategory(nameCategory);
        int i = 0;
        while (i < categoryNameInstances.length) {
            block10: {
                if (this.myNameServerUtil.isNameToBeSelected((ICIMObjectContainer)categoryNameInstances[i], nameCategory, name, suppressPrelim, suppressFinal)) {
                    CIMInstancename nextInstanceName = categoryNameInstances[i].getInstancename();
                    CIMInstance nextInstance = categoryNameInstances[i].getInstance();
                    String nextCreationClassName = this.myNameServerUtil.getCreationClassNameFromInstanceName(nextInstanceName);
                    String nextName = null;
                    try {
                        nextName = this.myNameServerUtil.getNameFromNameInstance(nextInstance);
                        AllocationState nextAllocationState = this.myNameServerUtil.createAllocationState(this.getNameCharacteristic(nextCreationClassName), nextName, nextInstance, null);
                        selectionList.add(nextAllocationState);
                    }
                    catch (NameSyntaxViolation nsve) {
                        if (CIMTraceUtil.traceLevel < 3) break block10;
                        myLogger.debug("Syntax violation found for name " + nextCreationClassName + ":" + nextName + " (" + this.myNameServerUtil.getCimNameFromInstanceName(nextInstanceName) + ") during list reservations (name ignored)", (Throwable)((Object)nsve));
                    }
                }
            }
            ++i;
        }
        return selectionList.toArray(resultStates);
    }

    public void setWorkspace(String nameCategory, CompoundName name, String reservationKey, String workspaceURL, String workspaceID) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        this.setWorkspace(nameCategory, name.toString(), reservationKey, workspaceURL, workspaceID);
    }

    public void setWorkspace(String nameCategory, String name, String reservationKey, String workspaceURL, String workspaceID) throws CommunicationFailureException, NameNotFoundException, NotOwnerException {
        CIMValueNamedInstance currValueNamedInstance = this.myNameServerUtil.checkNameBeforeModify(nameCategory, name, reservationKey);
        String[] propNames = new String[]{"WorkspaceLocation", "WorkspaceID"};
        String[] propTypes = new String[]{"string", "string"};
        String[] propValues = new String[]{workspaceURL, workspaceID};
        this.myNameServerUtil.modifyNameInstanceProperties(currValueNamedInstance.getInstance(), currValueNamedInstance.getInstancename(), nameCategory, name, propNames, propTypes, propValues);
    }

    public AllocationState moveName(String sourceNameCategory, CompoundName sourceName, String reservationKey, String targetNameCategory, CompoundName targetName) throws CommunicationFailureException, NameNotFoundException, NotOwnerException, NameSyntaxViolation, ReservedBeforeException {
        AllocationState targetAllocationState;
        String flatSourceName = sourceName.toString();
        CIMValueNamedInstance currValueNamedInstance = this.myNameServerUtil.checkNameBeforeModify(sourceNameCategory, flatSourceName, reservationKey);
        CIMInstance sourceInstance = currValueNamedInstance.getInstance();
        String sourceState = this.myNameServerUtil.getStateFromNameInstance(sourceInstance);
        if (sourceState == null) {
            throw new NameNotFoundException("Undefined reservation state for name " + sourceNameCategory + ":" + flatSourceName);
        }
        if (sourceState.equals("FINRES")) {
            String sourceUserId = this.myNameServerUtil.getUserIdFromNameInstance(sourceInstance);
            String sourceCaption = this.myNameServerUtil.getCaptionFromNameInstance(sourceInstance);
            String sourceDescription = this.myNameServerUtil.getDescriptionFromNameInstance(sourceInstance);
            boolean sourceGrowthFlag = this.myNameServerUtil.getProtectedGrowthFlagFromNameInstance(sourceInstance);
            try {
                targetAllocationState = this.reservePreliminary(targetNameCategory, targetName, sourceUserId, sourceCaption, sourceDescription, sourceGrowthFlag, null, null);
            }
            catch (ForeignContextException fce) {
                throw new NotOwnerException((Exception)((Object)fce));
            }
        }
        try {
            targetAllocationState = this.getAllocationState(targetNameCategory, targetName);
            String targetResKey = targetAllocationState.getReservationKey();
            if (targetResKey == null || targetResKey.length() == 0) {
                throw new NotOwnerException("Target name reserved by somebody else");
            }
            if (targetAllocationState.isReservedFinally()) {
                throw new NotOwnerException("Target name is already reserved finally");
            }
        }
        catch (NameNotFoundException nnfe) {
            if (CIMTraceUtil.traceLevel >= 6) {
                myLogger.finest("Name not found in move name (= expected behaviour).", (Throwable)((Object)nnfe));
            }
            targetAllocationState = null;
        }
        String flatTargetName = targetName.toString();
        NameCharacteristic trgnamcha = this.getNameCharacteristic(targetNameCategory);
        CIMInstancename targetInstanceName = this.myNameServerUtil.createNameInstanceName(trgnamcha, targetNameCategory, flatTargetName);
        try {
            this.myCIMClient.renameInstance(currValueNamedInstance.getInstancename(), targetInstanceName, true, true, false, false);
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in rename instance from " + currValueNamedInstance.getInstancename().toDisplayString() + " to " + targetInstanceName.toDisplayString(), (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in rename instance from " + currValueNamedInstance.getInstancename().toDisplayString() + " to " + targetInstanceName.toDisplayString(), (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
        try {
            targetAllocationState = this.getAllocationState(targetNameCategory, targetName);
        }
        catch (NameNotFoundException nnfe) {
            throw new NameNotFoundException("No reservation state found for rename target " + targetNameCategory + ":" + flatTargetName);
        }
        return targetAllocationState;
    }

    public AllocationState moveName(String sourceNameCategory, String sourceName, String reservationKey, String targetNameCategory, String targetName) throws CommunicationFailureException, NameNotFoundException, NotOwnerException, NameSyntaxViolation, ReservedBeforeException {
        NameCharacteristic srcnamcha = this.getNameCharacteristic(sourceNameCategory);
        CompoundName sourceCompoundName = this.myNameServerUtil.createCompoundNameFromString(sourceName, srcnamcha);
        NameCharacteristic trgnamcha = this.getNameCharacteristic(targetNameCategory);
        CompoundName targetCompoundName = this.myNameServerUtil.createCompoundNameFromString(targetName, trgnamcha);
        return this.moveName(sourceNameCategory, sourceCompoundName, reservationKey, targetNameCategory, targetCompoundName);
    }

    private void init() throws CommunicationFailureException {
        this.getNameCategoryClasses();
    }

    private void initExtendedSyntaxChecks() {
        NameCharacteristic characteristicForSoftComps;
        NameCharacteristic characteristicForDevComps;
        NameCharacteristic characteristicForDBObjects;
        NameCharacteristic characteristicForDesignTimePackage = this.getNameCharacteristic("SAP_DesignTimePackage");
        if (characteristicForDesignTimePackage != null) {
            characteristicForDesignTimePackage.setMyExtendedSyntaxCheck(new DesignTimePackageSyntaxChecker());
        }
        if ((characteristicForDBObjects = this.getNameCharacteristic("SAP_DBObjectName")) != null) {
            characteristicForDBObjects.setMyExtendedSyntaxCheck(new DBTableSyntaxChecker());
        }
        if ((characteristicForDevComps = this.getNameCharacteristic("SAP_DevelopmentComponentName")) != null) {
            characteristicForDevComps.setMyExtendedSyntaxCheck(new DevelopmentComponentSyntaxChecker());
        }
        if ((characteristicForSoftComps = this.getNameCharacteristic("SAP_SoftwareComponentName")) != null) {
            characteristicForSoftComps.setMyExtendedSyntaxCheck(new SoftwareComponentSyntaxChecker());
        }
    }

    public String getMyServerHost() {
        return this.myServerHost;
    }

    public int getMyServerPort() {
        return this.myServerPort;
    }

    public String getMyConnectUser() {
        return this.myConnectUser;
    }

    CIMClient getMyCIMClient() {
        return this.myCIMClient;
    }

    public NameServerUtil getMyNameServerUtil() {
        return this.myNameServerUtil;
    }

    public String getMyObjectServerName(boolean refresh) throws CommunicationFailureException {
        if (refresh || this.myObjectServerName == null) {
            try {
                this.myObjectServerName = this.myCIMClient.getObjectServer();
            }
            catch (CIMClientException cce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("Client exception in get object server", (Throwable)cce);
                }
                throw new CommunicationFailureException((Exception)((Object)cce));
            }
            catch (LcrException lce) {
                if (CIMTraceUtil.traceLevel >= 4) {
                    myLogger.fine("LCR exception in get object server", (Throwable)lce);
                }
                throw new CommunicationFailureException((Exception)((Object)lce));
            }
        }
        return this.myObjectServerName;
    }

    private void getNameCategoryClasses() throws CommunicationFailureException {
        CIMClass[] nameClasses = null;
        try {
            nameClasses = this.myCIMClient.enumerateClasses("SAP_DesignTimeName", true, false, true, true);
            int i = 0;
            while (i < nameClasses.length) {
                CIMClass nextClass = nameClasses[i];
                String nextClassName = nextClass.getClassname();
                if (!nextClassName.equalsIgnoreCase("SAP_DesignTimeName")) {
                    NameCharacteristic characteristic = NameCharacteristic.createCharacteristicFromCIMClass(nextClass);
                    this.myCategoryMap.put(nextClassName, characteristic);
                }
                ++i;
            }
        }
        catch (CIMClientException cce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Client exception in enumerate category classes", (Throwable)cce);
            }
            throw new CommunicationFailureException((Exception)((Object)cce));
        }
        catch (LcrException lce) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("LCR exception in enumerate category classes", (Throwable)lce);
            }
            throw new CommunicationFailureException((Exception)((Object)lce));
        }
        catch (NameSyntaxViolation ine) {
            if (CIMTraceUtil.traceLevel >= 4) {
                myLogger.fine("Illegal name exception in enumerate category classes", (Throwable)((Object)ine));
            }
            throw new CommunicationFailureException((Exception)((Object)ine));
        }
    }

    private void getNameCategoryPrefixes() throws CommunicationFailureException {
        Set categorySet = this.myCategoryMap.entrySet();
        Iterator catIter = categorySet.iterator();
        while (catIter.hasNext()) {
            Map.Entry nextEntry = catIter.next();
            String nextCategory = (String)nextEntry.getKey();
            this.listAllowedPrefixes(nextCategory, false);
        }
    }

    public NameCharacteristic getNameCharacteristic(String nameCategory) {
        NameCharacteristic namcha = nameCategory == null ? new NameCharacteristic("") : (this.myCategoryMap.containsKey(nameCategory) ? (NameCharacteristic)this.myCategoryMap.get(nameCategory) : new NameCharacteristic(nameCategory));
        return namcha;
    }

    public CompoundName[] getAllowedPrefixList(String nameCategory) throws CommunicationFailureException {
        if (this.allAllowedPrefixes == null) {
            this.getNameCategoryPrefixes();
        }
        return (CompoundName[])this.myPrefixMap.get(nameCategory);
    }

    public CompoundName[] getCompletePrefixList(String nameCategory) throws CommunicationFailureException {
        if (this.allAllowedPrefixes == null) {
            this.getNameCategoryPrefixes();
        }
        ArrayList matchingPrefixes = this.selectPrefixes(nameCategory, null);
        return this.getSyntacticallyValidPrefixes(nameCategory, matchingPrefixes);
    }

    CIMValueNamedInstance getExistingNamePrefix(String category, String prefix) throws NameSyntaxViolation, CommunicationFailureException {
        if (this.allAllowedPrefixes == null) {
            this.getNameCategoryPrefixes();
        }
        ArrayList matchingPrefixObjects = this.selectNamespacePrefixes(category, null, false);
        int i = 0;
        while (i < matchingPrefixObjects.size()) {
            CIMValueNamedInstance nextVNI = (CIMValueNamedInstance)matchingPrefixObjects.get(i);
            CIMInstance nextPrefixInstance = nextVNI.getInstance();
            String prefixValue = nextPrefixInstance.getPropertyValue("Name");
            if (prefixValue != null && prefixValue.equals(prefix)) {
                return nextVNI;
            }
            ++i;
        }
        return null;
    }

    private CompoundName[] extractLocalPrefixes(String nameCategory, CIMNamespacepath nameServerHandle) {
        ArrayList matchingPrefixes = this.selectPrefixes(nameCategory, nameServerHandle);
        CompoundName[] allowedPrefixes = this.getSyntacticallyValidPrefixes(nameCategory, matchingPrefixes);
        CompoundName[] myAllowedPrefixes = new CompoundName[allowedPrefixes.length];
        int i = 0;
        while (i < allowedPrefixes.length) {
            myAllowedPrefixes[i] = (CompoundName)allowedPrefixes[i].clone();
            ++i;
        }
        this.myPrefixMap.put(nameCategory, myAllowedPrefixes);
        return allowedPrefixes;
    }

    private ArrayList selectPrefixes(String nameCategory, CIMNamespacepath nameServerHandle) {
        return this.selectNamespacePrefixes(nameCategory, nameServerHandle, true);
    }

    private ArrayList selectNamespacePrefixes(String nameCategory, CIMNamespacepath nameServerHandle, boolean onlyNames) {
        ArrayList<String> matchingPrefixes = new ArrayList<String>();
        int i = 0;
        while (i < this.allAllowedPrefixes.length) {
            CIMInstance nextPrefixInstance = this.allAllowedPrefixes[i].getInstance();
            String prefixValue = null;
            String prefixHandleString = null;
            String prefixClassName = null;
            CIMNamespacepath prefixHandle = null;
            boolean arbitraryPrefixHandle = false;
            Iterator propIter = nextPrefixInstance.getPropertyIterator();
            while (propIter.hasNext()) {
                CIMProperty nextProperty = (CIMProperty)propIter.next();
                String propName = nextProperty.getName();
                if (propName.equalsIgnoreCase("NamespaceHandle")) {
                    prefixHandleString = nextProperty.getValue();
                    if (prefixHandleString == null) continue;
                    try {
                        prefixHandle = CIMFactory.createNamespacepathFromString((String)prefixHandleString);
                    }
                    catch (LcrException lcenam) {
                        if (CIMTraceUtil.traceLevel >= 3) {
                            myLogger.debug("Invalid namespace handle in prefix found: " + prefixHandleString, (Throwable)lcenam);
                        }
                        prefixHandle = null;
                    }
                    if (!prefixHandleString.equals("//any/any")) continue;
                    arbitraryPrefixHandle = true;
                    continue;
                }
                if (propName.equalsIgnoreCase("NamespaceClassName")) {
                    prefixClassName = nextProperty.getValue();
                    continue;
                }
                if (!propName.equalsIgnoreCase("Name")) continue;
                prefixValue = nextProperty.getValue();
            }
            if (prefixHandle != null && (nameServerHandle == null || arbitraryPrefixHandle || prefixHandle.equals((Object)nameServerHandle)) && (nameCategory == null || prefixClassName != null && prefixClassName.equalsIgnoreCase(nameCategory)) && prefixValue != null) {
                if (onlyNames) {
                    matchingPrefixes.add(prefixValue);
                } else {
                    matchingPrefixes.add((String)this.allAllowedPrefixes[i]);
                }
            }
            ++i;
        }
        return matchingPrefixes;
    }

    private CompoundName[] getSyntacticallyValidPrefixes(String nameCategory, ArrayList inputPrefixes) {
        CompoundName[] allowedPrefixes;
        NameCharacteristic namcha = this.getNameCharacteristic(nameCategory);
        CompoundName[] selectedPrefixes = new CompoundName[inputPrefixes.size()];
        int numOk = 0;
        int i = 0;
        while (i < inputPrefixes.size()) {
            block9: {
                try {
                    selectedPrefixes[i] = this.myNameServerUtil.createCompoundNameFromString((String)inputPrefixes.get(i), namcha);
                    ++numOk;
                }
                catch (NameSyntaxViolation nsve) {
                    if (CIMTraceUtil.traceLevel < 3) break block9;
                    myLogger.debug("Name syntax violated in allowed prefix " + inputPrefixes.get(i) + ": prefix will be ignored.", (Throwable)((Object)nsve));
                }
            }
            ++i;
        }
        if (numOk == inputPrefixes.size()) {
            allowedPrefixes = selectedPrefixes;
        } else {
            CompoundName[] strippedPrefixes = new CompoundName[numOk];
            int j = 0;
            int i2 = 0;
            while (i2 < inputPrefixes.size()) {
                if (selectedPrefixes[i2] != null) {
                    strippedPrefixes[j++] = selectedPrefixes[i2];
                    if (j >= numOk) {
                        if (CIMTraceUtil.traceLevel >= 3) {
                            myLogger.debug("Internal error when stripping invalid prefixes: " + selectedPrefixes[i2] + " " + j + " " + numOk);
                        }
                        --j;
                    }
                }
                ++i2;
            }
            allowedPrefixes = strippedPrefixes;
        }
        return allowedPrefixes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

