/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.ProcessMonitor;
import org.eclipse.debug.internal.core.StreamsProxy;

public class RuntimeProcess
extends PlatformObject
implements IProcess {
    private static final int MAX_WAIT_FOR_DEATH_ATTEMPTS = 10;
    private static final int TIME_TO_WAIT_FOR_THREAD_DEATH = 500;
    private ILaunch fLaunch;
    private Process fProcess;
    private int fExitValue;
    private ProcessMonitor fMonitor;
    private StreamsProxy fStreamsProxy;
    private String fName;
    private boolean fTerminated;
    private Map fAttributes;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RuntimeProcess(ILaunch launch, Process process, String name, Map attributes) {
        this.setLaunch(launch);
        this.fAttributes = attributes;
        this.fProcess = process;
        this.fName = name;
        this.fTerminated = true;
        try {
            process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.fTerminated = false;
        }
        this.fStreamsProxy = new StreamsProxy(this);
        this.fMonitor = new ProcessMonitor(this);
        launch.addProcess(this);
        this.fireCreationEvent();
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    protected InputStream getErrorStream() {
        return this.fProcess.getErrorStream();
    }

    protected InputStream getInputStream() {
        return this.fProcess.getInputStream();
    }

    protected OutputStream getOutputStream() {
        return this.fProcess.getOutputStream();
    }

    public String getLabel() {
        return this.fName;
    }

    private void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    protected Process getSystemProcess() {
        return this.fProcess;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            this.fProcess.destroy();
            this.fStreamsProxy.kill();
            int attempts = 0;
            while (attempts < 10) {
                try {
                    if (this.fProcess != null) {
                        this.fExitValue = this.fProcess.exitValue();
                    }
                    return;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++attempts;
                }
            }
            this.fMonitor.killMonitoring();
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, DebugCoreMessages.getString("RuntimeProcess.terminate_failed"), null);
            throw new DebugException((IStatus)status);
        }
    }

    protected void terminated() {
        this.fStreamsProxy.close();
        this.fTerminated = true;
        try {
            this.fExitValue = this.fProcess.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {}
        this.fProcess = null;
        this.fireTerminateEvent();
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fStreamsProxy;
    }

    private void fireCreationEvent() {
        this.fireEvent(new DebugEvent(this, 4));
    }

    private void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    private void fireTerminateEvent() {
        this.fireEvent(new DebugEvent(this, 8));
    }

    public void setAttribute(String key, String value) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap(5);
        }
        this.fAttributes.put(key, value);
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return (String)this.fAttributes.get(key);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IProcess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (this.equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.fExitValue;
        }
        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, DebugCoreMessages.getString("RuntimeProcess.Exit_value_not_available_until_process_terminates._1"), null));
    }
}

