/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.ListenerList;

public class OutputStreamMonitor
implements IFlushableStreamMonitor {
    private InputStream fStream;
    private ListenerList fListeners = new ListenerList(1);
    private boolean fBuffered = true;
    private StringBuffer fContents;
    private Thread fThread;
    private static final int BUFFER_SIZE = 8192;
    private boolean fKilled = false;

    public OutputStreamMonitor(InputStream stream) {
        this.fStream = stream;
        this.fContents = new StringBuffer();
    }

    public void addListener(IStreamListener listener) {
        this.fListeners.add(listener);
    }

    protected void close() {
        if (this.fThread != null) {
            Thread thread = this.fThread;
            this.fThread = null;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.fListeners.removeAll();
        }
    }

    private void fireStreamAppended(String text) {
        this.getNotifier().notifyAppend(text);
    }

    public String getContents() {
        return this.fContents.toString();
    }

    private void read() {
        byte[] bytes = new byte[8192];
        int read = 0;
        while (read >= 0) {
            try {
                if (this.fKilled) break;
                read = this.fStream.read(bytes);
                if (read <= 0) continue;
                String text = new String(bytes, 0, read);
                if (this.isBuffered()) {
                    this.fContents.append(text);
                }
                this.fireStreamAppended(text);
            }
            catch (IOException ioe) {
                DebugPlugin.log(ioe);
                return;
            }
            catch (NullPointerException e) {
                if (!this.fKilled || this.fThread != null) {
                    DebugPlugin.log(e);
                }
                return;
            }
        }
        try {
            this.fStream.close();
        }
        catch (IOException e) {
            DebugPlugin.log(e);
        }
    }

    protected void kill() {
        this.fKilled = true;
    }

    public void removeListener(IStreamListener listener) {
        this.fListeners.remove(listener);
    }

    protected void startMonitoring() {
        if (this.fThread == null) {
            this.fThread = new Thread(new Runnable(){

                public void run() {
                    OutputStreamMonitor.this.read();
                }
            }, DebugCoreMessages.getString("OutputStreamMonitor.label"));
            this.fThread.start();
        }
    }

    public void setBuffered(boolean buffer) {
        this.fBuffered = buffer;
    }

    public void flushContents() {
        this.fContents.setLength(0);
    }

    public boolean isBuffered() {
        return this.fBuffered;
    }

    private ContentNotifier getNotifier() {
        return new ContentNotifier();
    }

    class ContentNotifier
    implements ISafeRunnable {
        private IStreamListener fListener;
        private String fText;

        ContentNotifier() {
        }

        public void handleException(Throwable exception) {
        }

        public void run() throws Exception {
            this.fListener.streamAppended(this.fText, OutputStreamMonitor.this);
        }

        public void notifyAppend(String text) {
            if (text == null) {
                return;
            }
            this.fText = text;
            Object[] copiedListeners = OutputStreamMonitor.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (IStreamListener)copiedListeners[i];
                Platform.run((ISafeRunnable)this);
                ++i;
            }
            this.fListener = null;
            this.fText = null;
        }
    }
}

