/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfigurationComparator;
import org.eclipse.debug.internal.core.LaunchConfigurationInfo;
import org.eclipse.debug.internal.core.LaunchConfigurationType;
import org.eclipse.debug.internal.core.ListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LaunchManager
implements ILaunchManager,
IResourceChangeListener {
    private List fLaunchConfigurationTypes = null;
    private Map fLaunchConfigurations = new HashMap(10);
    private String[] fSortedConfigNames = null;
    private List fLaunchConfigurationIndex = null;
    private Map fComparators = null;
    public static final int ADDED = 0;
    public static final int REMOVED = 1;
    public static final int CHANGED = 2;
    private Vector fLaunches = new Vector(10);
    private ListenerList fListeners = new ListenerList(5);
    private ListenerList fLaunchesListeners = new ListenerList(5);
    private IResourceDeltaVisitor fgVisitor;
    private ListenerList fLaunchConfigurationListeners = new ListenerList(5);
    private Map fSourceLocators = null;
    private ILaunchConfiguration fFrom;
    private ILaunchConfiguration fTo;
    protected static final IPath LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH = DebugPlugin.getDefault().getStateLocation().append(".launches");

    public static String serializeDocument(Document doc) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setLineSeparator(System.getProperty("line.separator"));
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)s, "UTF8"), format);
        serializer.asDOMSerializer().serialize(doc);
        return s.toString("UTF8");
    }

    public void addLaunchListener(ILaunchListener listener) {
        this.fListeners.add(listener);
    }

    private List getAllLaunchConfigurations() throws CoreException {
        block2: {
            if (this.fLaunchConfigurationIndex != null) break block2;
            try {
                this.fLaunchConfigurationIndex = new ArrayList(20);
                List configs = this.findLocalLaunchConfigurations();
                this.verifyConfigurations(configs, this.fLaunchConfigurationIndex);
                configs = this.findLaunchConfigurations((IContainer)this.getWorkspaceRoot());
                this.verifyConfigurations(configs, this.fLaunchConfigurationIndex);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
                throw throwable;
            }
            Object var2_4 = null;
            this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        return this.fLaunchConfigurationIndex;
    }

    protected void verifyConfigurations(List verify, List valid) {
        Iterator configs = verify.iterator();
        while (configs.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)configs.next();
            if (!this.isValid(config)) continue;
            valid.add(config);
        }
    }

    protected boolean isValid(ILaunchConfiguration config) {
        try {
            config.getType();
        }
        catch (CoreException e) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, MessageFormat.format(DebugCoreMessages.getString("LaunchManager.Unable_to_restore_invalid_launch_configuration"), config.getLocation().toOSString()), (Throwable)e);
            DebugPlugin.log((IStatus)status);
            return false;
        }
        return true;
    }

    private void clearAllLaunchConfigurations() {
        if (this.fLaunchConfigurationTypes != null) {
            this.fLaunchConfigurationTypes.clear();
        }
        if (this.fLaunchConfigurationIndex != null) {
            this.fLaunchConfigurationIndex.clear();
        }
    }

    public void removeLaunch(ILaunch launch) {
        if (this.internalRemoveLaunch(launch)) {
            this.fireUpdate(launch, 1);
            this.fireUpdate(new ILaunch[]{launch}, 1);
        }
    }

    protected boolean internalRemoveLaunch(ILaunch launch) {
        if (launch == null) {
            return false;
        }
        return this.fLaunches.remove(launch);
    }

    public void fireUpdate(ILaunch launch, int update) {
        this.getLaunchNotifier().notify(launch, update);
    }

    public void fireUpdate(ILaunch[] launches, int update) {
        this.getLaunchesNotifier().notify(launches, update);
    }

    protected boolean isRegistered(ILaunch launch) {
        return this.fLaunches.contains(launch);
    }

    public IDebugTarget[] getDebugTargets() {
        ArrayList<IDebugTarget> allTargets = new ArrayList<IDebugTarget>(this.fLaunches.size());
        if (this.fLaunches.size() > 0) {
            Iterator e = ((AbstractList)this.fLaunches).iterator();
            while (e.hasNext()) {
                IDebugTarget[] targets = ((ILaunch)e.next()).getDebugTargets();
                int i = 0;
                while (i < targets.length) {
                    allTargets.add(targets[i]);
                    ++i;
                }
            }
        }
        return allTargets.toArray(new IDebugTarget[allTargets.size()]);
    }

    public ILaunch[] getLaunches() {
        return this.fLaunches.toArray(new ILaunch[this.fLaunches.size()]);
    }

    public IProcess[] getProcesses() {
        ArrayList<IProcess> allProcesses = new ArrayList<IProcess>(this.fLaunches.size());
        Iterator e = ((AbstractList)this.fLaunches).iterator();
        while (e.hasNext()) {
            IProcess[] processes = ((ILaunch)e.next()).getProcesses();
            int i = 0;
            while (i < processes.length) {
                allProcesses.add(processes[i]);
                ++i;
            }
        }
        return allProcesses.toArray(new IProcess[allProcesses.size()]);
    }

    public void addLaunch(ILaunch launch) {
        if (this.internalAddLaunch(launch)) {
            this.fireUpdate(launch, 0);
            this.fireUpdate(new ILaunch[]{launch}, 0);
        }
    }

    protected boolean internalAddLaunch(ILaunch launch) {
        if (this.fLaunches.contains(launch)) {
            return false;
        }
        this.fLaunches.add(launch);
        return true;
    }

    public void removeLaunchListener(ILaunchListener listener) {
        this.fListeners.remove(listener);
    }

    protected LaunchConfigurationInfo createInfoFromXML(InputStream stream) throws CoreException, ParserConfigurationException, IOException, SAXException {
        Element root = null;
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        root = parser.parse(new InputSource(stream)).getDocumentElement();
        LaunchConfigurationInfo info = new LaunchConfigurationInfo();
        info.initializeFromXML(root);
        return info;
    }

    public void shutdown() throws CoreException {
        this.fListeners.removeAll();
        ILaunch[] launches = this.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            try {
                launch.terminate();
            }
            catch (DebugException e) {
                DebugPlugin.log((Throwable)((Object)e));
            }
            ++i;
        }
        this.clearAllLaunchConfigurations();
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected LaunchConfigurationInfo getInfo(ILaunchConfiguration config) throws CoreException {
        LaunchConfigurationInfo info = (LaunchConfigurationInfo)this.fLaunchConfigurations.get(config);
        if (info == null) {
            if (config.exists()) {
                InputStream stream = null;
                try {
                    try {
                        if (config.isLocal()) {
                            IPath path = config.getLocation();
                            File file = path.toFile();
                            stream = new FileInputStream(file);
                        } else {
                            IFile file = ((LaunchConfiguration)config).getFile();
                            stream = file.getContents();
                        }
                        info = this.createInfoFromXML(stream);
                        this.fLaunchConfigurations.put(config, info);
                    }
                    catch (FileNotFoundException e) {
                        throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString("LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                    }
                    catch (SAXException e) {
                        throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString("LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                    }
                    catch (ParserConfigurationException e) {
                        throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString("LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                    }
                    catch (IOException e) {
                        throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString("LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString("LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                        }
                    }
                    throw throwable;
                }
                Object var6_13 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString("LaunchManager.{0}_occurred_while_reading_launch_configuration_file._1"), e.toString()), e);
                    }
                }
            } else {
                throw this.createDebugException(MessageFormat.format(DebugCoreMessages.getString("LaunchManager.does_not_exist"), config.getName(), config.getLocation().toOSString()), null);
            }
        }
        return info;
    }

    protected DebugException createDebugException(String message, Throwable throwable) {
        return new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, message, throwable));
    }

    private void removeInfo(ILaunchConfiguration configuration) {
        this.fLaunchConfigurations.remove(configuration);
    }

    public ILaunchConfiguration[] getLaunchConfigurations() throws CoreException {
        List allConfigs = this.getAllLaunchConfigurations();
        return allConfigs.toArray(new ILaunchConfiguration[allConfigs.size()]);
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ILaunchConfigurationType type) throws CoreException {
        Iterator iter = this.getAllLaunchConfigurations().iterator();
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        while (iter.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)iter.next();
            if (!config.getType().equals(type)) continue;
            configs.add(config);
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    protected List getLaunchConfigurations(IProject project) throws CoreException {
        Iterator iter = this.getAllLaunchConfigurations().iterator();
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        while (iter.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)iter.next();
            IFile file = config.getFile();
            if (file == null || !file.getProject().equals((Object)project)) continue;
            configs.add(config);
        }
        return configs;
    }

    protected List getLocalLaunchConfigurations() throws CoreException {
        Iterator iter = this.getAllLaunchConfigurations().iterator();
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        while (iter.hasNext()) {
            ILaunchConfiguration config = (ILaunchConfiguration)iter.next();
            if (!config.isLocal()) continue;
            configs.add(config);
        }
        return configs;
    }

    public ILaunchConfiguration getLaunchConfiguration(IFile file) {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        return new LaunchConfiguration(file.getLocation());
    }

    public ILaunchConfiguration getLaunchConfiguration(String memento) throws CoreException {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        return new LaunchConfiguration(memento);
    }

    public ILaunchConfigurationType[] getLaunchConfigurationTypes() {
        List types = this.getLaunchConfigurationTypeList();
        return types.toArray(new ILaunchConfigurationType[types.size()]);
    }

    public ILaunchConfigurationType getLaunchConfigurationType(String id) {
        Iterator iter = this.getLaunchConfigurationTypeList().iterator();
        while (iter.hasNext()) {
            ILaunchConfigurationType type = (ILaunchConfigurationType)iter.next();
            if (!type.getIdentifier().equals(id)) continue;
            return type;
        }
        return null;
    }

    private List getLaunchConfigurationTypeList() {
        if (this.fLaunchConfigurationTypes == null) {
            this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            this.initializeLaunchConfigurationTypes();
        }
        return this.fLaunchConfigurationTypes;
    }

    private void initializeLaunchConfigurationTypes() {
        IPluginDescriptor descriptor = DebugPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("launchConfigurationTypes");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fLaunchConfigurationTypes = new ArrayList(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            LaunchConfigurationType configType = new LaunchConfigurationType(configurationElement);
            this.fLaunchConfigurationTypes.add(configType);
            ++i;
        }
    }

    protected void launchConfigurationDeleted(ILaunchConfiguration config) throws CoreException {
        this.removeInfo(config);
        this.getAllLaunchConfigurations().remove(config);
        this.getConfigurationNotifier().notify(config, 1);
        this.clearConfigNameCache();
    }

    protected void launchConfigurationAdded(ILaunchConfiguration config) throws CoreException {
        if (this.isValid(config)) {
            List allConfigs = this.getAllLaunchConfigurations();
            if (!allConfigs.contains(config)) {
                allConfigs.add(config);
            }
            this.getConfigurationNotifier().notify(config, 0);
            this.clearConfigNameCache();
        } else {
            this.launchConfigurationDeleted(config);
        }
    }

    protected void launchConfigurationChanged(ILaunchConfiguration config) {
        this.removeInfo(config);
        this.clearConfigNameCache();
        if (this.isValid(config)) {
            this.getConfigurationNotifier().notify(config, 2);
        } else {
            try {
                this.launchConfigurationDeleted(config);
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
    }

    public boolean isExistingLaunchConfigurationName(String name) throws CoreException {
        Object[] sortedConfigNames = this.getAllSortedConfigNames();
        int index = Arrays.binarySearch(sortedConfigNames, name);
        return index >= 0;
    }

    public String generateUniqueLaunchConfigurationNameFrom(String baseName) {
        String trailer;
        int index = 1;
        int length = baseName.length();
        int copyIndex = baseName.lastIndexOf(" (");
        if (copyIndex > -1 && length > copyIndex + 2 && baseName.charAt(length - 1) == ')' && this.isNumber(trailer = baseName.substring(copyIndex + 2, length - 1))) {
            try {
                index = Integer.parseInt(trailer);
                baseName = baseName.substring(0, copyIndex);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String newName = baseName;
        try {
            StringBuffer buffer = null;
            while (this.isExistingLaunchConfigurationName(newName)) {
                buffer = new StringBuffer(baseName);
                buffer.append(" (");
                buffer.append(String.valueOf(index));
                ++index;
                buffer.append(')');
                newName = buffer.toString();
            }
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
        return newName;
    }

    private boolean isNumber(String string) {
        int numChars = string.length();
        if (numChars == 0) {
            return false;
        }
        int i = 0;
        while (i < numChars) {
            if (!Character.isDigit(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String[] getAllSortedConfigNames() throws CoreException {
        if (this.fSortedConfigNames == null) {
            ILaunchConfiguration[] configs = this.getLaunchConfigurations();
            this.fSortedConfigNames = new String[configs.length];
            int i = 0;
            while (i < configs.length) {
                this.fSortedConfigNames[i] = configs[i].getName();
                ++i;
            }
            Arrays.sort(this.fSortedConfigNames);
        }
        return this.fSortedConfigNames;
    }

    protected void clearConfigNameCache() {
        this.fSortedConfigNames = null;
    }

    protected List findLocalLaunchConfigurations() throws CoreException {
        IPath containerPath = LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH;
        ArrayList<LaunchConfiguration> configs = new ArrayList<LaunchConfiguration>(10);
        final File directory = containerPath.toFile();
        if (directory.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return dir.equals(directory) && name.endsWith("launch");
                }
            };
            String[] files = directory.list(filter);
            int i = 0;
            while (i < files.length) {
                LaunchConfiguration config = new LaunchConfiguration(containerPath.append(files[i]));
                configs.add(config);
                ++i;
            }
        }
        return configs;
    }

    protected List findLaunchConfigurations(IContainer container) throws CoreException {
        ArrayList list = new ArrayList(10);
        if (container instanceof IProject && !((IProject)container).isOpen()) {
            return list;
        }
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(list);
        try {
            container.accept((IResourceProxyVisitor)visitor, 0);
        }
        catch (CoreException coreException) {}
        Iterator iter = list.iterator();
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>(list.size());
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            configs.add(this.getLaunchConfiguration(file));
        }
        return configs;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                if (this.fgVisitor == null) {
                    this.fgVisitor = new LaunchManagerVisitor();
                }
                delta.accept(this.fgVisitor);
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
    }

    protected List getConfigsFromXML(Element root) throws CoreException {
        DebugException invalidFormat = new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.getString("LaunchManager.Invalid_launch_configuration_index._18"), null));
        if (!root.getNodeName().equalsIgnoreCase("launchConfigurations")) {
            throw invalidFormat;
        }
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>(4);
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                Element entry = (Element)node;
                String nodeName = entry.getNodeName();
                if (!nodeName.equals("launchConfiguration")) {
                    throw invalidFormat;
                }
                String memento = entry.getAttribute("memento");
                if (memento == null) {
                    throw invalidFormat;
                }
                configs.add(this.getLaunchConfiguration(memento));
            }
            ++i;
        }
        return configs;
    }

    protected void projectOpened(IProject project) throws CoreException {
        List configs = this.findLaunchConfigurations((IContainer)project);
        if (!configs.isEmpty()) {
            Iterator iterator = configs.iterator();
            while (iterator.hasNext()) {
                ILaunchConfiguration config = (ILaunchConfiguration)iterator.next();
                this.launchConfigurationAdded(config);
            }
        }
    }

    protected void projectClosed(IProject project) throws CoreException {
        List configs = this.getLaunchConfigurations(project);
        if (!configs.isEmpty()) {
            Iterator iterator = configs.iterator();
            while (iterator.hasNext()) {
                ILaunchConfiguration configuration = (ILaunchConfiguration)iterator.next();
                this.launchConfigurationDeleted(configuration);
            }
        }
    }

    public void addLaunchConfigurationListener(ILaunchConfigurationListener listener) {
        this.fLaunchConfigurationListeners.add(listener);
    }

    public void removeLaunchConfigurationListener(ILaunchConfigurationListener listener) {
        this.fLaunchConfigurationListeners.remove(listener);
    }

    private void initializeSourceLocators() throws CoreException {
        IPluginDescriptor descriptor = DebugPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("sourceLocators");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fSourceLocators = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            String id = configurationElement.getAttribute("id");
            if (id != null) {
                this.fSourceLocators.put(id, configurationElement);
            } else {
                Status s = new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, MessageFormat.format(DebugCoreMessages.getString("LaunchManager.Invalid_source_locator_extentsion_defined_by_plug-in___{0}______id___not_specified_12"), configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier()), null);
                DebugPlugin.log((IStatus)s);
            }
            ++i;
        }
    }

    private void initializeComparators() {
        IPluginDescriptor descriptor = DebugPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("launchConfigurationComparators");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fComparators = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            String attr = configurationElement.getAttribute("attribute");
            if (attr != null) {
                this.fComparators.put(attr, new LaunchConfigurationComparator(configurationElement));
            } else {
                Status s = new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, MessageFormat.format(DebugCoreMessages.getString("LaunchManager.Invalid_launch_configuration_comparator_extension_defined_by_plug-in_{0}_-_attribute_not_specified_1"), configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier()), null);
                DebugPlugin.log((IStatus)s);
            }
            ++i;
        }
    }

    public IPersistableSourceLocator newSourceLocator(String identifier) throws CoreException {
        IConfigurationElement config;
        if (this.fSourceLocators == null) {
            this.initializeSourceLocators();
        }
        if ((config = (IConfigurationElement)this.fSourceLocators.get(identifier)) == null) {
            throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5013, MessageFormat.format(DebugCoreMessages.getString("LaunchManager.Source_locator_does_not_exist__{0}_13"), identifier), null));
        }
        return (IPersistableSourceLocator)config.createExecutableExtension("class");
    }

    protected Comparator getComparator(String attributeName) {
        Map map = this.getComparators();
        return (Comparator)map.get(attributeName);
    }

    protected Map getComparators() {
        if (this.fComparators == null) {
            this.initializeComparators();
        }
        return this.fComparators;
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return this.getWorkspace().getRoot();
    }

    public void addLaunches(ILaunch[] launches) {
        ArrayList<ILaunch> added = new ArrayList<ILaunch>(launches.length);
        int i = 0;
        while (i < launches.length) {
            if (this.internalAddLaunch(launches[i])) {
                added.add(launches[i]);
            }
            ++i;
        }
        if (!added.isEmpty()) {
            ILaunch[] addedLaunches = added.toArray(new ILaunch[added.size()]);
            this.fireUpdate(addedLaunches, 0);
            int i2 = 0;
            while (i2 < addedLaunches.length) {
                this.fireUpdate(launches[i2], 0);
                ++i2;
            }
        }
    }

    public void addLaunchListener(ILaunchesListener listener) {
        this.fLaunchesListeners.add(listener);
    }

    public void removeLaunches(ILaunch[] launches) {
        ArrayList<ILaunch> removed = new ArrayList<ILaunch>(launches.length);
        int i = 0;
        while (i < launches.length) {
            if (this.internalRemoveLaunch(launches[i])) {
                removed.add(launches[i]);
            }
            ++i;
        }
        if (!removed.isEmpty()) {
            ILaunch[] removedLaunches = removed.toArray(new ILaunch[removed.size()]);
            this.fireUpdate(removedLaunches, 1);
            int i2 = 0;
            while (i2 < removedLaunches.length) {
                this.fireUpdate(removedLaunches[i2], 1);
                ++i2;
            }
        }
    }

    public void removeLaunchListener(ILaunchesListener listener) {
        this.fLaunchesListeners.remove(listener);
    }

    protected void setMovedFromTo(ILaunchConfiguration from, ILaunchConfiguration to) {
        this.fFrom = from;
        this.fTo = to;
    }

    public ILaunchConfiguration getMovedFrom(ILaunchConfiguration addedConfiguration) {
        if (addedConfiguration.equals(this.fTo)) {
            return this.fFrom;
        }
        return null;
    }

    public ILaunchConfiguration getMovedTo(ILaunchConfiguration removedConfiguration) {
        if (removedConfiguration.equals(this.fFrom)) {
            return this.fTo;
        }
        return null;
    }

    private LaunchNotifier getLaunchNotifier() {
        return new LaunchNotifier();
    }

    private LaunchesNotifier getLaunchesNotifier() {
        return new LaunchesNotifier();
    }

    protected ConfigurationNotifier getConfigurationNotifier() {
        return new ConfigurationNotifier();
    }

    class LaunchManagerVisitor
    implements IResourceDeltaVisitor {
        LaunchManagerVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            if ((delta.getFlags() & 0x4000) != 0) {
                if (delta.getResource() instanceof IProject) {
                    IProject project = (IProject)delta.getResource();
                    try {
                        if (project.isOpen()) {
                            LaunchManager.this.projectOpened(project);
                        } else {
                            LaunchManager.this.projectClosed(project);
                        }
                    }
                    catch (CoreException e) {
                        DebugPlugin.log(e);
                    }
                }
                return false;
            }
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if ("launch".equals(file.getFileExtension())) {
                    IPath configPath = file.getLocation();
                    if (configPath == null) {
                        IPath workspaceRelativePath = delta.getFullPath();
                        configPath = LaunchManager.this.getWorkspaceRoot().getLocation().append(workspaceRelativePath);
                    }
                    LaunchConfiguration handle = new LaunchConfiguration(configPath);
                    try {
                        switch (delta.getKind()) {
                            case 1: {
                                LaunchManager.this.launchConfigurationAdded(handle);
                                break;
                            }
                            case 2: {
                                LaunchManager.this.launchConfigurationDeleted(handle);
                                break;
                            }
                            case 4: {
                                LaunchManager.this.launchConfigurationChanged(handle);
                            }
                        }
                    }
                    catch (CoreException e) {
                        DebugPlugin.log(e);
                    }
                }
                return false;
            }
            if (resource instanceof IContainer) {
                return true;
            }
            return true;
        }
    }

    class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private List fList;

        protected ResourceProxyVisitor(List list) {
            this.fList = list;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (proxy.getType() == 1) {
                if ("launch".equalsIgnoreCase(proxy.requestFullPath().getFileExtension())) {
                    this.fList.add(proxy.requestResource());
                }
                return false;
            }
            return true;
        }
    }

    class LaunchNotifier
    implements ISafeRunnable {
        private ILaunchListener fListener;
        private int fType;
        private ILaunch fLaunch;

        LaunchNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("LaunchManager.An_exception_occurred_during_launch_change_notification._1"), exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.launchAdded(this.fLaunch);
                    break;
                }
                case 1: {
                    this.fListener.launchRemoved(this.fLaunch);
                    break;
                }
                case 2: {
                    if (!LaunchManager.this.isRegistered(this.fLaunch)) break;
                    this.fListener.launchChanged(this.fLaunch);
                }
            }
        }

        public void notify(ILaunch launch, int update) {
            this.fLaunch = launch;
            this.fType = update;
            Object[] copiedListeners = LaunchManager.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (ILaunchListener)copiedListeners[i];
                Platform.run((ISafeRunnable)this);
                ++i;
            }
            this.fLaunch = null;
            this.fListener = null;
        }
    }

    class LaunchesNotifier
    implements ISafeRunnable {
        private ILaunchesListener fListener;
        private int fType;
        private ILaunch[] fLaunches;
        private ILaunch[] fRegistered;

        LaunchesNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("LaunchManager.An_exception_occurred_during_launch_change_notification._2"), exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.launchesAdded(this.fLaunches);
                    break;
                }
                case 1: {
                    this.fListener.launchesRemoved(this.fLaunches);
                    break;
                }
                case 2: {
                    if (this.fRegistered == null) {
                        ArrayList<ILaunch> registered = null;
                        int j = 0;
                        while (j < this.fLaunches.length) {
                            if (LaunchManager.this.isRegistered(this.fLaunches[j])) {
                                if (registered != null) {
                                    registered.add(this.fLaunches[j]);
                                }
                            } else if (registered == null) {
                                registered = new ArrayList<ILaunch>(this.fLaunches.length);
                                int k = 0;
                                while (k < j) {
                                    registered.add(this.fLaunches[k]);
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        this.fRegistered = registered == null ? this.fLaunches : registered.toArray(new ILaunch[registered.size()]);
                    }
                    if (this.fRegistered.length <= 0) break;
                    this.fListener.launchesChanged(this.fRegistered);
                }
            }
        }

        public void notify(ILaunch[] launches, int update) {
            this.fLaunches = launches;
            this.fType = update;
            this.fRegistered = null;
            Object[] copiedListeners = LaunchManager.this.fLaunchesListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (ILaunchesListener)copiedListeners[i];
                Platform.run((ISafeRunnable)this);
                ++i;
            }
            this.fLaunches = null;
            this.fRegistered = null;
            this.fListener = null;
        }
    }

    class ConfigurationNotifier
    implements ISafeRunnable {
        private ILaunchConfigurationListener fListener;
        private int fType;
        private ILaunchConfiguration fConfiguration;

        ConfigurationNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("LaunchManager.An_exception_occurred_during_launch_configuration_change_notification._3"), exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.launchConfigurationAdded(this.fConfiguration);
                    break;
                }
                case 1: {
                    this.fListener.launchConfigurationRemoved(this.fConfiguration);
                    break;
                }
                case 2: {
                    this.fListener.launchConfigurationChanged(this.fConfiguration);
                }
            }
        }

        public void notify(ILaunchConfiguration configuration, int update) {
            this.fConfiguration = configuration;
            this.fType = update;
            if (LaunchManager.this.fLaunchConfigurationListeners.size() > 0) {
                Object[] listeners = LaunchManager.this.fLaunchConfigurationListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    this.fListener = (ILaunchConfigurationListener)listeners[i];
                    Platform.run((ISafeRunnable)this);
                    ++i;
                }
            }
            this.fConfiguration = null;
            this.fListener = null;
        }
    }
}

