/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfigurationWorkingCopy;

public class LaunchConfigurationType
extends PlatformObject
implements ILaunchConfigurationType {
    private IConfigurationElement fElement;
    private Set fModes;
    private ILaunchConfigurationDelegate fDelegate;

    protected LaunchConfigurationType(IConfigurationElement element) {
        this.setConfigurationElement(element);
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fElement = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    public boolean supportsMode(String mode) {
        return this.getModes().contains(mode);
    }

    protected Set getModes() {
        if (this.fModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return new HashSet(0);
            }
            StringTokenizer tokenizer = new StringTokenizer(modes, ",");
            this.fModes = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fModes.add(tokenizer.nextToken().trim());
            }
        }
        return this.fModes;
    }

    public String getName() {
        return this.getConfigurationElement().getAttribute("name");
    }

    public String getIdentifier() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }

    public String getAttribute(String attributeName) {
        return this.getConfigurationElement().getAttribute(attributeName);
    }

    public boolean isPublic() {
        String publicString = this.getConfigurationElement().getAttribute("public");
        return publicString == null || !publicString.equalsIgnoreCase("false");
    }

    public ILaunchConfigurationWorkingCopy newInstance(IContainer container, String name) throws CoreException {
        return new LaunchConfigurationWorkingCopy(container, name, this);
    }

    public ILaunchConfigurationDelegate getDelegate() throws CoreException {
        if (this.fDelegate == null) {
            Object delegate = this.getConfigurationElement().createExecutableExtension("delegate");
            if (delegate instanceof ILaunchConfigurationDelegate) {
                this.fDelegate = (ILaunchConfigurationDelegate)delegate;
            } else {
                throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, MessageFormat.format(DebugCoreMessages.getString("LaunchConfigurationType.Launch_delegate_for_{0}_does_not_implement_required_interface_ILaunchConfigurationDelegate._1"), this.getName()), null));
            }
        }
        return this.fDelegate;
    }
}

