/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.ListenerList;

public class ExpressionManager
implements IExpressionManager,
IDebugEventSetListener {
    private Vector fExpressions = null;
    private ListenerList fListeners = null;
    private ListenerList fExpressionsListeners = null;
    private static final int ADDED = 1;
    private static final int CHANGED = 2;
    private static final int REMOVED = 3;

    public void addExpression(IExpression expression) {
        this.addExpressions(new IExpression[]{expression});
    }

    public void addExpressions(IExpression[] expressions) {
        if (this.fExpressions == null) {
            this.fExpressions = new Vector(expressions.length);
        }
        boolean wasEmpty = this.fExpressions.isEmpty();
        ArrayList<IExpression> added = new ArrayList<IExpression>(expressions.length);
        int i = 0;
        while (i < expressions.length) {
            IExpression expression = expressions[i];
            if (this.fExpressions.indexOf(expression) == -1) {
                added.add(expression);
                this.fExpressions.add(expression);
            }
            ++i;
        }
        if (wasEmpty) {
            DebugPlugin.getDefault().addDebugEventListener(this);
        }
        if (!added.isEmpty()) {
            this.fireUpdate(added.toArray(new IExpression[added.size()]), 1);
        }
    }

    public IExpression[] getExpressions() {
        if (this.fExpressions == null) {
            return new IExpression[0];
        }
        Object[] temp = new IExpression[this.fExpressions.size()];
        this.fExpressions.copyInto(temp);
        return temp;
    }

    public IExpression[] getExpressions(String modelIdentifier) {
        if (this.fExpressions == null) {
            return new IExpression[0];
        }
        ArrayList<IExpression> temp = new ArrayList<IExpression>(this.fExpressions.size());
        Iterator iter = ((AbstractList)this.fExpressions).iterator();
        while (iter.hasNext()) {
            IExpression expression = (IExpression)iter.next();
            String id = expression.getModelIdentifier();
            if (id == null || !id.equals(modelIdentifier)) continue;
            temp.add(expression);
        }
        return temp.toArray(new IExpression[temp.size()]);
    }

    public void removeExpression(IExpression expression) {
        this.removeExpressions(new IExpression[]{expression});
    }

    public void removeExpressions(IExpression[] expressions) {
        if (this.fExpressions == null) {
            return;
        }
        ArrayList<IExpression> removed = new ArrayList<IExpression>(expressions.length);
        int i = 0;
        while (i < expressions.length) {
            IExpression expression = expressions[i];
            if (this.fExpressions.remove(expression)) {
                removed.add(expression);
                expression.dispose();
            }
            ++i;
        }
        if (this.fExpressions.isEmpty()) {
            DebugPlugin.getDefault().removeDebugEventListener(this);
        }
        if (!removed.isEmpty()) {
            this.fireUpdate(removed.toArray(new IExpression[removed.size()]), 3);
        }
    }

    public void addExpressionListener(IExpressionListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList(2);
        }
        this.fListeners.add(listener);
    }

    public void removeExpressionListener(IExpressionListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove(listener);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ArrayList<Object> changed = null;
            DebugEvent event = events[i];
            if (event.getSource() instanceof IExpression) {
                switch (event.getKind()) {
                    case 16: {
                        if (changed == null) {
                            changed = new ArrayList<Object>(1);
                        }
                        changed.add(event.getSource());
                        break;
                    }
                }
            }
            if (changed != null) {
                IExpression[] array = changed.toArray(new IExpression[changed.size()]);
                this.fireUpdate(array, 2);
            }
            ++i;
        }
    }

    private void fireUpdate(IExpression[] expressions, int update) {
        this.getExpressionNotifier().notify(expressions, update);
        this.getExpressionsNotifier().notify(expressions, update);
    }

    public boolean hasExpressions() {
        return this.fExpressions != null;
    }

    public void addExpressionListener(IExpressionsListener listener) {
        if (this.fExpressionsListeners == null) {
            this.fExpressionsListeners = new ListenerList(2);
        }
        this.fExpressionsListeners.add(listener);
    }

    public void removeExpressionListener(IExpressionsListener listener) {
        if (this.fExpressionsListeners == null) {
            return;
        }
        this.fExpressionsListeners.remove(listener);
    }

    private ExpressionNotifier getExpressionNotifier() {
        return new ExpressionNotifier();
    }

    private ExpressionsNotifier getExpressionsNotifier() {
        return new ExpressionsNotifier();
    }

    class ExpressionNotifier
    implements ISafeRunnable {
        private IExpressionListener fListener;
        private int fType;
        private IExpression fExpression;

        ExpressionNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("ExpressionManager.An_exception_occurred_during_expression_change_notification._1"), exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 1: {
                    this.fListener.expressionAdded(this.fExpression);
                    break;
                }
                case 3: {
                    this.fListener.expressionRemoved(this.fExpression);
                    break;
                }
                case 2: {
                    this.fListener.expressionChanged(this.fExpression);
                }
            }
        }

        public void notify(IExpression[] expressions, int update) {
            if (ExpressionManager.this.fListeners != null) {
                this.fType = update;
                Object[] copiedListeners = ExpressionManager.this.fListeners.getListeners();
                int i = 0;
                while (i < copiedListeners.length) {
                    this.fListener = (IExpressionListener)copiedListeners[i];
                    int j = 0;
                    while (j < expressions.length) {
                        this.fExpression = expressions[j];
                        Platform.run((ISafeRunnable)this);
                        ++j;
                    }
                    ++i;
                }
            }
            this.fListener = null;
            this.fExpression = null;
        }
    }

    class ExpressionsNotifier
    implements ISafeRunnable {
        private IExpressionsListener fListener;
        private int fType;
        private IExpression[] fExpressions;

        ExpressionsNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("ExpressionManager.An_exception_occurred_during_expression_change_notification._2"), exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 1: {
                    this.fListener.expressionsAdded(this.fExpressions);
                    break;
                }
                case 3: {
                    this.fListener.expressionsRemoved(this.fExpressions);
                    break;
                }
                case 2: {
                    this.fListener.expressionsChanged(this.fExpressions);
                }
            }
        }

        public void notify(IExpression[] expressions, int update) {
            if (ExpressionManager.this.fExpressionsListeners != null) {
                this.fExpressions = expressions;
                this.fType = update;
                Object[] copiedListeners = ExpressionManager.this.fExpressionsListeners.getListeners();
                int i = 0;
                while (i < copiedListeners.length) {
                    this.fListener = (IExpressionsListener)copiedListeners[i];
                    Platform.run((ISafeRunnable)this);
                    ++i;
                }
            }
            this.fExpressions = null;
            this.fListener = null;
        }
    }
}

