/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.ListenerList;

public class BreakpointManager
implements IBreakpointManager,
IResourceChangeListener {
    private static final int ADDED = 0;
    private static final int REMOVED = 1;
    private static final int CHANGED = 2;
    private static final String CLASS = "class";
    private static final String MARKER_TYPE = "markerType";
    private Vector fBreakpoints = null;
    private List fSuppressChange = new ArrayList();
    private HashMap fBreakpointExtensions;
    private HashMap fMarkersToBreakpoints;
    private ListenerList fBreakpointListeners = new ListenerList(6);
    private ListenerList fBreakpointsListeners = new ListenerList(6);
    private static BreakpointManagerVisitor fgVisitor;

    public BreakpointManager() {
        this.fMarkersToBreakpoints = new HashMap(10);
        this.fBreakpointExtensions = new HashMap(15);
    }

    private void loadBreakpoints(IResource resource) throws CoreException {
        this.initBreakpointExtensions();
        IMarker[] markers = this.getPersistedMarkers(resource);
        ArrayList<IBreakpoint> added = new ArrayList<IBreakpoint>();
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            try {
                IBreakpoint breakpoint = this.createBreakpoint(marker);
                if (breakpoint.isRegistered()) {
                    added.add(breakpoint);
                }
            }
            catch (DebugException e) {
                DebugPlugin.log((Throwable)((Object)e));
            }
            ++i;
        }
        this.addBreakpoints(added.toArray(new IBreakpoint[added.size()]));
    }

    protected IMarker[] getPersistedMarkers(IResource resource) throws CoreException {
        IMarker[] markers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
        final ArrayList<IMarker> delete = new ArrayList<IMarker>();
        ArrayList<IMarker> persisted = new ArrayList<IMarker>();
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            String modelId = marker.getAttribute("org.eclipse.debug.core.id", null);
            if (modelId == null) {
                delete.add(marker);
            } else if (!marker.getAttribute("org.eclipse.debug.core.persisted", true)) {
                delete.add(marker);
            } else {
                persisted.add(marker);
            }
            ++i;
        }
        if (!delete.isEmpty()) {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor pm) throws CoreException {
                    ResourcesPlugin.getWorkspace().deleteMarkers(delete.toArray(new IMarker[delete.size()]));
                }
            };
            this.fork(wr);
        }
        return persisted.toArray(new IMarker[persisted.size()]);
    }

    public void shutdown() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.fBreakpointListeners.removeAll();
    }

    private void initBreakpointExtensions() {
        IExtensionPoint ep = DebugPlugin.getDefault().getDescriptor().getExtensionPoint("breakpoints");
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String markerType = elements[i].getAttribute(MARKER_TYPE);
            String className = elements[i].getAttribute(CLASS);
            if (markerType == null) {
                this.invalidBreakpointExtension(MessageFormat.format(DebugCoreMessages.getString("BreakpointManager.Breakpoint_extension_{0}_missing_required_attribute__markerType_1"), elements[i].getDeclaringExtension().getUniqueIdentifier()));
            } else if (className == null) {
                this.invalidBreakpointExtension(MessageFormat.format(DebugCoreMessages.getString("BreakpointManager.Breakpoint_extension_{0}_missing_required_attribute__class_2"), elements[i].getDeclaringExtension().getUniqueIdentifier()));
            } else {
                this.fBreakpointExtensions.put(markerType, elements[i]);
            }
            ++i;
        }
    }

    private void invalidBreakpointExtension(String message) {
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, message, null);
        DebugPlugin.log((IStatus)status);
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IBreakpoint getBreakpoint(IMarker marker) {
        this.getBreakpoints0();
        return (IBreakpoint)this.fMarkersToBreakpoints.get(marker);
    }

    public IBreakpoint[] getBreakpoints() {
        Vector breakpoints = this.getBreakpoints0();
        Object[] temp = new IBreakpoint[breakpoints.size()];
        breakpoints.copyInto(temp);
        return temp;
    }

    private Vector getBreakpoints0() {
        if (this.fBreakpoints == null) {
            this.initializeBreakpoints();
        }
        return this.fBreakpoints;
    }

    public IBreakpoint[] getBreakpoints(String modelIdentifier) {
        Vector allBreakpoints = this.getBreakpoints0();
        ArrayList<IBreakpoint> temp = new ArrayList<IBreakpoint>(allBreakpoints.size());
        Iterator breakpoints = ((AbstractList)allBreakpoints).iterator();
        while (breakpoints.hasNext()) {
            IBreakpoint breakpoint = (IBreakpoint)breakpoints.next();
            String id = breakpoint.getModelIdentifier();
            if (id == null || !id.equals(modelIdentifier)) continue;
            temp.add(breakpoint);
        }
        return temp.toArray(new IBreakpoint[temp.size()]);
    }

    private void initializeBreakpoints() {
        this.setBreakpoints(new Vector(10));
        try {
            this.loadBreakpoints((IResource)this.getWorkspace().getRoot());
            this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
        }
        catch (CoreException ce) {
            DebugPlugin.log(ce);
            this.setBreakpoints(new Vector(0));
        }
    }

    public boolean isRegistered(IBreakpoint breakpoint) {
        return this.getBreakpoints0().contains(breakpoint);
    }

    public void removeBreakpoint(IBreakpoint breakpoint, boolean delete) throws CoreException {
        this.removeBreakpoints(new IBreakpoint[]{breakpoint}, delete);
    }

    public void removeBreakpoints(IBreakpoint[] breakpoints, final boolean delete) throws CoreException {
        IBreakpoint breakpoint;
        final ArrayList<IBreakpoint> remove = new ArrayList<IBreakpoint>(breakpoints.length);
        int i = 0;
        while (i < breakpoints.length) {
            breakpoint = breakpoints[i];
            if (this.getBreakpoints0().contains(breakpoint)) {
                remove.add(breakpoint);
            }
            ++i;
        }
        if (!remove.isEmpty()) {
            Iterator iter = remove.iterator();
            while (iter.hasNext()) {
                breakpoint = (IBreakpoint)iter.next();
                this.getBreakpoints0().remove(breakpoint);
                this.fMarkersToBreakpoints.remove(breakpoint.getMarker());
            }
            this.fireUpdate(remove, null, 1);
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor montitor) throws CoreException {
                    Iterator iter = remove.iterator();
                    while (iter.hasNext()) {
                        IProject project;
                        IBreakpoint breakpoint = (IBreakpoint)iter.next();
                        if (delete) {
                            breakpoint.delete();
                            continue;
                        }
                        IMarker marker = breakpoint.getMarker();
                        if (!marker.exists() || (project = breakpoint.getMarker().getResource().getProject()) != null && !project.isOpen()) continue;
                        breakpoint.setRegistered(false);
                    }
                }
            };
            this.getWorkspace().run(r, null);
        }
    }

    private IBreakpoint createBreakpoint(IMarker marker) throws DebugException {
        IBreakpoint breakpoint = (IBreakpoint)this.fMarkersToBreakpoints.get(marker);
        if (breakpoint != null) {
            return breakpoint;
        }
        try {
            IConfigurationElement config = (IConfigurationElement)this.fBreakpointExtensions.get(marker.getType());
            if (config == null) {
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5014, MessageFormat.format(DebugCoreMessages.getString("BreakpointManager.Missing_breakpoint_definition"), marker.getType()), null));
            }
            Object object = config.createExecutableExtension(CLASS);
            if (object instanceof IBreakpoint) {
                breakpoint = (IBreakpoint)object;
                breakpoint.setMarker(marker);
            } else {
                this.invalidBreakpointExtension(MessageFormat.format(DebugCoreMessages.getString("BreakpointManager.Class_{0}_specified_by_breakpoint_extension_{1}_does_not_implement_required_interface_IBreakpoint._3"), config.getAttribute(CLASS), config.getDeclaringExtension().getUniqueIdentifier()));
            }
            return breakpoint;
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public void addBreakpoint(IBreakpoint breakpoint) throws CoreException {
        this.addBreakpoints(new IBreakpoint[]{breakpoint});
    }

    public void addBreakpoints(IBreakpoint[] breakpoints) throws CoreException {
        ArrayList<IBreakpoint> added = new ArrayList<IBreakpoint>(breakpoints.length);
        final ArrayList<IBreakpoint> update = new ArrayList<IBreakpoint>();
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (!this.getBreakpoints0().contains(breakpoint)) {
                this.verifyBreakpoint(breakpoint);
                if (breakpoint.isRegistered()) {
                    added.add(breakpoint);
                    this.getBreakpoints0().add(breakpoint);
                    this.fMarkersToBreakpoints.put(breakpoint.getMarker(), breakpoint);
                } else {
                    update.add(breakpoint);
                }
            }
            ++i;
        }
        this.fireUpdate(added, null, 0);
        if (!update.isEmpty()) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Iterator iter = update.iterator();
                    while (iter.hasNext()) {
                        IBreakpoint breakpoint = (IBreakpoint)iter.next();
                        BreakpointManager.this.getBreakpoints0().add(breakpoint);
                        breakpoint.setRegistered(true);
                        BreakpointManager.this.fMarkersToBreakpoints.put(breakpoint.getMarker(), breakpoint);
                    }
                }
            };
            this.fSuppressChange.addAll(update);
            this.getWorkspace().run(r, null);
            this.fSuppressChange.removeAll(update);
            this.fireUpdate(update, null, 0);
        }
    }

    protected boolean isChangeSuppressed(IBreakpoint breakpoint) {
        return this.fSuppressChange.contains(breakpoint);
    }

    public void fireBreakpointChanged(IBreakpoint breakpoint) {
        if (this.getBreakpoints0().contains(breakpoint)) {
            ArrayList<IBreakpoint> changed = new ArrayList<IBreakpoint>();
            changed.add(breakpoint);
            this.fireUpdate(changed, null, 2);
        }
    }

    private void verifyBreakpoint(IBreakpoint breakpoint) throws DebugException {
        try {
            String id = breakpoint.getModelIdentifier();
            if (id == null) {
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5014, DebugCoreMessages.getString("BreakpointManager.Missing_model_identifier"), null));
            }
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                if (fgVisitor == null) {
                    fgVisitor = new BreakpointManagerVisitor();
                }
                delta.accept((IResourceDeltaVisitor)fgVisitor);
                fgVisitor.update();
            }
            catch (CoreException ce) {
                DebugPlugin.log(ce);
            }
        }
    }

    public void addBreakpointListener(IBreakpointListener listener) {
        this.fBreakpointListeners.add(listener);
    }

    public void removeBreakpointListener(IBreakpointListener listener) {
        this.fBreakpointListeners.remove(listener);
    }

    private void fireUpdate(List breakpoints, List deltas, int update) {
        if (breakpoints.isEmpty()) {
            return;
        }
        IBreakpoint[] bpArray = breakpoints.toArray(new IBreakpoint[breakpoints.size()]);
        IMarkerDelta[] deltaArray = new IMarkerDelta[bpArray.length];
        if (deltas != null) {
            deltaArray = deltas.toArray(deltaArray);
        }
        this.getBreakpointNotifier().notify(bpArray, deltaArray, update);
        this.getBreakpointsNotifier().notify(bpArray, deltaArray, update);
    }

    protected void setBreakpoints(Vector breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    protected void fork(final IWorkspaceRunnable wRunnable) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    BreakpointManager.this.getWorkspace().run(wRunnable, null);
                }
                catch (CoreException ce) {
                    DebugPlugin.log(ce);
                }
            }
        };
        new Thread(runnable).start();
    }

    public boolean hasBreakpoints() {
        return !this.getBreakpoints0().isEmpty();
    }

    public void addBreakpointListener(IBreakpointsListener listener) {
        this.fBreakpointsListeners.add(listener);
    }

    public void removeBreakpointListener(IBreakpointsListener listener) {
        this.fBreakpointsListeners.remove(listener);
    }

    private BreakpointNotifier getBreakpointNotifier() {
        return new BreakpointNotifier();
    }

    private BreakpointsNotifier getBreakpointsNotifier() {
        return new BreakpointsNotifier();
    }

    class BreakpointManagerVisitor
    implements IResourceDeltaVisitor {
        private List fMoved = new ArrayList();
        private List fRemoved = new ArrayList();
        private List fChanged = new ArrayList();
        private List fChangedDeltas = new ArrayList();

        BreakpointManagerVisitor() {
        }

        protected void reset() {
            this.fMoved.clear();
            this.fRemoved.clear();
            this.fChanged.clear();
            this.fChangedDeltas.clear();
        }

        public void update() {
            if (!this.fMoved.isEmpty()) {
                IWorkspaceRunnable wRunnable = new IWorkspaceRunnable(this){
                    private final /* synthetic */ BreakpointManagerVisitor this$1;
                    {
                        this.this$1 = breakpointManagerVisitor;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        BreakpointManager.access$0(BreakpointManagerVisitor.access$1(this.this$1)).deleteMarkers(BreakpointManagerVisitor.access$0(this.this$1).toArray(new IMarker[BreakpointManagerVisitor.access$0(this.this$1).size()]));
                    }
                };
                try {
                    BreakpointManager.this.getWorkspace().run(wRunnable, null);
                }
                catch (CoreException coreException) {}
            }
            if (!this.fRemoved.isEmpty()) {
                try {
                    BreakpointManager.this.removeBreakpoints(this.fRemoved.toArray(new IBreakpoint[this.fRemoved.size()]), false);
                }
                catch (CoreException e) {
                    DebugPlugin.log(e);
                }
            }
            if (!this.fChanged.isEmpty()) {
                BreakpointManager.this.fireUpdate(this.fChanged, this.fChangedDeltas, 2);
            }
            this.reset();
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            if ((delta.getFlags() & 0x4000) != 0) {
                this.handleProjectResourceOpenStateChange(delta.getResource());
                return false;
            }
            IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
            int i = 0;
            while (i < markerDeltas.length) {
                IMarkerDelta markerDelta = markerDeltas[i];
                if (markerDelta.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) {
                    switch (markerDelta.getKind()) {
                        case 1: {
                            this.handleAddBreakpoint(delta, markerDelta.getMarker(), markerDelta);
                            break;
                        }
                        case 2: {
                            this.handleRemoveBreakpoint(markerDelta.getMarker(), markerDelta);
                            break;
                        }
                        case 4: {
                            this.handleChangeBreakpoint(markerDelta.getMarker(), markerDelta);
                        }
                    }
                }
                ++i;
            }
            return true;
        }

        protected void handleAddBreakpoint(IResourceDelta rDelta, IMarker marker, IMarkerDelta mDelta) {
            if ((rDelta.getFlags() & 0x1000) != 0) {
                this.fMoved.add(marker);
            }
        }

        protected void handleRemoveBreakpoint(IMarker marker, IMarkerDelta delta) {
            IBreakpoint breakpoint = BreakpointManager.this.getBreakpoint(marker);
            if (breakpoint != null) {
                this.fRemoved.add(breakpoint);
            }
        }

        protected void handleChangeBreakpoint(IMarker marker, IMarkerDelta delta) {
            IBreakpoint breakpoint = BreakpointManager.this.getBreakpoint(marker);
            if (breakpoint != null && BreakpointManager.this.isRegistered(breakpoint) && !BreakpointManager.this.isChangeSuppressed(breakpoint)) {
                this.fChanged.add(breakpoint);
                this.fChangedDeltas.add(delta);
            }
        }

        private void handleProjectResourceOpenStateChange(IResource project) {
            if (!project.isAccessible()) {
                Enumeration breakpoints = ((Vector)BreakpointManager.this.getBreakpoints0().clone()).elements();
                while (breakpoints.hasMoreElements()) {
                    IBreakpoint breakpoint = (IBreakpoint)breakpoints.nextElement();
                    IResource markerResource = breakpoint.getMarker().getResource();
                    if (!project.getFullPath().isPrefixOf(markerResource.getFullPath())) continue;
                    this.fRemoved.add(breakpoint);
                }
                return;
            }
            try {
                BreakpointManager.this.loadBreakpoints(project);
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }

        static /* synthetic */ List access$0(BreakpointManagerVisitor breakpointManagerVisitor) {
            return breakpointManagerVisitor.fMoved;
        }

        static /* synthetic */ BreakpointManager access$1(BreakpointManagerVisitor breakpointManagerVisitor) {
            return breakpointManagerVisitor.BreakpointManager.this;
        }
    }

    class BreakpointNotifier
    implements ISafeRunnable {
        private IBreakpointListener fListener;
        private int fType;
        private IMarkerDelta fDelta;
        private IBreakpoint fBreakpoint;

        BreakpointNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("BreakpointManager.An_exception_occurred_during_breakpoint_change_notification._4"), exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.breakpointAdded(this.fBreakpoint);
                    break;
                }
                case 1: {
                    this.fListener.breakpointRemoved(this.fBreakpoint, this.fDelta);
                    break;
                }
                case 2: {
                    this.fListener.breakpointChanged(this.fBreakpoint, this.fDelta);
                }
            }
        }

        public void notify(IBreakpoint[] breakpoints, IMarkerDelta[] deltas, int update) {
            this.fType = update;
            Object[] copiedListeners = BreakpointManager.this.fBreakpointListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (IBreakpointListener)copiedListeners[i];
                int j = 0;
                while (j < breakpoints.length) {
                    this.fBreakpoint = breakpoints[j];
                    this.fDelta = deltas[j];
                    Platform.run((ISafeRunnable)this);
                    ++j;
                }
                ++i;
            }
            this.fListener = null;
            this.fDelta = null;
            this.fBreakpoint = null;
        }
    }

    class BreakpointsNotifier
    implements ISafeRunnable {
        private IBreakpointsListener fListener;
        private int fType;
        private IMarkerDelta[] fDeltas;
        private IBreakpoint[] fBreakpoints;

        BreakpointsNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("BreakpointManager.An_exception_occurred_during_breakpoint_change_notification._5"), exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.breakpointsAdded(this.fBreakpoints);
                    break;
                }
                case 1: {
                    this.fListener.breakpointsRemoved(this.fBreakpoints, this.fDeltas);
                    break;
                }
                case 2: {
                    this.fListener.breakpointsChanged(this.fBreakpoints, this.fDeltas);
                }
            }
        }

        public void notify(IBreakpoint[] breakpoints, IMarkerDelta[] deltas, int update) {
            this.fType = update;
            this.fBreakpoints = breakpoints;
            this.fDeltas = deltas;
            Object[] copiedListeners = BreakpointManager.this.fBreakpointsListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (IBreakpointsListener)copiedListeners[i];
                Platform.run((ISafeRunnable)this);
                ++i;
            }
            this.fDeltas = null;
            this.fBreakpoints = null;
            this.fListener = null;
        }
    }
}

