/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.providers.ejb;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.internal.core.ejb.providers.EjbPackageContentFactoryImpl;
import com.tssap.selena.internal.core.providers.java.resources.IPackageContentFactory;
import com.tssap.selena.internal.core.providers.java.resources.PackageContentClipboard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class EjbProvidersPlugin
extends Plugin {
    private boolean myTracing;
    private boolean myDebuggingDelta;
    private static EjbProvidersPlugin ourInstance;

    public EjbProvidersPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
        this.myDebuggingDelta = UtilsPlugin.getDeltaDebugOption((IPluginDescriptor)descriptor);
    }

    public static EjbProvidersPlugin getDefault() {
        return ourInstance;
    }

    public void startup() throws CoreException {
        super.startup();
        PackageContentClipboard.registerFactory((IPackageContentFactory)new EjbPackageContentFactoryImpl());
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public boolean isDebuggingDelta() {
        return this.myDebuggingDelta;
    }

    public static void logInfo(String text) {
        EjbProvidersPlugin instance = EjbProvidersPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        EjbProvidersPlugin.log(1, text);
    }

    public static void logError(String text) {
        EjbProvidersPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        EjbProvidersPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        EjbProvidersPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        EjbProvidersPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        EjbProvidersPlugin instance = EjbProvidersPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            EjbProvidersPlugin.log(type, text, new Throwable());
        } else {
            EjbProvidersPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        EjbProvidersPlugin instance = EjbProvidersPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }
}

