/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers.registry;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.ejb.providers.registry.BeanRegistryProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceUniqueNameEnumeration;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.extension.ReferenceExistenceProvider;
import com.tssap.selena.model.extension.ReferenceParentProvider;
import com.tssap.selena.model.extension.ReferenceProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.AbstractList;
import java.util.ArrayList;

public class BeanRegistryContentProvider
extends AbstractEJBProvider
implements ReferenceProvider,
ParentProvider,
ReferenceExistenceProvider,
ReferenceParentProvider {
    public boolean isReferenceProviderApplicable(ReferenceContainer container) {
        return "Bean Registry".equals(((Element)container).getUniqueName().getDomain());
    }

    public ReferenceUniqueNameEnumeration references(ReferenceContainer collection) {
        if (collection instanceof ReferenceCollection) {
            return this.ejbs();
        }
        Reference reference = (Reference)collection;
        ArrayList<ReferenceUniqueName> result = new ArrayList<ReferenceUniqueName>();
        Entity element = reference.getEntity();
        EntityEnumeration entityEnumeration = element.children();
        while (entityEnumeration.hasMoreElements()) {
            result.add(EjbModelMetaInfo.getReferenceUniqueNameForEJBRegistry(entityEnumeration.next().getUniqueName()));
        }
        return EnumerationConverter.toReferenceUniqueNameEnumeration(((AbstractList)result).iterator());
    }

    private ReferenceUniqueNameEnumeration ejbs() {
        ArrayList<ReferenceUniqueName> result = new ArrayList<ReferenceUniqueName>();
        try {
            IEnterpriseBean[] beans = this.getEJBProject().getEnterpriseBeans();
            int i = 0;
            while (i < beans.length) {
                ReferenceUniqueName next;
                IEnterpriseBean bean = beans[i];
                if (bean != null && !bean.isImported() && (next = this.getReferenceUniqueName(beans[i])) != null) {
                    result.add(next);
                }
                ++i;
            }
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Project doesn't seem to exist but providers are not disabled!", e);
        }
        return EnumerationConverter.toReferenceUniqueNameEnumeration(((AbstractList)result).iterator());
    }

    public ReferenceUniqueName addReference(ReferenceContainer container, Reference template, Entity entity) {
        return null;
    }

    public boolean canAddReference(ReferenceContainer container, Reference template, Entity entity) {
        return false;
    }

    public UniqueName getParentUniqueName(Element child) {
        if (this.exists(child.getUniqueName())) {
            return BeanRegistryProvider.BEAN_REGISTRY;
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        if (uniqueName instanceof ReferenceUniqueName) {
            ReferenceUniqueName refUin = (ReferenceUniqueName)uniqueName;
            UniqueName actualEntityUin = refUin.getReferencedUniqueName();
            UniqueName expectedEntityUin = this.getDereferencedUniqueName(refUin);
            if (actualEntityUin == null || expectedEntityUin == null) {
                return false;
            }
            if (!expectedEntityUin.equals(actualEntityUin)) {
                return false;
            }
            IEnterpriseBean bean = this.getBean(expectedEntityUin);
            return bean != null && !bean.isImported();
        }
        return false;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return element instanceof Reference && "Bean Registry".equals(element.getUniqueName().getDomain());
    }

    public boolean canDelete(Element element) {
        return false;
    }

    public void delete(Element element) {
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    private UniqueName getDereferencedUniqueName(ReferenceUniqueName uin) {
        return EjbModelMetaInfo.getDereferencedUniqueNameFromEJBRegistry(uin);
    }

    private ReferenceUniqueName getReferenceUniqueName(IEnterpriseBean bean) {
        return EjbModelMetaInfo.getReferenceUniqueNameForEJBRegistry((IEJBElement)bean);
    }

    public ReferenceUniqueName getReferenceContainerUniqueName(Reference reference) {
        Entity referencedEntity = reference.getEntity();
        UniqueName referencedUin = referencedEntity.getUniqueName();
        if (EjbModelMetaInfo.isEjb(referencedUin)) {
            return null;
        }
        if (EjbModelMetaInfo.isEjbMethod(referencedUin)) {
            IEJBMethod method = this.getEJBMethod(referencedUin);
            if (method == null) {
                return null;
            }
            return EjbModelMetaInfo.getReferenceUniqueNameForEJBRegistry(method.getParent());
        }
        if (EjbModelMetaInfo.isEjbField(referencedUin)) {
            IPersistentField field = this.getEJBField(referencedUin);
            if (field == null) {
                return null;
            }
            return EjbModelMetaInfo.getReferenceUniqueNameForEJBRegistry(field.getParent());
        }
        return null;
    }
}

