/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyReader;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.PropertyAdapter;
import java.util.AbstractList;
import java.util.ArrayList;
import org.eclipse.jdt.core.IType;

public class ResourcesPropertyProvider
extends AbstractPropertyReader {
    private static final String RESOURCES_PROPERTY = "$resources";

    public ResourcesPropertyProvider() {
        this.addPropertyName(RESOURCES_PROPERTY);
    }

    public String getPropertyValue(Element element, String propertyName) {
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (bean == null) {
            return null;
        }
        IType beanClass = bean.getBeanClass();
        return this.getResource(beanClass);
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        ArrayList<PropertyAdapter> result = new ArrayList<PropertyAdapter>();
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (bean != null) {
            String toAdd = this.getResource(bean.getBeanClass());
            if (toAdd != null) {
                result.add(new PropertyAdapter(propertyName, toAdd, element));
            }
            if (bean instanceof IAccessibleBean) {
                IAccessibleBean acc = (IAccessibleBean)bean;
                int i = 1;
                int iMax = acc.getExistingRoles();
                while (i <= iMax) {
                    try {
                        IType type = acc.getParticipant(i);
                        toAdd = this.getResource(type);
                        if (toAdd != null) {
                            result.add(new PropertyAdapter(propertyName, toAdd, element));
                        }
                    }
                    catch (EJBModelException e) {
                        // empty catch block
                    }
                    i <<= 1;
                }
            }
        }
        return EnumerationConverter.toPropertyEnumeration(((AbstractList)result).iterator());
    }

    private String getResource(IType type) {
        if (type == null || type.isBinary()) {
            return null;
        }
        return type.getCompilationUnit().getResource().getProjectRelativePath().toString();
    }
}

