/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.SingleEnumeration;
import java.util.AbstractList;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class RelationLinkProvider
extends AbstractEJBProvider
implements LinkProvider {
    private static final String SOURCE = "Client";
    private static final String TARGET = "Supplier";

    public boolean isLinkProviderApplicable(Entity link) {
        return true;
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        IRelationshipEnd relation = this.getRelation(link.getUniqueName());
        UniqueName result = null;
        if (relation != null) {
            if (SOURCE.equals(role)) {
                result = this.getUniqueName((IEJBElement)relation.getRoleSource());
            } else if (TARGET.equals(role)) {
                result = this.getUniqueName((IEJBElement)relation.getRelationshipTarget());
            }
        }
        if (result == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        return SingleEnumeration.createUniqueNameEnumeration(result);
    }

    public StringEnumeration participantRoles(Entity link) {
        IRelationshipEnd relation = this.getRelation(link.getUniqueName());
        ArrayList<String> result = new ArrayList<String>();
        if (relation != null) {
            IEntityBean target;
            IEntityBean source = relation.getRoleSource();
            if (source != null) {
                result.add(SOURCE);
            }
            if ((target = relation.getRelationshipTarget()) != null) {
                result.add(TARGET);
            }
        }
        return EnumerationConverter.toStringEnumeration(((AbstractList)result).iterator());
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        IRelationshipEnd relation = this.getRelation(link.getUniqueName());
        IEntityBean newTarget = this.getCMPBean(newParticipant);
        try {
            relation.setRelationshipTarget(newTarget, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logError("Could not set relationship target", e);
        }
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        if (!TARGET.equals(role)) {
            return false;
        }
        IRelationshipEnd relation = this.getRelation(link.getUniqueName());
        if (relation == null) {
            return false;
        }
        if (newParticipant == null) {
            return false;
        }
        IEntityBean newTarget = this.getCMPBean(newParticipant);
        if (newTarget == null) {
            return false;
        }
        try {
            if (newTarget.getParticipant(16) == null) {
                return false;
            }
        }
        catch (EJBModelException eme) {
            return false;
        }
        return true;
    }

    private IEntityBean getCMPBean(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        if (!EjbModelMetaInfo.isEntityBean(uniqueName)) {
            return null;
        }
        IEnterpriseBean bean = this.getBean(uniqueName);
        if (bean instanceof IEntityBean) {
            IEntityBean candidate = (IEntityBean)bean;
            try {
                if (candidate.isCMP()) {
                    return candidate;
                }
                return null;
            }
            catch (EJBModelException e) {
                return null;
            }
        }
        return null;
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }
}

