/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyWriter;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class RelationCardinalityPropertyWriter
extends AbstractPropertyWriter {
    private static final IntHashMap CARDINALITY_MAP = new IntHashMap();

    public RelationCardinalityPropertyWriter() {
        this.addPropertyName("$cardinality");
    }

    public String getPropertyValue(Element element, String propertyName) {
        IRelationshipEnd relation = this.getRelation(element.getUniqueName());
        if (relation == null) {
            return null;
        }
        int cardinality = relation.getCardinality();
        return (String)CARDINALITY_MAP.get(cardinality);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        try {
            CARDINALITY_MAP.find((Object)propertyValue);
        }
        catch (NoSuchElementException e) {
            return false;
        }
        if (element.hasProperty("$readOnly")) {
            return propertyValue.equals(this.getPropertyValue(element, propertyName));
        }
        IRelationshipEnd relation = this.getRelation(element.getUniqueName());
        return relation != null;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        IRelationshipEnd relation = this.getRelation(element.getUniqueName());
        int cardinality = CARDINALITY_MAP.find((Object)propertyValue);
        try {
            relation.setCardinality(cardinality, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logError("Could not set cardinality", e);
        }
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    static {
        CARDINALITY_MAP.put(0, (Object)"One");
        CARDINALITY_MAP.put(1, (Object)"Collection");
        CARDINALITY_MAP.put(2, (Object)"Set");
    }
}

