/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.core.ejb.ISessionBean;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyReader;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public class ReadOnlyPropertyProvider
extends AbstractPropertyReader {
    public ReadOnlyPropertyProvider() {
        this.addPropertyName("$readOnly");
        this.addPropertyName("$ro-name");
        this.addPropertyName("$special");
    }

    public String getPropertyValue(Element element, String propertyName) {
        IEJBMethod method;
        UniqueName uniqueName = element.getUniqueName();
        boolean result = "$readOnly".equals(propertyName) ? this.isReadOnly(uniqueName) : ("$special".equals(propertyName) ? (EjbModelMetaInfo.isEjbMethod(uniqueName) ? ReadOnlyPropertyProvider.isSpecialMethod(this.getEJBMethod(uniqueName)) : false) : ("$ro-name".equals(propertyName) ? ((method = this.getEJBMethod(uniqueName)) == null ? false : ReadOnlyPropertyProvider.isReadOnlyName(method)) : false));
        return AbstractPropertyReader.getPropertyRepresentation(result);
    }

    private boolean isReadOnly(UniqueName uniqueName) {
        boolean isReadOnly;
        if (EjbModelMetaInfo.isEjb(uniqueName)) {
            isReadOnly = ReadOnlyPropertyProvider.isReadOnly(this.getBean(uniqueName));
        } else if (EjbModelMetaInfo.isEjbMethod(uniqueName)) {
            isReadOnly = ReadOnlyPropertyProvider.isReadOnly(this.getEJBMethod(uniqueName));
        } else if (EjbModelMetaInfo.isEjbField(uniqueName)) {
            isReadOnly = ReadOnlyPropertyProvider.isReadOnly(this.getEJBField(uniqueName));
        } else if (EjbModelMetaInfo.isRelationLink(uniqueName)) {
            isReadOnly = ReadOnlyPropertyProvider.isReadOnly(this.getRelation(uniqueName));
        } else {
            return false;
        }
        return isReadOnly;
    }

    public static boolean isReadOnly(IEnterpriseBean bean) {
        if (bean == null) {
            return false;
        }
        if (bean.getBeanClass() == null) {
            return false;
        }
        if (bean.getBeanClass().isBinary()) {
            return true;
        }
        if (bean instanceof IAccessibleBean) {
            IAccessibleBean accBean = (IAccessibleBean)bean;
            int i = 1;
            int existingParticipants = accBean.getExistingRoles();
            while (i <= existingParticipants) {
                if ((i & existingParticipants) > 0) {
                    try {
                        IType participant;
                        if (i != 32 && (participant = accBean.getParticipant(i)) != null && participant.isBinary()) {
                            return true;
                        }
                    }
                    catch (EJBModelException cannotHappen) {
                        cannotHappen.printStackTrace();
                    }
                }
                i <<= 1;
            }
        }
        return false;
    }

    public static boolean isReadOnly(IEJBMethod method) {
        if (method == null) {
            return false;
        }
        int i = 1;
        int existing = method.getExistingMethods();
        while (i <= existing) {
            if ((i & existing) > 0) {
                try {
                    if (method.getMethod(i).isBinary()) {
                        return true;
                    }
                }
                catch (EJBModelException canNotHappen) {
                    canNotHappen.printStackTrace();
                }
            }
            i <<= 1;
        }
        return false;
    }

    public static boolean isReadOnly(IRelationshipEnd relation) {
        if (relation == null) {
            return false;
        }
        IPersistentField cmrField = relation.getCMRField();
        if (cmrField == null) {
            return false;
        }
        return ReadOnlyPropertyProvider.isReadOnly(cmrField);
    }

    public static boolean isReadOnly(IPersistentField field) {
        if (field == null) {
            return false;
        }
        IEntityBean bean = (IEntityBean)field.getParent();
        IField javaField = field.getField();
        if (javaField != null && javaField.exists() && javaField.isBinary()) {
            return true;
        }
        try {
            IEJBMethod ejbSetter;
            IEJBMethod ejbGetter;
            IMethod getter = field.getGetter();
            if (getter != null && (ejbGetter = bean.getEJBMethodByJavaTypes(getter.getElementName(), ArrayUtils.EMPTY_STRING_ARRAY)) != null && ReadOnlyPropertyProvider.isReadOnly(ejbGetter)) {
                return true;
            }
            IMethod setter = field.getSetter();
            String fieldType = JDTUtils.getFQN((IType)bean.getBeanClass(), (String)field.getType());
            if (setter != null && (ejbSetter = bean.getEJBMethodByJavaTypes(setter.getElementName(), new String[]{fieldType})) != null && ReadOnlyPropertyProvider.isReadOnly(ejbSetter)) {
                return true;
            }
        }
        catch (EJBModelException canNotHappen) {
            canNotHappen.printStackTrace();
        }
        return false;
    }

    public static boolean isSpecialMethod(IEJBMethod method) {
        IEnterpriseBean parent = (IEnterpriseBean)method.getParent();
        switch (parent.getKind()) {
            case 4: {
                return true;
            }
            case 2: {
                return method.getKind() == 2 && !((ISessionBean)parent).isStateful();
            }
            case 1: {
                String name;
                return method.getKind() == 4 && "ejbFindByPrimaryKey".equals(name = method.getName());
            }
        }
        return false;
    }

    public static boolean isReadOnlyName(IEJBMethod method) {
        if (method == null) {
            return true;
        }
        IEnterpriseBean parent = (IEnterpriseBean)method.getParent();
        switch (parent.getKind()) {
            case 4: {
                return false;
            }
            case 2: {
                return false;
            }
            case 1: {
                if (method.getKind() == 1) {
                    try {
                        if (((IEntityBean)parent).isCMP()) {
                            return JDTUtils.isAccessor((IMethod)ReadOnlyPropertyProvider.getExistingMethod(method));
                        }
                    }
                    catch (EJBModelException e) {
                        return true;
                    }
                    String name = method.getName();
                    if ("ejbFindByPrimaryKey".equals(name)) {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static IMethod getExistingMethod(IEJBMethod ejbMethod) throws EJBModelException {
        int i = 1;
        int iMax = ejbMethod.getExistingMethods();
        while (i <= iMax) {
            if ((i & iMax) > 0) {
                return ejbMethod.getMethod(i);
            }
            i <<= 1;
        }
        return null;
    }
}

