/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IQueryMethod;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyWriter;
import com.tssap.j2ee.internal.core.ejb.providers.ReadOnlyPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jdt.core.IType;

public class QueryMethodReturnTypeProvider
extends AbstractPropertyWriter {
    private static final HashSet ALLOWED_VALUES = new HashSet<String>(Arrays.asList("java.util.Collection", "java.util.Enumeration", "$single"));

    public String getPropertyValue(Element element, String propertyName) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        return this.getPropertyValue(method);
    }

    private String getPropertyValue(IEJBMethod method) {
        if (method instanceof IQueryMethod) {
            IQueryMethod query = (IQueryMethod)method;
            try {
                String returnType = query.getReturnType();
                if (returnType == null) {
                    return null;
                }
                if ("java.util.Collection".equals(returnType)) {
                    return "java.util.Collection";
                }
                if ("java.util.Enumeration".equals(returnType)) {
                    return "java.util.Enumeration";
                }
                IType type = this.getPKClass(query);
                if (type != null) {
                    String pkType = type.getElementName();
                    String pkFQN = type.getFullyQualifiedName();
                    if (returnType.equals(pkType) || returnType.equals(pkFQN)) {
                        return "$single";
                    }
                }
            }
            catch (EJBModelException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private IType getPKClass(IQueryMethod method) throws EJBModelException {
        IEntityBean bean = (IEntityBean)method.getParent();
        if (bean == null) {
            return null;
        }
        return bean.getParticipant(32);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (!(method instanceof IQueryMethod)) {
            return false;
        }
        if (ReadOnlyPropertyProvider.isReadOnly(method) || ReadOnlyPropertyProvider.isSpecialMethod(method)) {
            return propertyValue != null && propertyValue.equals(this.getPropertyValue(method));
        }
        return ALLOWED_VALUES.contains(propertyValue);
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        IQueryMethod method = (IQueryMethod)this.getEJBMethod(element.getUniqueName());
        if (ReadOnlyPropertyProvider.isReadOnly((IEJBMethod)method) || ReadOnlyPropertyProvider.isSpecialMethod((IEJBMethod)method)) {
            return;
        }
        try {
            if ("$single".equals(propertyValue)) {
                IType pk = this.getPKClass(method);
                if (pk == null) {
                    return;
                }
                method.setReturnType(pk.getFullyQualifiedName(), null);
            } else {
                method.setReturnType(propertyValue, null);
            }
        }
        catch (EJBModelException e) {
            e.printStackTrace();
        }
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }
}

