/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.core.utils.RuntimeSupport;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.ejb.providers.ReadOnlyPropertyProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PersistentFieldExistenceProvider
extends AbstractEJBProvider
implements EntityExistenceProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!"com.tssap.j2ee.core.ejb.field.Persistent".equals(shapeType)) {
            return false;
        }
        if (!EjbModelMetaInfo.isEntityBean(parent.getUniqueName())) {
            return false;
        }
        IEnterpriseBean bean = this.getBean(parent.getUniqueName());
        if (!(bean instanceof IEntityBean) || bean.getBeanClass().isBinary()) {
            return false;
        }
        try {
            if (!((IEntityBean)bean).isCMP()) {
                return false;
            }
        }
        catch (EJBModelException e1) {
            return false;
        }
        if (template == null) {
            return true;
        }
        String name = template.getPropertyValue("$name");
        if (name == null) {
            return true;
        }
        if (name.length() == 0 || Character.isUpperCase(name.charAt(0))) {
            return false;
        }
        if ("primaryKey".equals(name)) {
            return false;
        }
        if (!JavaConventions.validateMethodName((String)name).isOK()) {
            return false;
        }
        try {
            if (((IEntityBean)bean).getField(name) != null) {
                return false;
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        return true;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        IEnterpriseBean bean = this.getBean(parent.getUniqueName());
        if (!(bean instanceof IEntityBean)) {
            return null;
        }
        final IEntityBean ejb = (IEntityBean)bean;
        final IPersistentField[] resultHolder = new IPersistentField[1];
        String name = null;
        String type = null;
        if (template != null) {
            name = template.getPropertyValue("$name");
            type = template.getPropertyValue("$type");
        }
        if (name == null) {
            String namePrefix = template == null ? null : template.getPropertyValue("$namePrefix");
            name = this.findUnusedName(parent, namePrefix);
        }
        if (type == null) {
            type = "int";
        }
        final String fieldName = name;
        final String fieldType = type;
        final boolean inPK = template == null ? false : template.hasProperty("inPK");
        try {
            RuntimeSupport.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        resultHolder[0] = ejb.createPersistentField(fieldName, fieldType, inPK, monitor);
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
            });
        }
        catch (CoreException ce) {
            System.err.println("Unable to create field of enterprise bean: " + (Object)((Object)ce));
            ce.printStackTrace();
            return null;
        }
        return this.getUniqueName((IEJBElement)resultHolder[0]);
    }

    private String findUnusedName(Entity parent, String baseName) {
        if (baseName == null || baseName.length() == 0) {
            baseName = "field";
        }
        HashSet<String> fieldNames = new HashSet<String>();
        EntityEnumeration entityEnumeration = parent.childEntities();
        while (entityEnumeration.hasMoreElements()) {
            Entity next = entityEnumeration.next();
            if (!"com.tssap.j2ee.core.ejb.field.Persistent".equals(next.getPropertyValue("$metaclass"))) continue;
            fieldNames.add(next.getPropertyValue("$name"));
        }
        String result = baseName;
        int i = 1;
        while (fieldNames.contains(result)) {
            result = baseName + ++i;
        }
        return result;
    }

    public boolean exists(UniqueName uniqueName) {
        IPersistentField field = this.getEJBField(uniqueName);
        return field != null;
    }

    public boolean canDelete(Element element) {
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if (field == null) {
            return false;
        }
        return !ReadOnlyPropertyProvider.isReadOnly(field);
    }

    public void delete(Element element) {
        IPersistentField field = this.getEJBField(element.getUniqueName());
        try {
            field.delete(null);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to delete persistent field", e);
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return element.getUniqueName().getDomain().equals("com.tssap.j2ee.core.ejb.field");
    }
}

