/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyReader;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyWriter;
import com.tssap.j2ee.internal.core.ejb.providers.ReadOnlyPropertyProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IMethod;

public class PersistentFieldAccessorsPropertyProvider
extends AbstractPropertyWriter {
    public PersistentFieldAccessorsPropertyProvider() {
        this.addPropertyName("getter");
        this.addPropertyName("setter");
        this.addPropertyName("missingAccessor");
    }

    public String getPropertyValue(Element element, String propertyName) {
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if (field == null) {
            return null;
        }
        if ("getter".equals(propertyName)) {
            return this.getPropertyReprepentation(field.getGetter());
        }
        if ("setter".equals(propertyName)) {
            return this.getPropertyReprepentation(field.getSetter());
        }
        if ("missingAccessor".equals(propertyName)) {
            boolean hasBoth = this.getBooleanRepresentation(field.getGetter()) && this.getBooleanRepresentation(field.getSetter());
            return AbstractPropertyReader.getPropertyRepresentation(!hasBoth);
        }
        return null;
    }

    private String getPropertyReprepentation(IMethod accessor) {
        return AbstractPropertyReader.getPropertyRepresentation(this.getBooleanRepresentation(accessor));
    }

    private boolean getBooleanRepresentation(IMethod accessor) {
        return accessor != null && accessor.exists();
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if (field == null) {
            return false;
        }
        if (ReadOnlyPropertyProvider.isReadOnly(field) || ReadOnlyPropertyProvider.isReadOnly((IEnterpriseBean)((IEntityBean)field.getParent()))) {
            String actualValue = this.getPropertyValue(element, propertyName);
            return actualValue == propertyValue || actualValue != null && actualValue.equals(propertyValue);
        }
        return true;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        String[] parameterTypes;
        IMethod accessor;
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if ("getter".equals(propertyName)) {
            accessor = field.getGetter();
            parameterTypes = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            accessor = field.getSetter();
            parameterTypes = new String[]{field.getType()};
        }
        IEntityBean bean = (IEntityBean)field.getParent();
        try {
            IEJBMethod ejbMethod = bean.getEJBMethodByJavaTypes(accessor.getElementName(), parameterTypes);
            if (propertyValue == null) {
                if (ejbMethod != null) {
                    ejbMethod.delete((IProgressMonitor)new NullProgressMonitor());
                }
            } else if (ejbMethod == null) {
                if ("getter".equals(propertyName)) {
                    field.createGetter((IProgressMonitor)new NullProgressMonitor());
                } else {
                    field.createSetter((IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logError("Exception occurred while setting property value", e);
        }
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return this.getPropertyValue(element, propertyName) == null && AbstractPropertyReader.TRUE.equals(propertyValue) && this.canSetPropertyValue(element, propertyName, propertyValue);
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        this.setPropertyValue(element, propertyName, propertyValue);
        return this.getProperty(element, propertyName);
    }
}

