/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyReader;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyWriter;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import java.util.Arrays;
import java.util.Collection;

public class InPrimaryKeyPropertyProvider
extends AbstractPropertyWriter {
    private static final Collection PROPERTY_VALUES = Arrays.asList(null, AbstractPropertyReader.TRUE);

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return EjbModelMetaInfo.isEjbField(element.getUniqueName()) && "inPK".equals(propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if (field == null) {
            return null;
        }
        return AbstractPropertyReader.getPropertyRepresentation(field.isInPrimaryKey());
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (!PROPERTY_VALUES.contains(propertyValue)) {
            return false;
        }
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if (field != null) {
            return field.canSetInPrimaryKey(AbstractPropertyReader.TRUE.equals(propertyValue));
        }
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if (field != null) {
            try {
                field.setInPrimaryKey(AbstractPropertyReader.TRUE.equals(propertyValue));
            }
            catch (EJBModelException e) {
                EjbProvidersPlugin.logError("Could not set property in primary key", e);
            }
        }
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return !this.hasProperty(element, propertyName) && propertyValue.equals(AbstractPropertyReader.TRUE);
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        this.setPropertyValue(element, propertyName, propertyValue);
        return this.getProperty(element, propertyName);
    }
}

