/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.ICopiedEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.internal.core.providers.java.resources.IPackageContent;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IPackageFragment;

public class EjbPackageFragmentContent
extends AbstractEJBProvider
implements IPackageContent {
    private List myCopiedEjbs;
    private boolean myWasCut;
    private List myOldEjbUins;
    private UniqueName myOriginalPackageUin;

    public EjbPackageFragmentContent(IPackageFragment original, boolean updateExternalUsages) {
        Entity pack = this.getPackageEntity(original);
        this.registered(pack.getModel());
        this.myOriginalPackageUin = pack.getUniqueName();
        this.myCopiedEjbs = new ArrayList(3);
        this.myOldEjbUins = new ArrayList(3);
        this.myWasCut = updateExternalUsages;
        EntityEnumeration children = pack.childEntities();
        while (children.hasMoreElements()) {
            Entity child = children.next();
            UniqueName nextUin = child.getUniqueName();
            IEnterpriseBean ejb = this.getBean(nextUin);
            if (ejb == null) continue;
            this.myOldEjbUins.add(nextUin);
            this.myCopiedEjbs.add(this.getCopy(ejb));
        }
    }

    public boolean canPaste(IPackageFragment newPackageFragment) {
        return newPackageFragment != null && !newPackageFragment.isReadOnly() && newPackageFragment.exists();
    }

    public void paste(IPackageFragment newPackageFragment, Map collectedSubstitutionMap) {
        int i = 0;
        while (i < this.myCopiedEjbs.size()) {
            ICopiedEnterpriseBean copy = (ICopiedEnterpriseBean)this.myCopiedEjbs.get(i);
            UniqueName oldUin = (UniqueName)this.myOldEjbUins.get(i);
            IEnterpriseBean pastedElement = this.getPaste(copy, newPackageFragment);
            if (this.myWasCut && pastedElement != null) {
                collectedSubstitutionMap.put(oldUin, this.getModel().findElement(EjbModelMetaInfo.getUniqueName(pastedElement)));
            }
            ++i;
        }
    }

    private ICopiedEnterpriseBean getCopy(IEnterpriseBean element) {
        try {
            if (this.myWasCut) {
                if (element.canCut(true)) {
                    return element.cut(true);
                }
            } else if (element.canCopy(true)) {
                return element.copy(true);
            }
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to copy EJB", e);
        }
        return null;
    }

    private IEnterpriseBean getPaste(ICopiedEnterpriseBean copy, IPackageFragment pf) {
        try {
            return copy.paste(pf);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to paste an EJB copy", e);
            return null;
        }
    }

    private Entity getPackageEntity(IPackageFragment packageFragment) {
        UniqueName packageUin = NameUtil.getPackageUniqueName((IPackageFragment)packageFragment);
        UniqueName modelUin = ModelUinSupport.createModelUin((IResource)packageFragment.getJavaProject().getProject());
        Model model = ModelAccess.getModel((UniqueName)modelUin);
        return model.findEntity(packageUin);
    }
}

