/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IProject;

public class EjbModelAccess {
    private EjbModelAccess() {
    }

    public static EjbProject getEjbProject(Model model) {
        if (model == null || model.isDeleted()) {
            return null;
        }
        IProject project = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
        if (project == null || !project.isAccessible()) {
            return null;
        }
        return EjbProject.getInstance((IProject)project);
    }

    public static IEnterpriseBean getEjb(Model model, UniqueName uin) {
        if (uin.getParametersCount() != 0) {
            return null;
        }
        String beanClassFQN = EjbModelAccess.getFqn(uin.getLocation(), uin.getName());
        try {
            EjbProject ejbProject = EjbModelAccess.getEjbProject(model);
            if (ejbProject == null) {
                return null;
            }
            IEnterpriseBean result = ejbProject.getEnterpriseBean(beanClassFQN);
            if (result == null) {
                return null;
            }
            int kind = EjbModelMetaInfo.getKindForMetaclass(uin.getSubDomain());
            if (result.getKind() == kind) {
                return result;
            }
            return null;
        }
        catch (EJBModelException eJBModelException) {
            return null;
        }
    }

    public static IEJBMethod getEjbMethod(Model model, UniqueName uniqueName) {
        if (!"com.tssap.j2ee.core.ejb.method".equals(uniqueName.getDomain())) {
            return null;
        }
        try {
            EjbProject ejbProject = EjbModelAccess.getEjbProject(model);
            if (ejbProject == null) {
                return null;
            }
            IEnterpriseBean bean = ejbProject.getEnterpriseBean(uniqueName.getLocation());
            if (bean == null) {
                return null;
            }
            String name = uniqueName.getName();
            String[] parameters = EjbModelAccess.getParameters(uniqueName);
            IEJBMethod method = bean.getEJBMethodByJavaTypes(name, parameters);
            return method;
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public static IPersistentField getEjbField(Model model, UniqueName uin) {
        try {
            EjbProject ejbProject = EjbModelAccess.getEjbProject(model);
            if (ejbProject == null) {
                return null;
            }
            IEnterpriseBean bean = ejbProject.getEnterpriseBean(uin.getLocation());
            if (!(bean instanceof IEntityBean)) {
                return null;
            }
            String name = uin.getName();
            IPersistentField field = ((IEntityBean)bean).getField(name);
            if (field != null) {
                return field;
            }
        }
        catch (EJBModelException eJBModelException) {
            // empty catch block
        }
        return null;
    }

    private static String[] getParameters(UniqueName uin) {
        return EjbModelMetaInfo.getParameters(uin);
    }

    private static String getFqn(String packageName, String className) {
        if (packageName.length() == 0) {
            return className;
        }
        return packageName + '.' + className;
    }
}

