/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.SingleEnumeration;
import java.util.AbstractList;
import java.util.ArrayList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;

public class EJBToTypeLinkProvider
extends AbstractEJBProvider
implements LinkProvider {
    public boolean isLinkProviderApplicable(Entity link) {
        return true;
    }

    public StringEnumeration participantRoles(Entity link) {
        IEnterpriseBean bean = this.getBean(link.getUniqueName());
        if (!(bean instanceof IAccessibleBean)) {
            return SingleEnumeration.createStringEnumeration((String)"Bean Class");
        }
        IAccessibleBean accBean = (IAccessibleBean)bean;
        ArrayList<String> result = new ArrayList<String>();
        int roles = accBean.getExistingRoles();
        if ((roles & 1) > 0) {
            result.add("Bean Class");
        }
        if ((roles & 2) > 0) {
            result.add("Home Interface");
        }
        if ((roles & 4) > 0) {
            result.add("Remote Interface");
        }
        if ((roles & 8) > 0) {
            result.add("Local Home Interface");
        }
        if ((roles & 0x10) > 0) {
            result.add("Local Interface");
        }
        if ((roles & 0x20) > 0) {
            result.add("Primary Key Class");
        }
        return EnumerationConverter.toStringEnumeration(((AbstractList)result).iterator());
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        try {
            int intRole = EjbModelMetaInfo.getIntRole(role);
            if (intRole == 0) {
                return EmptyEnumeration.getUniqueNameEnumeration();
            }
            IEnterpriseBean bean = this.getBean(link.getUniqueName());
            if (bean == null) {
                return EmptyEnumeration.getUniqueNameEnumeration();
            }
            if (!(bean instanceof IAccessibleBean)) {
                if ("Bean Class".equals(role)) {
                    IType type = bean.getBeanClass();
                    if (type == null || !type.exists()) {
                        return EmptyEnumeration.getUniqueNameEnumeration();
                    }
                    UniqueName linkUin = NameUtil.getJavaElementUniqueName((IJavaProject)this.getJavaProject(), (IJavaElement)type);
                    Element element = this.getModel().findElement(linkUin);
                    if (element == null) {
                        return EmptyEnumeration.getUniqueNameEnumeration();
                    }
                    return SingleEnumeration.createUniqueNameEnumeration((UniqueName)element.getUniqueName());
                }
                return EmptyEnumeration.getUniqueNameEnumeration();
            }
            IAccessibleBean accBean = (IAccessibleBean)bean;
            IType type = accBean.getParticipant(intRole);
            if (type == null || !type.exists()) {
                return EmptyEnumeration.getUniqueNameEnumeration();
            }
            UniqueName linkUin = NameUtil.getJavaElementUniqueName((IJavaProject)this.getJavaProject(), (IJavaElement)type);
            Element element = this.getModel().findElement(linkUin);
            if (element == null) {
                return EmptyEnumeration.getUniqueNameEnumeration();
            }
            return SingleEnumeration.createUniqueNameEnumeration((UniqueName)element.getUniqueName());
        }
        catch (EJBModelException e) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        int intRole = EjbModelMetaInfo.getIntRole(role);
        if (intRole == 0 || intRole == 1) {
            return false;
        }
        if (!newParticipant.hasPropertyValue("$metaclass", "Class")) {
            return false;
        }
        String fqn = newParticipant.getPropertyValue("$fullName");
        if (fqn == null) {
            return false;
        }
        IEnterpriseBean bean = this.getBean(link.getUniqueName());
        if (!(bean instanceof IAccessibleBean)) {
            return false;
        }
        IAccessibleBean accBean = (IAccessibleBean)bean;
        return accBean.canAddParticipant(intRole, fqn);
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        int intRole = EjbModelMetaInfo.getIntRole(role);
        String fqn = newParticipant.getPropertyValue("$fullName");
        IEnterpriseBean bean = this.getBean(link.getUniqueName());
        if (bean instanceof IAccessibleBean) {
            IAccessibleBean accBean = (IAccessibleBean)bean;
            try {
                accBean.addParticipant(intRole, fqn, true, null, null);
            }
            catch (EJBModelException e) {
                EjbProvidersPlugin.logWarning("Failed to set participant", e);
            }
        }
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }
}

