/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaConventions;

public class EJBRelationProvider
extends AbstractEJBProvider
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    private static final IntHashMap CARDINALITY_MAP = new IntHashMap();

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!"com.tssap.j2ee.core.ejb.field.Relation".equals(shapeType)) {
            return false;
        }
        if (!EjbModelMetaInfo.isEntityBean(parent.getUniqueName())) {
            return false;
        }
        if (parent.hasProperty("$readOnly")) {
            return false;
        }
        if (template == null) {
            return false;
        }
        IEnterpriseBean sourceBean = this.getBean(parent.getUniqueName());
        if (!(sourceBean instanceof IEntityBean)) {
            return false;
        }
        IEntityBean source = (IEntityBean)sourceBean;
        try {
            if (!source.isCMP()) {
                return false;
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        if (source.getBeanClass().isBinary()) {
            return false;
        }
        ElementEnumeration clients = template.participants("Client");
        if (!clients.hasMoreElements()) {
            return true;
        }
        Element client = clients.next();
        if (client == null) {
            return false;
        }
        if (!EjbModelMetaInfo.isEntityBean(client.getUniqueName())) {
            return false;
        }
        IEnterpriseBean targetBean = this.getBean(client.getUniqueName());
        if (!(targetBean instanceof IEntityBean)) {
            return false;
        }
        IEntityBean target = (IEntityBean)targetBean;
        try {
            if (!target.isCMP()) {
                return false;
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        String fieldName = template.getPropertyValue("$name");
        if (fieldName == null) {
            return true;
        }
        if (!JavaConventions.validateFieldName((String)fieldName).isOK()) {
            return false;
        }
        try {
            if (source.getField(fieldName) != null) {
                return false;
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        return EJBRelationProvider.getCardinality(template.getPropertyValue("$cardinality")) != -1;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        IEntityBean source = (IEntityBean)this.getBean(parent.getUniqueName());
        ElementEnumeration clients = template.participants("Client");
        if (!clients.hasMoreElements()) {
            return null;
        }
        Element client = clients.next();
        IEntityBean target = (IEntityBean)this.getBean(client.getUniqueName());
        String fieldName = this.getFieldName(source, template.getPropertyValue("$name"));
        int cardinality = EJBRelationProvider.getCardinality(template.getPropertyValue("$cardinality"));
        try {
            IRelationshipEnd relation = source.createRelationship(fieldName, target, cardinality, (IProgressMonitor)new NullProgressMonitor());
            return EjbModelMetaInfo.getRelationLinkUniqueName(relation);
        }
        catch (EJBModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getFieldName(IEntityBean parent, String proposal) {
        if (proposal == null) {
            proposal = "relation";
        }
        try {
            if (parent.getField(proposal) == null) {
                return proposal;
            }
        }
        catch (EJBModelException e) {
            // empty catch block
        }
        int i = 1;
        while (i != 0) {
            String result = proposal + i;
            try {
                if (parent.getField(result) == null) {
                    return result;
                }
            }
            catch (EJBModelException e) {
                // empty catch block
            }
            ++i;
        }
        throw new IllegalStateException("Too many fields have been created");
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        IEnterpriseBean bean = this.getBean(parent.getUniqueName());
        try {
            return bean instanceof IEntityBean && ((IEntityBean)bean).isCMP();
        }
        catch (EJBModelException e) {
            return false;
        }
    }

    public UniqueNameEnumeration children(Entity parent) {
        IEntityBean bean = (IEntityBean)this.getBean(parent.getUniqueName());
        ArrayList<UniqueName> result = new ArrayList<UniqueName>();
        try {
            IRelationshipEnd[] relations = bean.getRelationships();
            int i = 0;
            while (i < relations.length) {
                result.add(EjbModelMetaInfo.getRelationLinkUniqueName(relations[i]));
                ++i;
            }
        }
        catch (EJBModelException e) {
            e.printStackTrace();
        }
        return EnumerationConverter.toUniqueNameEnumeration(((AbstractList)result).iterator());
    }

    public UniqueName getParentUniqueName(Element child) {
        IRelationshipEnd relation = this.getRelation(child.getUniqueName());
        if (relation == null) {
            return null;
        }
        return this.getUniqueName((IEJBElement)relation.getRoleSource());
    }

    public boolean exists(UniqueName uniqueName) {
        IRelationshipEnd relation = this.getRelation(uniqueName);
        return relation != null;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return EjbModelMetaInfo.isRelationLink(element.getUniqueName());
    }

    public boolean canDelete(Element element) {
        IRelationshipEnd relation = this.getRelation(element.getUniqueName());
        return relation != null;
    }

    public void delete(Element element) {
        IRelationshipEnd relation = this.getRelation(element.getUniqueName());
        try {
            relation.delete((IProgressMonitor)new NullProgressMonitor());
        }
        catch (EJBModelException e) {
            e.printStackTrace();
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    private static int getCardinality(String cardinalityProperty) {
        if (cardinalityProperty == null) {
            return 0;
        }
        try {
            return CARDINALITY_MAP.find((Object)cardinalityProperty);
        }
        catch (NoSuchElementException e) {
            return -1;
        }
    }

    static {
        CARDINALITY_MAP.put(0, (Object)"One");
        CARDINALITY_MAP.put(1, (Object)"Collection");
        CARDINALITY_MAP.put(2, (Object)"Set");
    }
}

