/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractMethodNameHelper;
import com.tssap.j2ee.internal.core.ejb.providers.ReadOnlyPropertyProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.PropertyUniqueNameProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.Signature;

public class EJBMethodUMLNotationProvider
extends AbstractMethodNameHelper
implements PropertyUniqueNameProvider {
    private static final char LBRACKET = '(';
    private static final char RBRACKET = ')';
    private static final char COMMA = ',';
    private static final char COLON = ':';
    private static final char SPACE = ' ';
    private static final char[] CANNOT_APPEAR_IN_NAME = new char[]{' ', ':', ','};
    private static final char[] BRACKETS = new char[]{'(', ')'};
    private static final String DOUBLE_COMMA = new String(new char[]{',', ','});
    private static final String SINGLE_COMMA = new String(new char[]{','});
    private static final String ARG_PREFIX = "arg";

    public EJBMethodUMLNotationProvider() {
        this.addPropertyName("$uml_representation");
        this.addPropertyName("$short_uml_representation");
    }

    public String getPropertyValue(Element element, String propertyName) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null) {
            return null;
        }
        boolean isShort = "$short_uml_representation".equals(propertyName);
        try {
            String name = method.getName();
            String[] parameterTypes = method.getParameterTypesForDD();
            String[] parameterNames = method.getParameterNames();
            String returnType = method.getReturnType();
            return this.createSignature(name, parameterTypes, parameterNames, returnType, isShort);
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null) {
            return false;
        }
        if (ReadOnlyPropertyProvider.isReadOnly(method) || ReadOnlyPropertyProvider.isSpecialMethod(method)) {
            return propertyValue != null && propertyValue.equals(this.getPropertyValue(element, propertyName));
        }
        try {
            MethodSignatureParser parser = new MethodSignatureParser(propertyValue);
            String methodName = this.introduceSuffixIfNotPresent(parser.getName(), element.getPropertyValue("$metaclass"));
            if (parser.hasParameters()) {
                return method.canSetSignature(methodName, parser.getParameterTypes(), parser.getParameterNames(), parser.getReturnType());
            }
            return method.canSetName(methodName);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public UniqueName setPropertyValue(Element element, String propertyName, String propertyValue) {
        boolean hasReturnTypeChange;
        UniqueName uin = element.getUniqueName();
        IEJBMethod method = this.getEJBMethod(uin);
        if (method == null) {
            EjbProvidersPlugin.logError("Ejb method not found");
            return uin;
        }
        if (propertyValue.equals(this.getPropertyValue(element, propertyName))) {
            return element.getUniqueName();
        }
        MethodSignatureParser parser = new MethodSignatureParser(propertyValue);
        try {
            hasReturnTypeChange = parser.getReturnType() != null && !parser.getReturnType().equals(method.getReturnType());
        }
        catch (EJBModelException e) {
            hasReturnTypeChange = true;
        }
        String methodName = this.introduceSuffixIfNotPresent(parser.getName(), element.getPropertyValue("$metaclass"));
        boolean hasNameChange = methodName != null && !methodName.equals(method.getName());
        boolean hasParametersChange = this.hasParametersChange(parser, method);
        if (!hasReturnTypeChange) {
            parser.myReturnType = null;
        }
        if (!hasNameChange && !hasParametersChange && hasReturnTypeChange) {
            try {
                method.setReturnType(parser.getReturnType(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (EJBModelException e) {
                EjbProvidersPlugin.logError("Failed to set signature", e);
            }
            return element.getUniqueName();
        }
        if (hasParametersChange || hasReturnTypeChange) {
            return this.setSignature(method, parser, methodName);
        }
        return this.setName(method, methodName);
    }

    private boolean hasParametersChange(MethodSignatureParser sig, IEJBMethod method) {
        String[] newParameters;
        if (!sig.hasParameters()) {
            return false;
        }
        String[] parameters = method.getParameterTypesForDD();
        if (parameters.length != (newParameters = sig.getParameterTypes()).length) {
            return true;
        }
        int i = 0;
        while (i < parameters.length) {
            if (!Signature.getSimpleName((String)parameters[i]).equals(Signature.getSimpleName((String)newParameters[i]))) {
                return true;
            }
            ++i;
        }
        try {
            Object[] parameterNames = method.getParameterNames();
            Object[] newParameterNames = sig.getParameterNames();
            if (!Arrays.equals(parameterNames, newParameterNames)) {
                return true;
            }
        }
        catch (EJBModelException e) {
            return true;
        }
        return false;
    }

    private UniqueName setSignature(IEJBMethod method, MethodSignatureParser signature, String methodNameAfterCorrection) {
        try {
            method = method.setSignature(methodNameAfterCorrection, signature.getParameterTypes(), signature.getParameterNames(), signature.getReturnType(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logError("Failed to set signature", e);
        }
        return this.getUniqueName((IEJBElement)method);
    }

    private UniqueName setName(IEJBMethod method, String name) {
        try {
            method = method.setName(name, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logError("Failed to set signature", e);
        }
        return this.getUniqueName((IEJBElement)method);
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    private String createSignature(String name, String[] parameterTypes, String[] parameterNames, String returnType, boolean isShort) {
        StringBuffer result = new StringBuffer();
        result.append(name);
        result.append(this.getParamRelatedSignature(parameterTypes, parameterNames, isShort));
        result.append(':');
        result.append(this.formatTypeName(returnType, isShort));
        return result.toString();
    }

    private String getParamRelatedSignature(String[] paramTypes, String[] paramNames, boolean isShort) {
        StringBuffer result = new StringBuffer();
        result.append('(');
        int i = 0;
        int iLast = paramTypes.length - 1;
        while (i <= iLast) {
            if (paramNames[i] != null) {
                result.append(paramNames[i]);
            }
            String nextParam = paramTypes[i];
            result.append(':').append(this.formatTypeName(nextParam, isShort));
            if (i < iLast) {
                result.append(',');
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    private String formatTypeName(String typeName, boolean isShort) {
        if (typeName == null) {
            return null;
        }
        if (isShort) {
            return Signature.getSimpleName((String)typeName);
        }
        return typeName;
    }

    private static class MethodSignatureParser {
        private String myName;
        private ArrayList myParameterTypes;
        private ArrayList myParameterNames;
        private String myReturnType;

        public MethodSignatureParser(String umlRepresentation) throws IllegalArgumentException {
            if (umlRepresentation == null) {
                throw new IllegalArgumentException();
            }
            if ((umlRepresentation = umlRepresentation.trim()).length() == 0) {
                throw new IllegalArgumentException();
            }
            int left = umlRepresentation.indexOf(40);
            int right = umlRepresentation.indexOf(41);
            if (left == -1 && right == -1) {
                this.setName(umlRepresentation);
                return;
            }
            if (left == -1 || right == -1 || left > right) {
                throw new IllegalArgumentException();
            }
            String leftPart = umlRepresentation.substring(0, left);
            String rightPart = umlRepresentation.substring(right + 1);
            String paramsPart = umlRepresentation.substring(left + 1, right);
            if (this.hasAnyOf(leftPart, BRACKETS) || this.hasAnyOf(rightPart, BRACKETS) || this.hasAnyOf(paramsPart, BRACKETS)) {
                throw new IllegalArgumentException();
            }
            this.parseNameAndReturnType(leftPart, rightPart);
            this.parseParameters(paramsPart);
        }

        private void parseNameAndReturnType(String leftPart, String rightPart) throws IllegalArgumentException {
            leftPart = leftPart.trim();
            if ((rightPart = rightPart.trim()).length() == 0) {
                int blank = leftPart.indexOf(32);
                if (blank == -1) {
                    this.setName(leftPart);
                } else {
                    this.setName(leftPart.substring(0, blank).trim());
                    this.setReturnType(leftPart.substring(blank).trim());
                }
            } else {
                if (rightPart.charAt(0) != ':') {
                    throw new IllegalArgumentException();
                }
                rightPart = rightPart.substring(1).trim();
                this.setName(leftPart);
                this.setReturnType(rightPart);
            }
        }

        private void parseParameters(String paramsPart) throws IllegalArgumentException {
            if (paramsPart.indexOf(DOUBLE_COMMA) != -1) {
                throw new IllegalArgumentException();
            }
            if (paramsPart.length() > 0 && paramsPart.charAt(paramsPart.length() - 1) == ',') {
                throw new IllegalArgumentException();
            }
            this.myParameterTypes = new ArrayList();
            this.myParameterNames = new ArrayList();
            StringTokenizer tokenizer = new StringTokenizer(paramsPart, SINGLE_COMMA);
            while (tokenizer.hasMoreTokens()) {
                this.parseSingleParameter(tokenizer.nextToken());
            }
        }

        private void parseSingleParameter(String param) throws IllegalArgumentException {
            if ((param = param.trim()).length() == 0) {
                throw new IllegalArgumentException();
            }
            int colon = param.indexOf(58);
            if (colon != -1) {
                String name = param.substring(0, colon).trim();
                if (name.length() == 0) {
                    name = this.inventName();
                }
                String type = param.substring(colon + 1).trim();
                this.addParameter(type, name);
                return;
            }
            int blank = param.indexOf(32);
            if (blank == -1) {
                this.addParameter(param, this.inventName());
            } else {
                String type = param.substring(0, blank).trim();
                String name = param.substring(blank + 1).trim();
                this.addParameter(type, name);
            }
        }

        private String inventName() {
            int parametersCount = this.myParameterNames.size() + 1;
            return EJBMethodUMLNotationProvider.ARG_PREFIX + parametersCount;
        }

        private boolean hasAnyOf(String who, char[] what) {
            int i = 0;
            while (i < what.length) {
                if (who.indexOf(what[i]) >= 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private void assertIdentifierRequirements(String name) throws IllegalArgumentException {
            if (this.hasAnyOf(name, CANNOT_APPEAR_IN_NAME)) {
                throw new IllegalArgumentException();
            }
            if (name.length() == 0) {
                throw new IllegalArgumentException();
            }
        }

        private void assertTypeRequirements(String type) throws IllegalArgumentException {
            this.assertIdentifierRequirements(type);
            try {
                Signature.createTypeSignature((String)type, (boolean)false);
            }
            catch (Exception e) {
                throw new IllegalArgumentException();
            }
        }

        private void setName(String name) throws IllegalArgumentException {
            this.assertIdentifierRequirements(name);
            if (!JavaConventions.validateMethodName((String)name).isOK()) {
                throw new IllegalArgumentException();
            }
            this.myName = name;
        }

        private void setReturnType(String returnType) throws IllegalArgumentException {
            this.assertTypeRequirements(returnType);
            this.myReturnType = returnType;
        }

        private void addParameter(String type, String name) throws IllegalArgumentException {
            this.assertTypeRequirements(type);
            this.assertIdentifierRequirements(name);
            if (!JavaConventions.validateFieldName((String)name).isOK()) {
                throw new IllegalArgumentException();
            }
            this.myParameterTypes.add(type);
            this.myParameterNames.add(name);
        }

        public String getName() {
            return this.myName;
        }

        public String[] getParameterTypes() {
            return this.myParameterTypes.toArray(new String[this.myParameterTypes.size()]);
        }

        public String[] getParameterNames() {
            return this.myParameterNames.toArray(new String[this.myParameterNames.size()]);
        }

        public boolean hasParameters() {
            return this.myParameterTypes != null;
        }

        public String getReturnType() {
            return this.myReturnType;
        }
    }
}

