/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import java.util.HashSet;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.Signature;

class EJBMethodParametersUtils {
    private EJBMethodParametersUtils() {
    }

    public static boolean isValidTypes(String[] types) {
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            if (type == null || type.length() == 0) {
                return false;
            }
            ++i;
        }
        try {
            JDTUtils.java2jdt((String[])types, (boolean)false);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isValidTypesAndNames(String[] parameters) {
        if (parameters.length % 2 > 0) {
            return false;
        }
        HashSet<String> names = new HashSet<String>(parameters.length / 2);
        int i = 0;
        while (i < parameters.length) {
            String parameter = parameters[i];
            if (i % 2 == 0) {
                if (parameter == null || parameter.length() == 0) {
                    return false;
                }
                try {
                    Signature.createTypeSignature((String)parameter, (boolean)false);
                }
                catch (Exception e) {
                    return false;
                }
            } else if (parameter != null && parameter.length() > 0) {
                if (names.contains(parameter)) {
                    return false;
                }
                if (!JavaConventions.validateFieldName((String)parameter).isOK()) {
                    return false;
                }
                names.add(parameter);
            }
            ++i;
        }
        return true;
    }

    public static String[] extractParameterTypes(String[] parameters) {
        String[] types = new String[parameters.length / 2];
        int i = 0;
        while (i < types.length) {
            types[i] = parameters[2 * i];
            ++i;
        }
        return types;
    }

    public static String[] extractParameterNames(String[] parameters) {
        String[] names = new String[parameters.length / 2];
        int i = 0;
        while (i < names.length) {
            names[i] = parameters[2 * i + 1];
            ++i;
        }
        return names;
    }

    public static String[] mergeTypesWithNames(String[] types, String[] names) {
        String[] parameters = new String[2 * types.length];
        int i = 0;
        while (i < types.length) {
            parameters[2 * i] = types[i];
            if (names != null) {
                parameters[2 * i + 1] = names[i];
            }
            ++i;
        }
        return parameters;
    }
}

