/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.core.utils.RuntimeSupport;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.ejb.providers.EJBMethodParametersUtils;
import com.tssap.j2ee.internal.core.ejb.providers.ReadOnlyPropertyProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.ObjectPropertyProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class EJBMethodParameterNameArrayProvider
extends AbstractEJBProvider
implements ObjectPropertyProvider {
    public Object getObjectPropertyValue(Element element, String propertyName) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null) {
            EjbProvidersPlugin.logError("Ejb method not found");
            return null;
        }
        try {
            String[] types = method.getParameterTypesForDD();
            String[] names = method.getParameterNames();
            return EJBMethodParametersUtils.mergeTypesWithNames(types, names);
        }
        catch (EJBModelException eme) {
            EjbProvidersPlugin.logError(eme.toString());
            return null;
        }
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        return null;
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        if (propertyValue == null) {
            return true;
        }
        if (!(propertyValue instanceof String[])) {
            return false;
        }
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null || ReadOnlyPropertyProvider.isReadOnly(method) || ReadOnlyPropertyProvider.isSpecialMethod(method)) {
            return false;
        }
        return EJBMethodParametersUtils.isValidTypesAndNames((String[])propertyValue);
    }

    public void setObjectPropertyValue(Element element, String propertyName, final Object propertyValue) {
        final IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null) {
            EjbProvidersPlugin.logError("Ejb method not found");
            return;
        }
        try {
            RuntimeSupport.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        String[] types = null;
                        String[] names = null;
                        String[] parameters = (String[])propertyValue;
                        if (parameters != null) {
                            types = EJBMethodParametersUtils.extractParameterTypes(parameters);
                            names = EJBMethodParametersUtils.extractParameterNames(parameters);
                        }
                        method.setParameters(types, names, monitor);
                    }
                    catch (EJBModelException eme) {
                        throw new InvocationTargetException(eme);
                    }
                }
            });
        }
        catch (CoreException ce) {
            EjbProvidersPlugin.logError(ce.toString());
        }
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return EjbModelMetaInfo.isEjbMethod(element.getUniqueName()) && "parameterNameArray".equals(propertyName);
    }
}

