/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.ejb.IBusinessMethod;
import com.tssap.j2ee.core.ejb.ICreateMethod;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IFinderMethod;
import com.tssap.j2ee.core.ejb.IHomeMethod;
import com.tssap.j2ee.core.ejb.ISelectMethod;
import com.tssap.j2ee.core.utils.RuntimeSupport;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractMethodNameHelper;
import com.tssap.j2ee.internal.core.ejb.providers.ReadOnlyPropertyProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.PropertyUniqueNameProvider;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class EJBMethodNameProvider
extends AbstractMethodNameHelper
implements PropertyUniqueNameProvider {
    public EJBMethodNameProvider() {
        this.addPropertyName("$name");
    }

    public String getPropertyValue(Element element, String propertyName) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null) {
            EjbProvidersPlugin.logError("Ejb method not found");
            return null;
        }
        return method.getName();
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (!this.isValidName(element, propertyName, propertyValue = this.introduceSuffixIfNotPresent(propertyValue, element.getPropertyValue("$metaclass")))) {
            return false;
        }
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null) {
            return false;
        }
        return method.canSetName(propertyValue);
    }

    private boolean isValidName(Element element, String propertyName, String propertyValue) {
        IStatus status = JavaConventions.validateMethodName((String)propertyValue);
        if (!status.isOK()) {
            return false;
        }
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null) {
            return false;
        }
        if (ReadOnlyPropertyProvider.isReadOnly(method) || ReadOnlyPropertyProvider.isSpecialMethod(method)) {
            return propertyValue != null && propertyValue.equals(this.getPropertyValue(element, propertyName));
        }
        if (method instanceof IBusinessMethod) {
            return EjbMetaInfo.isBusinessMethodImplName((String)propertyValue);
        }
        if (method instanceof ICreateMethod) {
            if (((IEnterpriseBean)method.getParent()).isEjbVersion1_X()) {
                return EjbMetaInfo.isCreateMethodImplName1_1((String)propertyValue);
            }
            return EjbMetaInfo.isCreateMethodImplName((String)propertyValue);
        }
        if (method instanceof IFinderMethod) {
            return EjbMetaInfo.isFindMethodImplName((String)propertyValue);
        }
        if (method instanceof IHomeMethod) {
            return EjbMetaInfo.isHomeMethodImplName((String)propertyValue);
        }
        if (method instanceof ISelectMethod) {
            return EjbMetaInfo.isSelectMethodName((String)propertyValue);
        }
        return false;
    }

    public UniqueName setPropertyValue(Element element, String propertyName, String propertyValue) {
        final String propertyValueWithPossibleSuffix = this.introduceSuffixIfNotPresent(propertyValue, element.getPropertyValue("$metaclass"));
        UniqueName uin = element.getUniqueName();
        final IEJBMethod method = this.getEJBMethod(uin);
        if (method == null) {
            EjbProvidersPlugin.logError("Ejb method not found");
            return uin;
        }
        final IEJBMethod[] resultMethodHolder = new IEJBMethod[1];
        try {
            RuntimeSupport.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        resultMethodHolder[0] = method.setName(propertyValueWithPossibleSuffix, monitor);
                    }
                    catch (EJBModelException eme) {
                        throw new InvocationTargetException(eme);
                    }
                }
            });
            return this.getUniqueName((IEJBElement)resultMethodHolder[0]);
        }
        catch (CoreException ce) {
            EjbProvidersPlugin.logError(ce.toString());
            return uin;
        }
    }
}

