/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.ObjectPropertyProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.jdt.core.IMethod;

public class EJBMethodLinkAsIMethodPropertyProvider
extends AbstractEJBProvider
implements ObjectPropertyProvider {
    private static final IntHashMap PROPERTIES_MAPPING = new IntHashMap();

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (!EjbModelMetaInfo.isEjbMethod(element.getUniqueName())) {
            return false;
        }
        return EJBMethodLinkAsIMethodPropertyProvider.getRoleForProperty(propertyName) != 0;
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        IEJBMethod ejbMethod = this.getEJBMethod(element.getUniqueName());
        if (ejbMethod == null) {
            return null;
        }
        int role = EJBMethodLinkAsIMethodPropertyProvider.getRoleForProperty(propertyName);
        if (role == 0) {
            return null;
        }
        try {
            IMethod method = ejbMethod.getMethod(role);
            if (method == null || !method.exists()) {
                return null;
            }
            return method;
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        Object propertyValue = this.getObjectPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return EmptyEnumeration.getEnumeration();
        }
        return Collections.enumeration(Collections.singleton(propertyValue));
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        if (!(propertyValue instanceof Boolean)) {
            return false;
        }
        boolean promote = (Boolean)propertyValue;
        IEJBMethod ejbMethod = this.getEJBMethod(element.getUniqueName());
        if (ejbMethod == null) {
            return false;
        }
        int role = EJBMethodLinkAsIMethodPropertyProvider.getRoleForProperty(propertyName);
        if (role == 0) {
            return false;
        }
        if (promote) {
            return ejbMethod.canPromote(role);
        }
        return ejbMethod.canUnpromote(role);
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        boolean promote = (Boolean)propertyValue;
        IEJBMethod ejbMethod = this.getEJBMethod(element.getUniqueName());
        int role = EJBMethodLinkAsIMethodPropertyProvider.getRoleForProperty(propertyName);
        try {
            if (promote) {
                ejbMethod.promote(role);
            } else {
                ejbMethod.unpromote(role);
            }
        }
        catch (EJBModelException e) {
            e.printStackTrace();
        }
    }

    protected static int getRoleForProperty(String propertyName) {
        try {
            return PROPERTIES_MAPPING.find((Object)propertyName);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    static {
        PROPERTIES_MAPPING.put(1, (Object)"beanClassMethod");
        PROPERTIES_MAPPING.put(2, (Object)"homeInterfaceMethod");
        PROPERTIES_MAPPING.put(4, (Object)"remoteInterfaceMethod");
        PROPERTIES_MAPPING.put(8, (Object)"localHomeInterfaceMethod");
        PROPERTIES_MAPPING.put(16, (Object)"localInterfaceMethod");
        PROPERTIES_MAPPING.put(64, (Object)"beanClassPostMethod");
    }
}

