/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.utils.RuntimeSupport;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBMethodCreator;
import com.tssap.j2ee.internal.core.ejb.providers.EJBMethodParametersUtils;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class EJBMethodExistenceProvider
extends AbstractEJBMethodCreator
implements EntityExistenceProvider {
    private static final HashMap METHOD_NAMES = new HashMap();
    private static final HashMap METHOD_RETURN_TYPES = new HashMap();
    private static final IntHashMap METHOD_KINDS = new IntHashMap();
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$lang$Object;

    public boolean exists(UniqueName uniqueName) {
        IEJBMethod method = this.getEJBMethod(uniqueName);
        return method != null;
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        Object pObject;
        if (!this.isMetaclassApplicable(parent, shapeType)) {
            return false;
        }
        IEnterpriseBean bean = this.getBean(parent.getUniqueName());
        if (bean == null || bean.getBeanClass() == null) {
            return false;
        }
        int methodKind = EJBMethodExistenceProvider.getMethodKind(shapeType);
        if (methodKind == -1 || this.isAnyPartReadOnly(bean, methodKind)) {
            return false;
        }
        if (methodKind == 4 && (!this.participantPairsConsistent(bean) || this.pkMissing(bean))) {
            return false;
        }
        if (template == null) {
            return true;
        }
        String name = template.getPropertyValue("$name");
        if ((methodKind & 0x11) > 0 && "".equals(name)) {
            return false;
        }
        if (name != null && name.length() > 0 && !this.isValidNameForMethodType(name, methodKind)) {
            return false;
        }
        String returnType = template.getPropertyValue("$returnType");
        if (methodKind == 4 && returnType != null) {
            try {
                if (!(class$java$util$Collection == null ? (class$java$util$Collection = EJBMethodExistenceProvider.class$("java.util.Collection")) : class$java$util$Collection).getName().equals(returnType) && !(class$java$util$Enumeration == null ? (class$java$util$Enumeration = EJBMethodExistenceProvider.class$("java.util.Enumeration")) : class$java$util$Enumeration).getName().equals(returnType)) {
                    String pkStr;
                    IType pk = ((IEntityBean)bean).getParticipant(32);
                    String string = pk == null ? (class$java$lang$Object == null ? (class$java$lang$Object = EJBMethodExistenceProvider.class$("java.lang.Object")) : class$java$lang$Object).getName() : (pkStr = pk.getFullyQualifiedName());
                    if (!Signature.getSimpleName((String)pkStr).equals(Signature.getSimpleName((String)returnType))) {
                        return false;
                    }
                }
            }
            catch (EJBModelException e) {
                return false;
            }
        }
        if (!((pObject = template.getObjectPropertyValue("parameterNameArray")) == null || pObject instanceof String[] && EJBMethodParametersUtils.isValidTypesAndNames((String[])pObject))) {
            return false;
        }
        pObject = template.getObjectPropertyValue("parameterArray");
        if (!(pObject == null || pObject instanceof String[] && EJBMethodParametersUtils.isValidTypes((String[])pObject))) {
            return false;
        }
        pObject = template.getObjectPropertyValue("exceptionArray");
        return pObject == null || pObject instanceof String[] && EJBMethodParametersUtils.isValidTypes((String[])pObject);
    }

    private boolean isValidNameForMethodType(String name, int methodKind) {
        switch (methodKind) {
            case 1: {
                return JavaConventions.validateMethodName((String)name).isOK() && EjbMetaInfo.isBusinessMethodImplName((String)name);
            }
            case 8: {
                String actualName = EjbMetaInfo.getHomeMethodImplName((String)name);
                return JavaConventions.validateMethodName((String)actualName).isOK() && EjbMetaInfo.isHomeMethodImplName((String)actualName);
            }
            case 4: {
                String actualName = EjbMetaInfo.getFindMethodImplName((String)name);
                return JavaConventions.validateMethodName((String)actualName).isOK();
            }
            case 16: {
                String actualName = EjbMetaInfo.getSelectMethodName((String)name);
                return JavaConventions.validateMethodName((String)actualName).isOK();
            }
        }
        return true;
    }

    private boolean isMetaclassApplicable(Entity parent, String shapeType) {
        if ("com.tssap.j2ee.core.ejb.method.Business".equals(shapeType)) {
            return EjbModelMetaInfo.isEntityBean(parent.getUniqueName()) || EjbModelMetaInfo.isSessionBean(parent.getUniqueName());
        }
        if ("com.tssap.j2ee.core.ejb.method.Find".equals(shapeType)) {
            return EjbModelMetaInfo.isEntityBean(parent.getUniqueName());
        }
        if ("com.tssap.j2ee.core.ejb.method.Home".equals(shapeType)) {
            return EjbModelMetaInfo.isEntityBean(parent.getUniqueName()) && parent.hasProperty("cmpVersion2_X");
        }
        if ("com.tssap.j2ee.core.ejb.method.Select".equals(shapeType)) {
            return EjbModelMetaInfo.isEntityBean(parent.getUniqueName()) && parent.hasProperty("cmp") && parent.hasProperty("cmpVersion2_X");
        }
        return false;
    }

    public UniqueName createUniqueName(Entity parent, final String shapeType, Entity template) {
        String[] names;
        String[] types;
        String[] exceptions;
        String[] parameters;
        String returnType;
        String userMethodName;
        final IEnterpriseBean bean = this.getBean(parent.getUniqueName());
        if (bean == null) {
            EjbProvidersPlugin.logError("Ejb method not found");
            return null;
        }
        if (template == null) {
            userMethodName = this.getUnusedMethodName(bean, shapeType);
            returnType = this.getDefaultReturnType(shapeType);
            parameters = ArrayUtils.EMPTY_STRING_ARRAY;
            exceptions = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            String defaultUserMethodName = template.getPropertyValue("$name");
            userMethodName = defaultUserMethodName == null ? this.getUnusedMethodName(bean, shapeType) : defaultUserMethodName;
            String defaultReturnType = template.getPropertyValue("$returnType");
            returnType = defaultReturnType == null ? this.getDefaultReturnType(shapeType) : defaultReturnType;
            parameters = (String[])template.getObjectPropertyValue("parameterNameArray");
            exceptions = (String[])template.getObjectPropertyValue("exceptionArray");
        }
        if (parameters != null) {
            types = EJBMethodParametersUtils.extractParameterTypes(parameters);
            names = EJBMethodParametersUtils.extractParameterNames(parameters);
        } else {
            parameters = (String[])template.getObjectPropertyValue("parameterArray");
            types = parameters == null ? ArrayUtils.EMPTY_STRING_ARRAY : parameters;
            names = null;
        }
        final String[] exceptionTypes = exceptions == null ? ArrayUtils.EMPTY_STRING_ARRAY : exceptions;
        final String[] finalTypes = this.addQualificationToTypes(bean.getBeanClass(), types);
        final IEJBMethod[] methodHolder = new IEJBMethod[1];
        try {
            RuntimeSupport.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if ("com.tssap.j2ee.core.ejb.method.Business".equals(shapeType)) {
                            methodHolder[0] = EJBMethodExistenceProvider.this.reuseExistingMethod((IAccessibleBean)bean, userMethodName, finalTypes);
                            if (methodHolder[0] == null) {
                                methodHolder[0] = ((IAccessibleBean)bean).createBusinessMethod(userMethodName, finalTypes, names, returnType, exceptionTypes, monitor);
                            }
                        } else if ("com.tssap.j2ee.core.ejb.method.Find".equals(shapeType)) {
                            methodHolder[0] = EJBMethodExistenceProvider.this.reuseExistingMethod((IAccessibleBean)bean, EjbMetaInfo.getFindMethodImplName((String)userMethodName), finalTypes);
                            if (methodHolder[0] == null) {
                                methodHolder[0] = ((IEntityBean)bean).createFindMethod(userMethodName, finalTypes, names, returnType, exceptionTypes, monitor);
                            }
                        } else if ("com.tssap.j2ee.core.ejb.method.Home".equals(shapeType)) {
                            methodHolder[0] = EJBMethodExistenceProvider.this.reuseExistingMethod((IAccessibleBean)bean, EjbMetaInfo.getHomeMethodImplName((String)userMethodName), finalTypes);
                            if (methodHolder[0] == null) {
                                methodHolder[0] = ((IEntityBean)bean).createHomeMethod(userMethodName, finalTypes, names, returnType, exceptionTypes, monitor);
                            }
                        } else if ("com.tssap.j2ee.core.ejb.method.Select".equals(shapeType)) {
                            methodHolder[0] = EJBMethodExistenceProvider.this.reuseExistingMethod((IAccessibleBean)bean, EjbMetaInfo.getSelectMethodName((String)userMethodName), finalTypes);
                            if (methodHolder[0] == null) {
                                methodHolder[0] = ((IEntityBean)bean).createSelectMethod(userMethodName, finalTypes, names, returnType, exceptionTypes, monitor);
                            }
                        } else {
                            EjbProvidersPlugin.logError("Unknown shape type in ejb method creation procedure [" + shapeType + "]");
                        }
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
            });
        }
        catch (CoreException ce) {
            EjbProvidersPlugin.logError("Unable to create ejb method", ce);
            return null;
        }
        return this.getUniqueName((IEJBElement)methodHolder[0]);
    }

    private String getDefaultReturnType(String shapeType) {
        return (String)METHOD_RETURN_TYPES.get(shapeType);
    }

    private String getUnusedMethodName(IEnterpriseBean bean, String shapeType) {
        IEJBMethod[] methods;
        if (!(bean instanceof IAccessibleBean)) {
            return "";
        }
        IAccessibleBean accBean = (IAccessibleBean)bean;
        String methodBase = this.getMethodNameBase(shapeType);
        HashSet<String> methodNames = new HashSet<String>();
        try {
            methods = accBean.getEJBMethods();
        }
        catch (EJBModelException e) {
            methods = new IEJBMethod[]{};
        }
        int i = 0;
        while (i < methods.length) {
            methodNames.add(methods[i].getName());
            ++i;
        }
        if (!"com.tssap.j2ee.core.ejb.method.Select".equals(shapeType) && !methodNames.contains(methodBase)) {
            if ("com.tssap.j2ee.core.ejb.method.Business".equals(shapeType)) {
                return methodBase;
            }
            if ("com.tssap.j2ee.core.ejb.method.Home".equals(shapeType)) {
                return "method";
            }
            return "";
        }
        int i2 = 1;
        while (true) {
            if (!methodNames.contains(methodBase + i2)) {
                if ("com.tssap.j2ee.core.ejb.method.Business".equals(shapeType)) {
                    return methodBase + i2;
                }
                if ("com.tssap.j2ee.core.ejb.method.Home".equals(shapeType)) {
                    return "method" + i2;
                }
                return Integer.toString(i2);
            }
            ++i2;
        }
    }

    private String getMethodNameBase(String shapeType) {
        return (String)METHOD_NAMES.get(shapeType);
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return EjbModelMetaInfo.isEjbMethod(element.getUniqueName());
    }

    public boolean canDelete(Element element) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null) {
            return false;
        }
        return method.canDelete();
    }

    public void delete(Element element) {
        final IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null) {
            EjbProvidersPlugin.logError("Ejb method not found");
            return;
        }
        try {
            RuntimeSupport.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        method.delete(monitor);
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
            });
        }
        catch (CoreException ce) {
            EjbProvidersPlugin.logError("Unable to delete ejb method", ce);
        }
    }

    private static int getMethodKind(String shapeType) {
        try {
            return METHOD_KINDS.find((Object)shapeType);
        }
        catch (NoSuchElementException e) {
            return -1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        METHOD_NAMES.put("com.tssap.j2ee.core.ejb.method.Business", "method");
        METHOD_NAMES.put("com.tssap.j2ee.core.ejb.method.Find", "ejbFind");
        METHOD_NAMES.put("com.tssap.j2ee.core.ejb.method.Home", "ejbHomeMethod");
        METHOD_NAMES.put("com.tssap.j2ee.core.ejb.method.Select", "ejbSelect");
        METHOD_RETURN_TYPES.put("com.tssap.j2ee.core.ejb.method.Business", "void");
        METHOD_RETURN_TYPES.put("com.tssap.j2ee.core.ejb.method.Find", "java.util.Collection");
        METHOD_RETURN_TYPES.put("com.tssap.j2ee.core.ejb.method.Home", "void");
        METHOD_RETURN_TYPES.put("com.tssap.j2ee.core.ejb.method.Select", "java.util.Collection");
        METHOD_KINDS.put(1, (Object)"com.tssap.j2ee.core.ejb.method.Business");
        METHOD_KINDS.put(4, (Object)"com.tssap.j2ee.core.ejb.method.Find");
        METHOD_KINDS.put(8, (Object)"com.tssap.j2ee.core.ejb.method.Home");
        METHOD_KINDS.put(16, (Object)"com.tssap.j2ee.core.ejb.method.Select");
    }
}

