/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.ICopiedEJBElement;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.ejb.providers.ReadOnlyPropertyProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.CopyProvider;
import com.tssap.selena.model.extension.CutProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.PasteProvider;
import java.util.HashMap;

public class EJBMethodCopyPasteProvider
extends AbstractEJBProvider
implements CopyProvider,
CutProvider,
PasteProvider,
EntityExistenceProvider {
    private HashMap myClipboardUins2Elements;

    public boolean isCopyProviderApplicable(Element element) {
        return EjbModelMetaInfo.isEjbMethod(element.getUniqueName());
    }

    public boolean canCopy(Element element) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null) {
            return false;
        }
        return method.canCopy();
    }

    public void copy(Element element, CopyUniqueName copyUniqueName) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        try {
            ICopiedEJBElement copiedMethod = method.copy();
            this.myClipboardUins2Elements.put(copyUniqueName, copiedMethod);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to copy method after canCopy returned true", e);
        }
    }

    public boolean isCutProviderApplicable(Element element) {
        return EjbModelMetaInfo.isEjbMethod(element.getUniqueName());
    }

    public boolean canCut(Element element) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        if (method == null || ReadOnlyPropertyProvider.isReadOnly(method)) {
            return false;
        }
        return method.canCut();
    }

    public void cut(Element element, CopyUniqueName cutUniqueName) {
        IEJBMethod method = this.getEJBMethod(element.getUniqueName());
        try {
            ICopiedEJBElement cut = method.cut();
            this.myClipboardUins2Elements.put(cutUniqueName, cut);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to cut method after canCut returned true", e);
        }
    }

    public boolean isPasteProviderApplicable(Entity container) {
        return EjbModelMetaInfo.isEjb(container.getUniqueName());
    }

    public boolean canPaste(Entity container, Element element, Element anchor, boolean before) {
        IEnterpriseBean bean = this.getBean(container.getUniqueName());
        if (bean == null) {
            return false;
        }
        ICopiedEJBElement copy = (ICopiedEJBElement)this.myClipboardUins2Elements.get(element.getUniqueName());
        if (copy == null) {
            return false;
        }
        return copy.canPaste((IEJBElement)bean);
    }

    public UniqueName paste(Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        IEnterpriseBean bean = this.getBean(container.getUniqueName());
        ICopiedEJBElement copy = (ICopiedEJBElement)this.myClipboardUins2Elements.get(element.getUniqueName());
        try {
            IEJBMethod pasted = (IEJBMethod)copy.paste((IEJBElement)bean);
            return EjbModelMetaInfo.getUniqueName(pasted);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logError("Exception while pasting", e);
            return null;
        }
    }

    public boolean exists(UniqueName uniqueName) {
        return this.myClipboardUins2Elements.containsKey(uniqueName);
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return element.getUniqueName() instanceof CopyUniqueName;
    }

    public boolean canDelete(Element element) {
        return this.exists(element.getUniqueName());
    }

    public void delete(Element element) {
        ICopiedEJBElement copiedMethod = (ICopiedEJBElement)this.myClipboardUins2Elements.remove(element.getUniqueName());
        try {
            copiedMethod.delete(null);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to clean up the copied method", e);
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public void unregistered(Model model) {
        super.unregistered(model);
        this.myClipboardUins2Elements = null;
    }

    public void registered(Model model) {
        super.registered(model);
        this.myClipboardUins2Elements = new HashMap();
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }
}

