/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyWriter;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import java.util.NoSuchElementException;
import org.eclipse.jdt.core.IType;

public class EJBLinkAsPropertyProvider
extends AbstractPropertyWriter {
    private static final IntHashMap PROPERTIES_MAPPING = new IntHashMap();

    public EJBLinkAsPropertyProvider() {
        this.addPropertyName("homeInterface");
        this.addPropertyName("remoteInterface");
        this.addPropertyName("localHomeInterface");
        this.addPropertyName("localInterface");
        this.addPropertyName("primaryKeyClass");
        this.addPropertyName("homeInterfaceRename");
        this.addPropertyName("remoteInterfaceRename");
        this.addPropertyName("localHomeInterfaceRename");
        this.addPropertyName("localInterfaceRename");
    }

    public String getPropertyValue(Element element, String propertyName) {
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (!(bean instanceof IAccessibleBean)) {
            return null;
        }
        int role = EJBLinkAsPropertyProvider.getRoleForProperty(propertyName);
        if (role == 0) {
            return null;
        }
        IAccessibleBean accBean = (IAccessibleBean)bean;
        try {
            IType type = accBean.getParticipant(role);
            if (type == null || !type.exists()) {
                return null;
            }
            return type.getFullyQualifiedName();
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String fqn) {
        String unnormalizedPropertyName = propertyName;
        boolean shouldDeleteOldParticipants = !(propertyName = EJBLinkAsPropertyProvider.normalizeProperty(propertyName)).equals(unnormalizedPropertyName);
        int intRole = EJBLinkAsPropertyProvider.getRoleForProperty(propertyName);
        if (intRole == 0 || intRole == 1) {
            return false;
        }
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (!(bean instanceof IAccessibleBean)) {
            return false;
        }
        IAccessibleBean accBean = (IAccessibleBean)bean;
        if (fqn == null) {
            return true;
        }
        try {
            if (shouldDeleteOldParticipants && accBean.getParticipant(intRole) == null) {
                return false;
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        return accBean.canAddParticipant(intRole, fqn);
    }

    public boolean canAddProperty(Element element, String propertyName, String fqn) {
        return !this.hasProperty(element, propertyName) && this.canSetPropertyValue(element, propertyName, fqn);
    }

    public void setPropertyValue(Element element, String propertyName, String fqn) {
        String unnormalizedPropertyName = propertyName;
        boolean shouldDeleteOldParticipants = !(propertyName = EJBLinkAsPropertyProvider.normalizeProperty(propertyName)).equals(unnormalizedPropertyName);
        int intRole = EJBLinkAsPropertyProvider.getRoleForProperty(propertyName);
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (bean instanceof IAccessibleBean) {
            IAccessibleBean accBean = (IAccessibleBean)bean;
            try {
                if (fqn == null) {
                    accBean.removeParticipant(intRole, false, null);
                } else {
                    accBean.addParticipant(intRole, fqn, true, shouldDeleteOldParticipants, null, null);
                }
            }
            catch (EJBModelException e) {
                EjbProvidersPlugin.logError("Cannot set this value", e);
            }
        }
    }

    public Property addProperty(Element element, String propertyName, String fqn) {
        this.setPropertyValue(element, propertyName, fqn);
        return this.getProperty(element, propertyName);
    }

    protected static int getRoleForProperty(String propertyName) {
        try {
            return PROPERTIES_MAPPING.find((Object)propertyName);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    protected static String normalizeProperty(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        if (propertyName.endsWith("Rename")) {
            return propertyName.substring(0, propertyName.length() - "Rename".length());
        }
        return propertyName;
    }

    static {
        PROPERTIES_MAPPING.put(2, (Object)"homeInterface");
        PROPERTIES_MAPPING.put(4, (Object)"remoteInterface");
        PROPERTIES_MAPPING.put(8, (Object)"localHomeInterface");
        PROPERTIES_MAPPING.put(16, (Object)"localInterface");
        PROPERTIES_MAPPING.put(32, (Object)"primaryKeyClass");
    }
}

