/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.ObjectPropertyProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.jdt.core.IType;

public class EJBLinkAsITypePropertyProvider
extends AbstractEJBProvider
implements ObjectPropertyProvider {
    private static final IntHashMap PROPERTIES_MAPPING = new IntHashMap();

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (!EjbModelMetaInfo.isEjb(element.getUniqueName())) {
            return false;
        }
        return EJBLinkAsITypePropertyProvider.getRoleForProperty(propertyName) != 0;
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (bean == null) {
            return null;
        }
        int role = EJBLinkAsITypePropertyProvider.getRoleForProperty(propertyName);
        if (role == 0) {
            return null;
        }
        if (role == 1) {
            return bean.getBeanClass();
        }
        if (!(bean instanceof IAccessibleBean)) {
            return null;
        }
        IAccessibleBean accBean = (IAccessibleBean)bean;
        try {
            IType type = accBean.getParticipant(role);
            if (type == null || !type.exists()) {
                return null;
            }
            return type;
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        Object propertyValue = this.getObjectPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return EmptyEnumeration.getEnumeration();
        }
        return Collections.enumeration(Collections.singleton(propertyValue));
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object type) {
        int intRole = EJBLinkAsITypePropertyProvider.getRoleForProperty(propertyName);
        if (intRole == 0 || intRole == 1) {
            return false;
        }
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (!(bean instanceof IAccessibleBean)) {
            return false;
        }
        if (type == null) {
            return true;
        }
        if (!(type instanceof IType)) {
            return false;
        }
        IAccessibleBean accBean = (IAccessibleBean)bean;
        String fqn = ((IType)type).getFullyQualifiedName();
        return accBean.canAddParticipant(intRole, fqn);
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object type) {
        int intRole = EJBLinkAsITypePropertyProvider.getRoleForProperty(propertyName);
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (bean instanceof IAccessibleBean) {
            IAccessibleBean accBean = (IAccessibleBean)bean;
            try {
                if (type == null) {
                    accBean.removeParticipant(intRole, false, null);
                } else {
                    String fqn = ((IType)type).getFullyQualifiedName();
                    accBean.addParticipant(intRole, fqn, true, null, null);
                }
            }
            catch (EJBModelException e) {
                EjbProvidersPlugin.logWarning("Failed to set EJB participant", e);
            }
        }
    }

    protected static int getRoleForProperty(String propertyName) {
        try {
            return PROPERTIES_MAPPING.find((Object)propertyName);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    static {
        PROPERTIES_MAPPING.put(1, (Object)"beanClassAsIType");
        PROPERTIES_MAPPING.put(2, (Object)"homeInterfaceAsIType");
        PROPERTIES_MAPPING.put(4, (Object)"remoteInterfaceAsIType");
        PROPERTIES_MAPPING.put(8, (Object)"localHomeInterfaceAsIType");
        PROPERTIES_MAPPING.put(16, (Object)"localInterfaceAsIType");
        PROPERTIES_MAPPING.put(32, (Object)"primaryKeyClassAsIType");
    }
}

