/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.utils.RuntimeSupport;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyReader;
import com.tssap.j2ee.internal.core.ejb.providers.ReadOnlyPropertyProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.PropertyUniqueNameProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class EJBFieldUMLNotationProvider
extends AbstractPropertyReader
implements PropertyUniqueNameProvider {
    private static final char COLON = ':';
    private static final char BLANK = ' ';

    public EJBFieldUMLNotationProvider() {
        this.addPropertyName("$uml_representation");
        this.addPropertyName("$short_uml_representation");
    }

    public String getPropertyValue(Element element, String propertyName) {
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if (field == null) {
            return null;
        }
        boolean isShort = "$short_uml_representation".equals(propertyName);
        String fieldName = field.getName();
        StringBuffer result = new StringBuffer();
        if (fieldName == null) {
            result.append("?");
        } else {
            result.append(fieldName);
        }
        String fieldType = field.getType();
        if (fieldType != null) {
            if (isShort) {
                fieldType = org.eclipse.jdt.core.Signature.getSimpleName((String)fieldType);
            }
            result.append(':').append(fieldType);
        }
        return result.toString();
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if (field == null) {
            return false;
        }
        if (ReadOnlyPropertyProvider.isReadOnly(field)) {
            return false;
        }
        Signature sig = this.parse(propertyValue);
        if (sig == null) {
            return false;
        }
        if (sig.myName == null) {
            return element.canSetPropertyValue("$type", sig.myType);
        }
        if (sig.myType == null) {
            return element.canSetPropertyValue("$name", sig.myName);
        }
        return field.canSetSignature(sig.myName, sig.myType);
    }

    public UniqueName setPropertyValue(Element element, String propertyName, String propertyValue) {
        UniqueName uin = element.getUniqueName();
        final IPersistentField field = this.getEJBField(element.getUniqueName());
        final Signature sig = this.parse(propertyValue);
        if (sig.myName == null) {
            element.setPropertyValue("$type", sig.myType);
            return uin;
        }
        if (sig.myType == null) {
            Property property = element.setPropertyValue("$name", sig.myName);
            if (property != null && property.getElement() != null) {
                return property.getElement().getUniqueName();
            }
            return uin;
        }
        final IPersistentField[] resultFieldHolder = new IPersistentField[1];
        try {
            RuntimeSupport.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        resultFieldHolder[0] = field.setSignature(sig.myName, sig.myType, monitor);
                    }
                    catch (EJBModelException eme) {
                        throw new InvocationTargetException(eme);
                    }
                }
            });
            return this.getUniqueName((IEJBElement)resultFieldHolder[0]);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            EjbProvidersPlugin.logWarning("EJBField.setSignature", ce);
            return uin;
        }
    }

    private Signature parse(String propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        if ((propertyValue = propertyValue.trim()).length() == 0) {
            return null;
        }
        int colonIndex = propertyValue.indexOf(58);
        if (colonIndex == -1) {
            return this.parseNonUML(propertyValue);
        }
        int lastColonIndex = propertyValue.lastIndexOf(58);
        if (colonIndex != lastColonIndex) {
            return null;
        }
        return this.parseUML(propertyValue, colonIndex);
    }

    private Signature parseUML(String propertyValue, int colonIndex) {
        String type;
        String name;
        if (colonIndex == propertyValue.length()) {
            name = propertyValue.substring(0, propertyValue.length() - 1);
            type = null;
        } else {
            name = propertyValue.substring(0, colonIndex);
            type = propertyValue.substring(colonIndex + 1);
        }
        name = EJBFieldUMLNotationProvider.nullify(name);
        type = EJBFieldUMLNotationProvider.nullify(type);
        if (name == null && type == null) {
            return null;
        }
        return new Signature(name, type);
    }

    private Signature parseNonUML(String propertyValue) {
        int blankIndex = propertyValue.indexOf(32);
        if (blankIndex == -1) {
            return new Signature(propertyValue, null);
        }
        StringTokenizer tokenizer = new StringTokenizer(propertyValue);
        switch (tokenizer.countTokens()) {
            case 1: {
                return new Signature(tokenizer.nextToken(), null);
            }
            case 2: {
                String type = tokenizer.nextToken();
                return new Signature(tokenizer.nextToken(), type);
            }
        }
        return null;
    }

    private static String nullify(String source) {
        if (source == null) {
            return null;
        }
        String result = source.trim();
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    private static class Signature {
        private String myName;
        private String myType;

        public Signature() {
        }

        public Signature(String name, String type) {
            this.myName = name;
            this.myType = type;
        }
    }
}

