/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.utils.RuntimeSupport;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractPropertyReader;
import com.tssap.j2ee.internal.core.ejb.providers.ReadOnlyPropertyProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.PropertyUniqueNameProvider;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class EJBFieldNameProvider
extends AbstractPropertyReader
implements PropertyUniqueNameProvider {
    public EJBFieldNameProvider() {
        this.addPropertyName("$name");
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String newName) {
        if (newName == null || newName.length() == 0) {
            return false;
        }
        if (ReadOnlyPropertyProvider.isReadOnly(this.getEJBField(element.getUniqueName()))) {
            return newName != null && newName.equals(this.getPropertyValue(element, propertyName));
        }
        if (Character.isUpperCase(newName.charAt(0))) {
            return false;
        }
        IStatus status = JavaConventions.validateFieldName((String)newName);
        if (!status.isOK()) {
            return false;
        }
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if (field == null) {
            return false;
        }
        if (newName.equals(field.getName())) {
            return true;
        }
        try {
            IEntityBean bean = (IEntityBean)field.getParent();
            if (bean.getField(newName) != null) {
                return false;
            }
        }
        catch (EJBModelException e) {
            return false;
        }
        return true;
    }

    public UniqueName setPropertyValue(Element element, String propertyName, final String propertyValue) {
        UniqueName uin = element.getUniqueName();
        final IPersistentField field = this.getEJBField(uin);
        if (field == null) {
            return uin;
        }
        if (propertyValue != null && propertyValue.equals(uin.getName())) {
            return uin;
        }
        final IPersistentField[] resultFieldHolder = new IPersistentField[1];
        try {
            RuntimeSupport.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        resultFieldHolder[0] = field.setName(propertyValue, monitor);
                    }
                    catch (EJBModelException eme) {
                        throw new InvocationTargetException(eme);
                    }
                }
            });
            return this.getUniqueName((IEJBElement)resultFieldHolder[0]);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            EjbProvidersPlugin.logWarning("EJBField.setName", ce);
            return uin;
        }
    }

    public String getPropertyValue(Element element, String propertyName) {
        IPersistentField field = this.getEJBField(element.getUniqueName());
        if (field == null) {
            return null;
        }
        return field.getName();
    }
}

