/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.ICopiedEJBElement;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.ejb.providers.ReadOnlyPropertyProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.CopyProvider;
import com.tssap.selena.model.extension.CutProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.PasteProvider;
import java.util.HashMap;

public class EJBFieldCopyPasteProvider
extends AbstractEJBProvider
implements CopyProvider,
CutProvider,
PasteProvider,
EntityExistenceProvider {
    private HashMap myClipboardUins2Elements;

    public boolean isCopyProviderApplicable(Element element) {
        return EjbModelMetaInfo.isEjbField(element.getUniqueName()) || EjbModelMetaInfo.isRelationLink(element.getUniqueName());
    }

    protected IPersistentField getField(Element element) {
        if (EjbModelMetaInfo.isEjbField(element.getUniqueName())) {
            return this.getEJBField(element.getUniqueName());
        }
        IRelationshipEnd relation = this.getRelation(element.getUniqueName());
        if (relation == null) {
            return null;
        }
        return relation.getCMRField();
    }

    public boolean canCopy(Element element) {
        IPersistentField field = this.getField(element);
        if (field == null) {
            return false;
        }
        return field.canCopy();
    }

    public void copy(Element element, CopyUniqueName copyUniqueName) {
        IPersistentField field = this.getField(element);
        try {
            ICopiedEJBElement copiedField = field.copy();
            this.myClipboardUins2Elements.put(copyUniqueName, copiedField);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to copy field after canCopy returned true", e);
        }
    }

    public boolean isCutProviderApplicable(Element element) {
        return this.isCopyProviderApplicable(element);
    }

    public boolean canCut(Element element) {
        IPersistentField field = this.getField(element);
        if (field == null || ReadOnlyPropertyProvider.isReadOnly(field)) {
            return false;
        }
        return field.canCut();
    }

    public void cut(Element element, CopyUniqueName cutUniqueName) {
        IPersistentField field = this.getField(element);
        try {
            ICopiedEJBElement cut = field.cut();
            this.myClipboardUins2Elements.put(cutUniqueName, cut);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to cut field after canCut returned true", e);
        }
    }

    public boolean isPasteProviderApplicable(Entity container) {
        return EjbModelMetaInfo.isEntityBean(container.getUniqueName());
    }

    public boolean canPaste(Entity container, Element element, Element anchor, boolean before) {
        IEntityBean bean = (IEntityBean)this.getBean(container.getUniqueName());
        ICopiedEJBElement copy = (ICopiedEJBElement)this.myClipboardUins2Elements.get(element.getUniqueName());
        if (copy == null) {
            return false;
        }
        return copy.canPaste((IEJBElement)bean);
    }

    public UniqueName paste(Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        IEntityBean bean = (IEntityBean)this.getBean(container.getUniqueName());
        ICopiedEJBElement copy = (ICopiedEJBElement)this.myClipboardUins2Elements.get(element.getUniqueName());
        try {
            IPersistentField pasted = (IPersistentField)copy.paste((IEJBElement)bean);
            if (pasted instanceof IRelationshipEnd && "com.tssap.j2ee.core.ejb.field.Relation".equals(element.getUniqueName().getSubDomain())) {
                return EjbModelMetaInfo.getRelationLinkUniqueName((IRelationshipEnd)pasted);
            }
            return EjbModelMetaInfo.getUniqueName(pasted);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logError("Exception while pasting", e);
            return null;
        }
    }

    public boolean exists(UniqueName uniqueName) {
        return this.myClipboardUins2Elements.containsKey(uniqueName);
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return element.getUniqueName() instanceof CopyUniqueName;
    }

    public boolean canDelete(Element element) {
        return this.exists(element.getUniqueName());
    }

    public void delete(Element element) {
        ICopiedEJBElement copiedMethod = (ICopiedEJBElement)this.myClipboardUins2Elements.remove(element.getUniqueName());
        try {
            copiedMethod.delete(null);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to clean up the copied field", e);
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public void unregistered(Model model) {
        super.unregistered(model);
        this.myClipboardUins2Elements = null;
    }

    public void registered(Model model) {
        super.registered(model);
        this.myClipboardUins2Elements = new HashMap();
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }
}

