/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.providers.ejb.NewBeanHelper;
import com.tssap.j2ee.core.utils.JdtModelUtils;
import com.tssap.j2ee.core.utils.RuntimeSupport;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class EJBExistenceProvider
extends AbstractEJBProvider
implements EntityExistenceProvider {
    private static final HashMap DEFAULT_NAMES = new HashMap();
    private static final String BEAN_SUFFIX = "Bean";
    private static final String HOME_SUFFIX = "Home";
    private static final String REMOTE_SUFFIX = "";
    private static final String LHOME_SUFFIX = "LocalHome";
    private static final String LOCAL_SUFFIX = "Local";
    private static final String PK_SUFFIX = "PK";
    private static final IntHashMap BEAN_KINDS_TO_SHAPETYPES;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IType;
    static /* synthetic */ Class array$Lorg$eclipse$jdt$core$IType;
    static /* synthetic */ Class class$java$lang$String;

    public boolean exists(UniqueName uniqueName) {
        IEnterpriseBean bean = this.getBean(uniqueName);
        return bean != null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!("com.tssap.j2ee.core.ejb.EntityBean".equals(shapeType) || "com.tssap.j2ee.core.ejb.SessionBean".equals(shapeType) || "com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(shapeType))) {
            return false;
        }
        if (!this.validateObjectProperty(template, "beanSuperclass", class$org$eclipse$jdt$core$IType == null ? (class$org$eclipse$jdt$core$IType = EJBExistenceProvider.class$("org.eclipse.jdt.core.IType")) : class$org$eclipse$jdt$core$IType)) {
            return false;
        }
        if (!this.validateObjectProperty(template, "beanSuperinterfaces", array$Lorg$eclipse$jdt$core$IType == null ? (array$Lorg$eclipse$jdt$core$IType = EJBExistenceProvider.class$("[Lorg.eclipse.jdt.core.IType;")) : array$Lorg$eclipse$jdt$core$IType)) {
            return false;
        }
        if (!this.validateObjectProperty(template, "homeSuperinterfaces", array$Lorg$eclipse$jdt$core$IType == null ? (array$Lorg$eclipse$jdt$core$IType = EJBExistenceProvider.class$("[Lorg.eclipse.jdt.core.IType;")) : array$Lorg$eclipse$jdt$core$IType)) {
            return false;
        }
        if (!this.validateObjectProperty(template, "remoteSuperinterfaces", array$Lorg$eclipse$jdt$core$IType == null ? (array$Lorg$eclipse$jdt$core$IType = EJBExistenceProvider.class$("[Lorg.eclipse.jdt.core.IType;")) : array$Lorg$eclipse$jdt$core$IType)) {
            return false;
        }
        if (!this.validateObjectProperty(template, "localhomeSuperinterfaces", array$Lorg$eclipse$jdt$core$IType == null ? (array$Lorg$eclipse$jdt$core$IType = EJBExistenceProvider.class$("[Lorg.eclipse.jdt.core.IType;")) : array$Lorg$eclipse$jdt$core$IType)) {
            return false;
        }
        if (!this.validateObjectProperty(template, "localSuperinterfaces", array$Lorg$eclipse$jdt$core$IType == null ? (array$Lorg$eclipse$jdt$core$IType = EJBExistenceProvider.class$("[Lorg.eclipse.jdt.core.IType;")) : array$Lorg$eclipse$jdt$core$IType)) {
            return false;
        }
        if (!JdtModelUtils.isWritablePackage((Element)parent)) {
            return false;
        }
        return !(parent instanceof Model);
    }

    private boolean validateObjectProperty(Entity template, String propertyName, Class expectedClass) {
        if (template == null) {
            return true;
        }
        Object propertyValue = template.getObjectPropertyValue(propertyName);
        if (propertyValue == null) {
            return true;
        }
        return expectedClass.isInstance(propertyValue);
    }

    public UniqueName createUniqueName(Entity parent, final String shapeType, Entity template) {
        IType[] localSuper;
        IType[] localHomeSuper;
        IType[] remoteSuper;
        IType[] homeSuper;
        boolean simplePK;
        String pkFQN;
        String localHomeFQN;
        String localFQN;
        String remoteFQN;
        String homeFQN;
        boolean byClone;
        boolean bl = byClone = template != null && template.getObjectPropertyValue("$elementToClone") != null;
        if (byClone) {
            template = null;
        }
        IPackageFragment packageFragment = JdtModelUtils.getPackage((Element)parent);
        String beanClassBaseName = null;
        String beanClassName = null;
        if (template != null) {
            beanClassName = template.getPropertyValue("beanClass");
        }
        if (beanClassName == null) {
            beanClassBaseName = this.getDefaultUnusedBaseBeanName(packageFragment, shapeType);
            beanClassName = beanClassBaseName + BEAN_SUFFIX;
            homeFQN = beanClassBaseName + HOME_SUFFIX;
            remoteFQN = beanClassBaseName + REMOTE_SUFFIX;
            localFQN = beanClassBaseName + LOCAL_SUFFIX;
            localHomeFQN = beanClassBaseName + LHOME_SUFFIX;
            pkFQN = "java.lang.String";
        } else {
            homeFQN = template.getPropertyValue("homeInterface");
            remoteFQN = template.getPropertyValue("remoteInterface");
            localHomeFQN = template.getPropertyValue("localHomeInterface");
            localFQN = template.getPropertyValue("localInterface");
            String pk = template.getPropertyValue("primaryKeyClass");
            pkFQN = pk == null ? (class$java$lang$String == null ? (class$java$lang$String = EJBExistenceProvider.class$("java.lang.String")) : class$java$lang$String).getName() : pk;
        }
        final boolean cmp = template == null ? "com.tssap.j2ee.core.ejb.EntityBean".equals(shapeType) : template.hasPropertyValue("cmp", Boolean.TRUE.toString());
        boolean bl2 = simplePK = template == null ? "com.tssap.j2ee.core.ejb.EntityBean".equals(shapeType) : template.hasProperty("$simplePK");
        boolean stateless = template == null ? "com.tssap.j2ee.core.ejb.SessionBean".equals(shapeType) : !template.hasProperty("$ejbStateful");
        final String beanClassFQN = beanClassName;
        final Map properties = this.createProperties(this.getBeanKind(shapeType), homeFQN, remoteFQN, localHomeFQN, localFQN, pkFQN, simplePK, stateless, cmp);
        if (template != null) {
            this.copyObjectProperty(properties, template, "beanSuperclass");
            this.copyObjectProperty(properties, template, "beanSuperinterfaces");
            homeSuper = (IType[])template.getObjectPropertyValue("homeSuperinterfaces");
            remoteSuper = (IType[])template.getObjectPropertyValue("remoteSuperinterfaces");
            localHomeSuper = (IType[])template.getObjectPropertyValue("localhomeSuperinterfaces");
            localSuper = (IType[])template.getObjectPropertyValue("localSuperinterfaces");
        } else {
            localSuper = null;
            localHomeSuper = null;
            remoteSuper = null;
            homeSuper = null;
        }
        final IEnterpriseBean[] ejbHolder = new IEnterpriseBean[1];
        try {
            RuntimeSupport.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block7: {
                        try {
                            if ("com.tssap.j2ee.core.ejb.EntityBean".equals(shapeType)) {
                                IEntityBean result = EJBExistenceProvider.this.getEJBProject().createEntityBean(beanClassFQN, properties, monitor);
                                ejbHolder[0] = result;
                                this.createInterfaces(monitor);
                                this.createPK(monitor);
                                if (result != null) {
                                    result.setCMP(cmp);
                                    if (cmp) {
                                        result.setSimplePK(simplePK);
                                    }
                                }
                                break block7;
                            }
                            if ("com.tssap.j2ee.core.ejb.SessionBean".equals(shapeType)) {
                                ejbHolder[0] = EJBExistenceProvider.this.getEJBProject().createSessionBean(beanClassFQN, properties, monitor);
                                this.createInterfaces(monitor);
                                break block7;
                            }
                            if ("com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(shapeType)) {
                                ejbHolder[0] = EJBExistenceProvider.this.getEJBProject().createMessageDrivenBean(beanClassFQN, properties, monitor);
                                break block7;
                            }
                            throw new RuntimeException("Unknown shape type in ejb creation procedure: " + shapeType);
                        }
                        catch (CoreException ce) {
                            throw new InvocationTargetException(ce);
                        }
                    }
                }

                private void createInterfaces(IProgressMonitor monitor) throws CoreException {
                    if (ejbHolder[0] == null) {
                        return;
                    }
                    IAccessibleBean ejb = (IAccessibleBean)ejbHolder[0];
                    if (homeFQN != null) {
                        ejb.addParticipant(2, homeFQN, true, homeSuper, monitor);
                    }
                    if (remoteFQN != null) {
                        ejb.addParticipant(4, remoteFQN, true, remoteSuper, monitor);
                    }
                    if (localHomeFQN != null) {
                        ejb.addParticipant(8, localHomeFQN, true, localHomeSuper, monitor);
                    }
                    if (localFQN != null) {
                        ejb.addParticipant(16, localFQN, true, localSuper, monitor);
                    }
                }

                private void createPK(IProgressMonitor monitor) throws CoreException {
                    if (ejbHolder[0] == null) {
                        return;
                    }
                    IEntityBean ejb = (IEntityBean)ejbHolder[0];
                    if (pkFQN != null) {
                        ejb.addParticipant(32, pkFQN, true, null, monitor);
                    }
                }
            });
        }
        catch (CoreException ce) {
            System.err.println("Unable to create enterprise bean: " + (Object)((Object)ce));
            ce.printStackTrace();
            return null;
        }
        UniqueName uniqueName = this.getUniqueName((IEJBElement)ejbHolder[0]);
        if (byClone) {
            NewBeanHelper.configureBean(this.getModel().findEntity(uniqueName));
        }
        return uniqueName;
    }

    private void copyObjectProperty(Map map, Entity template, String propertyName) {
        map.put(propertyName, template.getObjectPropertyValue(propertyName));
    }

    private int getBeanKind(String shapeType) {
        try {
            return BEAN_KINDS_TO_SHAPETYPES.find((Object)shapeType);
        }
        catch (NoSuchElementException e) {
            return -1;
        }
    }

    private Map createProperties(int beanKind, String homeFQN, String remoteFQN, String localHomeFQN, String localFQN, String pkFQN, boolean simplePK, boolean stateless, boolean cmp) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (beanKind == 1 || beanKind == 2) {
            result.put("home", homeFQN);
            result.put("remote", remoteFQN);
            result.put("localHome", localHomeFQN);
            result.put("local", localFQN);
        }
        if (beanKind == 1) {
            result.put("primaryKey", pkFQN);
            result.put("simplePK", simplePK ? REMOTE_SUFFIX : null);
            result.put("CMP", cmp ? REMOTE_SUFFIX : null);
        }
        if (beanKind == 2) {
            result.put("defaultStateless", stateless ? REMOTE_SUFFIX : null);
        }
        return result;
    }

    private String getDefaultUnusedBaseBeanName(IPackageFragment packageFragment, String shapeType) {
        boolean isMDB;
        String defaultName = EJBExistenceProvider.getBaseName(shapeType);
        String defaultFQN = packageFragment.isDefaultPackage() ? defaultName : packageFragment.getElementName() + '.' + defaultName;
        IJavaProject project = packageFragment.getJavaProject();
        if (!this.anyComponentExists(project, defaultFQN, isMDB = "com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(shapeType))) {
            return defaultFQN;
        }
        int i = 1;
        String fqn;
        while (this.anyComponentExists(project, fqn = defaultFQN + i, isMDB)) {
            ++i;
        }
        return fqn;
    }

    private boolean anyComponentExists(IJavaProject project, String fqn, boolean isMDB) {
        String baseName = fqn;
        if (JDTUtils.findType((IJavaProject)project, (String)(baseName + BEAN_SUFFIX)) != null) {
            return true;
        }
        if (isMDB) {
            return false;
        }
        if (JDTUtils.findType((IJavaProject)project, (String)(baseName + REMOTE_SUFFIX)) != null) {
            return true;
        }
        if (JDTUtils.findType((IJavaProject)project, (String)(baseName + HOME_SUFFIX)) != null) {
            return true;
        }
        if (JDTUtils.findType((IJavaProject)project, (String)(baseName + LHOME_SUFFIX)) != null) {
            return true;
        }
        if (JDTUtils.findType((IJavaProject)project, (String)(baseName + LOCAL_SUFFIX)) != null) {
            return true;
        }
        return JDTUtils.findType((IJavaProject)project, (String)(baseName + PK_SUFFIX)) != null;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return "com.tssap.j2ee.core.ejb".equals(element.getUniqueName().getDomain());
    }

    public boolean canDelete(Element element) {
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (bean == null) {
            return false;
        }
        if (bean.getBeanClass() == null) {
            return true;
        }
        return !bean.getBeanClass().isReadOnly();
    }

    public void delete(Element element) {
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        try {
            bean.delete(null);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to delete bean", e);
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    private static String getBaseName(String shapeType) {
        return (String)DEFAULT_NAMES.get(shapeType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String name = "MyDefault";
        DEFAULT_NAMES.put("com.tssap.j2ee.core.ejb.EntityBean", name);
        DEFAULT_NAMES.put("com.tssap.j2ee.core.ejb.SessionBean", name);
        DEFAULT_NAMES.put("com.tssap.j2ee.core.ejb.MessageDrivenBean", name);
        BEAN_KINDS_TO_SHAPETYPES = new IntHashMap();
        BEAN_KINDS_TO_SHAPETYPES.put(1, (Object)"com.tssap.j2ee.core.ejb.EntityBean");
        BEAN_KINDS_TO_SHAPETYPES.put(2, (Object)"com.tssap.j2ee.core.ejb.SessionBean");
        BEAN_KINDS_TO_SHAPETYPES.put(4, (Object)"com.tssap.j2ee.core.ejb.MessageDrivenBean");
    }
}

