/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.ICopiedEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.core.utils.JdtModelUtils;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.CopyProvider;
import com.tssap.selena.model.extension.CutProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.PasteProvider;
import java.util.HashMap;
import org.eclipse.jdt.core.IPackageFragment;

public class EJBCopyPasteProvider
extends AbstractEJBProvider
implements CutProvider,
CopyProvider,
PasteProvider,
EntityExistenceProvider {
    private HashMap myClipboardUins2Elements;

    public boolean isCutProviderApplicable(Element element) {
        return true;
    }

    public boolean canCut(Element element) {
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (bean == null) {
            return false;
        }
        return bean.canCut(false);
    }

    public void cut(Element element, CopyUniqueName cutUniqueName) {
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        try {
            ICopiedEnterpriseBean copiedBean = bean.cut(false);
            this.myClipboardUins2Elements.put(cutUniqueName, copiedBean);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to cut bean after canCut returned true", e);
        }
    }

    public boolean isCopyProviderApplicable(Element element) {
        return true;
    }

    public boolean canCopy(Element element) {
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        if (bean == null) {
            return false;
        }
        return bean.canCopy(false);
    }

    public void copy(Element element, CopyUniqueName copyUniqueName) {
        IEnterpriseBean bean = this.getBean(element.getUniqueName());
        try {
            ICopiedEnterpriseBean copiedBean = bean.copy(false);
            this.myClipboardUins2Elements.put(copyUniqueName, copiedBean);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Failed to copy bean after canCopy returned true", e);
        }
    }

    public boolean isPasteProviderApplicable(Entity container) {
        return true;
    }

    public boolean canPaste(Entity container, Element element, Element anchor, boolean before) {
        IPackageFragment pf = JdtModelUtils.getPackage((Element)container);
        if (pf == null) {
            return false;
        }
        UniqueName pasteUin = element.getUniqueName();
        ICopiedEnterpriseBean copy = (ICopiedEnterpriseBean)this.myClipboardUins2Elements.get(pasteUin);
        return copy != null && copy.canPaste(pf);
    }

    public UniqueName paste(Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        IPackageFragment pf = JdtModelUtils.getPackage((Element)container);
        UniqueName pasteUin = element.getUniqueName();
        ICopiedEnterpriseBean copy = (ICopiedEnterpriseBean)this.myClipboardUins2Elements.get(pasteUin);
        try {
            IEnterpriseBean result = copy.paste(pf);
            if (result == null) {
                return null;
            }
            return EjbModelMetaInfo.getUniqueName(result);
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return this.myClipboardUins2Elements.containsKey(uniqueName);
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return element.getUniqueName() instanceof CopyUniqueName;
    }

    public boolean canDelete(Element element) {
        return this.exists(element.getUniqueName());
    }

    public void delete(Element element) {
        ICopiedEnterpriseBean copiedBean = (ICopiedEnterpriseBean)this.myClipboardUins2Elements.remove(element.getUniqueName());
        try {
            copiedBean.delete(null);
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logWarning("Could not clean up the copied bean", e);
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public void unregistered(Model model) {
        super.unregistered(model);
        this.myClipboardUins2Elements = null;
    }

    public void registered(Model model) {
        super.registered(model);
        this.myClipboardUins2Elements = new HashMap();
    }
}

