/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbMetaInfo;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.ICreateMethod;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IMessageDrivenBean;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.core.utils.RuntimeSupport;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBMethodCreator;
import com.tssap.j2ee.internal.core.ejb.providers.EJBMethodParametersUtils;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CreateMethodCreatorProvider
extends AbstractEJBMethodCreator
implements EntityExistenceProvider {
    public boolean exists(UniqueName uniqueName) {
        return false;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return false;
    }

    public boolean canDelete(Element element) {
        return false;
    }

    public void delete(Element element) {
    }

    public boolean isDeleted(Element element) {
        return true;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        String[] parameters;
        if (!"com.tssap.j2ee.core.ejb.method.Create".equals(shapeType)) {
            return false;
        }
        IEnterpriseBean bean = this.getBean(parent.getUniqueName());
        if (bean == null || bean.getBeanClass() == null) {
            return false;
        }
        if (this.isAnyPartReadOnly(bean, 2)) {
            return false;
        }
        if (!this.participantPairsConsistent(bean) || this.pkMissing(bean)) {
            return false;
        }
        boolean noSuffixAllowed = this.noSuffixAllowed(parent);
        boolean noParametersAllowed = this.noParametersAllowed(parent);
        if (template == null) {
            return !noParametersAllowed || !noSuffixAllowed || !this.hasEjbCreateWithoutParameters(bean);
        }
        String name = template.getPropertyValue("$name");
        if (noSuffixAllowed && name != null && name.length() != 0) {
            return false;
        }
        String fullName = EjbMetaInfo.getCreateMethodImplName((String)name);
        if (!JavaConventions.validateMethodName((String)fullName).isOK()) {
            return false;
        }
        try {
            this.getExceptions(template);
            parameters = this.getParameterTypes(template);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (parameters != null && parameters.length != 0 && noParametersAllowed) {
            return false;
        }
        if (parameters == null) {
            return true;
        }
        return true;
    }

    private String[] getParameterTypes(Entity template) throws IllegalArgumentException {
        Object paramsWithNameCandidate = template.getObjectPropertyValue("parameterNameArray");
        if (paramsWithNameCandidate != null) {
            if (!(paramsWithNameCandidate instanceof String[])) {
                throw new IllegalArgumentException();
            }
            String[] paramsWithName = (String[])paramsWithNameCandidate;
            if (!EJBMethodParametersUtils.isValidTypesAndNames(paramsWithName)) {
                throw new IllegalArgumentException();
            }
            return EJBMethodParametersUtils.extractParameterTypes(paramsWithName);
        }
        Object paramsWithoutNameCandidate = template.getObjectPropertyValue("parameterArray");
        if (paramsWithoutNameCandidate == null) {
            return null;
        }
        if (!(paramsWithoutNameCandidate instanceof String[])) {
            throw new IllegalArgumentException();
        }
        String[] paramsWithoutName = (String[])paramsWithoutNameCandidate;
        if (!EJBMethodParametersUtils.isValidTypes(paramsWithoutName)) {
            throw new IllegalArgumentException();
        }
        return paramsWithoutName;
    }

    private String[] getParameterNames(Entity template) throws IllegalArgumentException {
        Object paramsWithNameCandidate = template.getObjectPropertyValue("parameterNameArray");
        if (paramsWithNameCandidate != null) {
            if (!(paramsWithNameCandidate instanceof String[])) {
                throw new IllegalArgumentException();
            }
            String[] paramsWithName = (String[])paramsWithNameCandidate;
            if (!EJBMethodParametersUtils.isValidTypesAndNames(paramsWithName)) {
                throw new IllegalArgumentException();
            }
            return EJBMethodParametersUtils.extractParameterNames(paramsWithName);
        }
        return null;
    }

    private String[] getExceptions(Entity template) throws IllegalArgumentException {
        if (template == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Object exceptionsCandidate = template.getObjectPropertyValue("exceptionArray");
        if (exceptionsCandidate == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (!(exceptionsCandidate instanceof String[])) {
            throw new IllegalArgumentException();
        }
        String[] exceptions = (String[])exceptionsCandidate;
        if (!EJBMethodParametersUtils.isValidTypes(exceptions)) {
            throw new IllegalArgumentException();
        }
        return exceptions;
    }

    private boolean noSuffixAllowed(Entity parent) {
        String metaclass = parent.getPropertyValue("$metaclass");
        if ("com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(metaclass)) {
            return true;
        }
        if ("com.tssap.j2ee.core.ejb.SessionBean".equals(metaclass) && !parent.hasProperty("$ejbStateful")) {
            return true;
        }
        return parent.hasProperty("ejbVersion1_X");
    }

    private boolean noParametersAllowed(Entity parent) {
        String metaclass = parent.getPropertyValue("$metaclass");
        if ("com.tssap.j2ee.core.ejb.MessageDrivenBean".equals(metaclass)) {
            return true;
        }
        return "com.tssap.j2ee.core.ejb.SessionBean".equals(metaclass) && !parent.hasProperty("$ejbStateful");
    }

    private boolean hasEjbCreateWithoutParameters(IEnterpriseBean bean) {
        return this.hasEjbCreateMethod(bean, "ejbCreate", ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private boolean hasEjbCreateMethod(IEnterpriseBean bean, String methodName, String[] parameterTypes) {
        try {
            IEJBMethod method = bean.getEJBMethodByJavaTypes(methodName, parameterTypes);
            return method != null && method.exists();
        }
        catch (EJBModelException e) {
            return false;
        }
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        IEnterpriseBean bean = this.getBean(parent.getUniqueName());
        boolean noSuffixAllowed = this.noSuffixAllowed(parent);
        boolean noParametersAllowed = this.noParametersAllowed(parent);
        String[] exceptions = this.getExceptions(template);
        if (template == null) {
            return this.createCreateMethodForNullTemplate(bean, noSuffixAllowed, noParametersAllowed, exceptions);
        }
        String name = template.getPropertyValue("$name");
        String[] parameters = this.getParameterTypes(template);
        if (parameters == null) {
            if (name == null) {
                return this.createCreateMethodForNullTemplate(bean, noSuffixAllowed, noParametersAllowed, exceptions);
            }
            return this.createMethodWithArbitraryParams((IAccessibleBean)bean, name, exceptions);
        }
        String[] parameterNames = this.getParameterNames(template);
        if (bean.getKind() == 4) {
            if (name != null && name.length() > 0 || parameters != null && parameters.length > 0) {
                return null;
            }
            return this.createCreateMethodForMDB((IMessageDrivenBean)bean);
        }
        return this.createCreateMethod((IAccessibleBean)bean, name, parameters, parameterNames, exceptions);
    }

    private UniqueName createCreateMethodForNullTemplate(IEnterpriseBean bean, boolean noSuffixAllowed, boolean noParametersAllowed, String[] exceptions) {
        if (noParametersAllowed) {
            if (bean instanceof IMessageDrivenBean) {
                return this.createCreateMethodForMDB((IMessageDrivenBean)bean);
            }
            return this.createCreateMethod((IAccessibleBean)bean, "", ArrayUtils.EMPTY_STRING_ARRAY, ArrayUtils.EMPTY_STRING_ARRAY, exceptions);
        }
        if (noSuffixAllowed) {
            return this.createEjbCreateMethodWithoutSuffix((IAccessibleBean)bean);
        }
        return this.createEjbCreateMethodWithoutParams((IAccessibleBean)bean);
    }

    private UniqueName createCreateMethodForMDB(IMessageDrivenBean bean) {
        try {
            ICreateMethod result = bean.createCreateMethod();
            if (result != null) {
                return EjbModelMetaInfo.getUniqueName((IEJBMethod)result);
            }
        }
        catch (EJBModelException e) {
            EjbProvidersPlugin.logError("Exception while creating create method", e);
        }
        return null;
    }

    private UniqueName createEjbCreateMethodWithoutSuffix(IAccessibleBean bean) {
        return this.createMethodWithArbitraryParams(bean, "", ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private UniqueName createMethodWithArbitraryParams(IAccessibleBean bean, String userName, String[] exceptions) {
        String baseName = EjbMetaInfo.getCreateMethodImplName((String)userName);
        ArrayList<String> intsHolder = new ArrayList<String>();
        String[] params;
        while (this.hasEjbCreateMethod((IEnterpriseBean)bean, baseName, params = intsHolder.toArray(new String[intsHolder.size()]))) {
            intsHolder.add("int");
        }
        return this.createCreateMethod(bean, userName, params, null, exceptions);
    }

    private UniqueName createEjbCreateMethodWithoutParams(IAccessibleBean bean) {
        int i = 0;
        while (true) {
            String name;
            String string = name = i == 0 ? "ejbCreate" : "ejbCreate" + i;
            if (!this.hasEjbCreateMethod((IEnterpriseBean)bean, name, ArrayUtils.EMPTY_STRING_ARRAY)) {
                return this.createCreateMethod(bean, i == 0 ? "" : String.valueOf(i), ArrayUtils.EMPTY_STRING_ARRAY, ArrayUtils.EMPTY_STRING_ARRAY, ArrayUtils.EMPTY_STRING_ARRAY);
            }
            ++i;
        }
    }

    private UniqueName createCreateMethod(final IAccessibleBean bean, final String userMethodName, String[] types, final String[] names, final String[] exceptions) {
        final String[] finalTypes = this.addQualificationToTypes(bean.getBeanClass(), types);
        final IEJBMethod[] methodHolder = new IEJBMethod[1];
        try {
            RuntimeSupport.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        methodHolder[0] = CreateMethodCreatorProvider.this.reuseExistingMethod(bean, EjbMetaInfo.getCreateMethodImplName((String)userMethodName), finalTypes);
                        if (methodHolder[0] == null) {
                            methodHolder[0] = bean.createCreateMethod(userMethodName, finalTypes, names, exceptions, monitor);
                        }
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
            });
        }
        catch (CoreException ce) {
            EjbProvidersPlugin.logError("Unable to create ejb method", ce);
            return null;
        }
        return this.getUniqueName((IEJBElement)methodHolder[0]);
    }
}

