/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.core.providers.ejb.EjbModelMetaInfo;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.selena.internal.core.providers.java.NameUtil;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.extension.Provider;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.providers.resources.RootRelativePath;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public abstract class AbstractEJBProvider
implements ModelAware,
Provider {
    private Model myModel;
    private EjbProject myEJBProject;

    public void registered(Model model) {
        this.myModel = model;
        IProject project = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
        this.myEJBProject = EjbProject.getInstance((IProject)project);
    }

    public void unregistered(Model model) {
        this.myModel = null;
        this.myEJBProject = null;
    }

    protected EjbProject getEJBProject() {
        return this.myEJBProject;
    }

    protected IJavaProject getJavaProject() {
        return this.getEJBProject().getJavaProject();
    }

    protected Model getModel() {
        return this.myModel;
    }

    protected UniqueName getUniqueName(IEJBElement element) {
        return EjbModelMetaInfo.getUniqueName(element);
    }

    protected IEnterpriseBean getBean(UniqueName beanUin) {
        String beanClassFQN;
        if (!"com.tssap.j2ee.core.ejb".equals(beanUin.getDomain())) {
            return null;
        }
        if (beanUin.getParametersCount() != 0) {
            return null;
        }
        String beanClassName = beanUin.getName();
        String packageName = beanUin.getLocation();
        if (packageName == null || packageName.length() == 0) {
            packageName = "";
            beanClassFQN = beanClassName;
        } else {
            beanClassFQN = packageName + '.' + beanClassName;
        }
        try {
            IEnterpriseBean result = this.getEJBProject().getEnterpriseBean(beanClassFQN);
            if (result == null) {
                return null;
            }
            int kind = EjbModelMetaInfo.getKindForMetaclass(beanUin.getSubDomain());
            if (result.getKind() == kind) {
                return result;
            }
            return null;
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    protected IEJBMethod getEJBMethod(UniqueName uniqueName) {
        if (!"com.tssap.j2ee.core.ejb.method".equals(uniqueName.getDomain())) {
            return null;
        }
        try {
            String[] parameters;
            IEnterpriseBean bean = this.getEJBProject().getEnterpriseBean(uniqueName.getLocation());
            if (bean == null) {
                return null;
            }
            String name = uniqueName.getName();
            IEJBMethod method = bean.getEJBMethodByJavaTypes(name, parameters = AbstractEJBProvider.getParameters(uniqueName));
            if (method == null) {
                return null;
            }
            if (method.getKind() == EjbModelMetaInfo.getMethodKind(uniqueName.getSubDomain())) {
                return method;
            }
            return null;
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    protected static String[] getParameters(UniqueName uniqueName) {
        return EjbModelMetaInfo.getParameters(uniqueName);
    }

    public IPersistentField getEJBField(UniqueName uniqueName) {
        if (!"com.tssap.j2ee.core.ejb.field".equals(uniqueName.getDomain())) {
            return null;
        }
        if (!"com.tssap.j2ee.core.ejb.field.Persistent".equals(uniqueName.getSubDomain())) {
            return null;
        }
        IType beanClass = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)uniqueName.getLocation());
        if (beanClass == null) {
            return null;
        }
        try {
            IEnterpriseBean bean = this.getEJBProject().getEnterpriseBean(uniqueName.getLocation());
            if (!(bean instanceof IEntityBean)) {
                return null;
            }
            IEntityBean entityBean = (IEntityBean)bean;
            String name = uniqueName.getName();
            return entityBean.getField(name);
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    public IRelationshipEnd getRelation(UniqueName uniqueName) {
        if (!"com.tssap.j2ee.core.ejb.field".equals(uniqueName.getDomain())) {
            return null;
        }
        if (!"com.tssap.j2ee.core.ejb.field.Relation".equals(uniqueName.getSubDomain())) {
            return null;
        }
        IType beanClass = JDTUtils.findType((IJavaProject)this.getEJBProject().getJavaProject(), (String)uniqueName.getLocation());
        if (beanClass == null) {
            return null;
        }
        try {
            IEnterpriseBean bean = this.getEJBProject().getEnterpriseBean(uniqueName.getLocation());
            if (!(bean instanceof IEntityBean)) {
                return null;
            }
            IEntityBean entityBean = (IEntityBean)bean;
            String name = uniqueName.getName();
            return entityBean.getRelationship(name);
        }
        catch (EJBModelException e) {
            return null;
        }
    }

    protected UniqueName getParentUniqueName(IEJBElement element) {
        if (element instanceof IEnterpriseBean) {
            return this.getParentUniqueName((IEnterpriseBean)element);
        }
        return this.getUniqueName(element.getParent());
    }

    protected UniqueName getParentUniqueName(IEnterpriseBean bean) {
        IType beanClass = bean.getBeanClass();
        if (beanClass != null) {
            IPackageFragment fragment = beanClass.getPackageFragment();
            return NameUtil.getJavaElementUniqueName((IJavaProject)this.getJavaProject(), (IJavaElement)fragment);
        }
        String beanPackage = AbstractEJBProvider.getPackageName(bean.getBeanClassName());
        beanPackage = beanPackage.replace('.', '/');
        return RootManagerAccess.getRootManager((IProject)this.getEJBProject().getProject()).getUniqueName((IRootRelativePath)RootRelativePath.valueOf((String)beanPackage));
    }

    private static String getPackageName(String typeFQN) {
        int lastDotIndex = typeFQN.lastIndexOf(46);
        return lastDotIndex == -1 ? "" : typeFQN.substring(0, lastDotIndex);
    }

    protected boolean isReadOnly(IType type, boolean naive) {
        if (type.isBinary()) {
            return true;
        }
        if (naive) {
            return false;
        }
        IResource resource = type.getCompilationUnit().getResource();
        if (resource instanceof IFile && resource.isReadOnly()) {
            resource.getWorkspace().validateEdit(new IFile[]{(IFile)resource}, null);
            return resource.isReadOnly();
        }
        return false;
    }
}

