/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb.providers;

import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.utils.ArrayUtils;
import com.tssap.j2ee.internal.core.ejb.providers.AbstractEJBProvider;
import com.tssap.j2ee.internal.core.ejb.util.JDTUtils;
import com.tssap.j2ee.internal.core.providers.ejb.EjbProvidersPlugin;
import org.eclipse.jdt.core.IType;

public class AbstractEJBMethodCreator
extends AbstractEJBProvider {
    protected IEJBMethod reuseExistingMethod(IAccessibleBean bean, String fullMethodName, String[] types) {
        IEJBMethod ejbMethod;
        try {
            ejbMethod = bean.getEJBMethodByJavaTypes(fullMethodName, types);
        }
        catch (EJBModelException e) {
            ejbMethod = null;
        }
        if (ejbMethod == null || !ejbMethod.exists()) {
            return null;
        }
        int i = 1;
        while (i <= 64) {
            if (ejbMethod.canPromote(i)) {
                try {
                    ejbMethod.promote(i);
                }
                catch (EJBModelException e) {
                    EjbProvidersPlugin.logError("Exception while promoting existing method", e);
                }
            }
            i <<= 1;
        }
        return ejbMethod;
    }

    protected boolean isAnyPartReadOnly(IEnterpriseBean bean, int methodKind, boolean naive) {
        return this.isAnyPartReadOnly(bean, methodKind);
    }

    protected boolean isAnyPartReadOnly(IEnterpriseBean bean, int methodKind) {
        if (bean.getKind() == 4) {
            return bean.getBeanClass().isBinary();
        }
        IAccessibleBean aBean = (IAccessibleBean)bean;
        int requiredParticipants = this.getRequiredParticipants(aBean, methodKind);
        try {
            int i = 1;
            while (i <= requiredParticipants) {
                IType type;
                if ((i & requiredParticipants) > 0 && (type = aBean.getParticipant(i)) != null && type.exists() && type.isBinary()) {
                    return true;
                }
                i <<= 1;
            }
            return false;
        }
        catch (EJBModelException e) {
            return true;
        }
    }

    private int getRequiredParticipants(IAccessibleBean bean, int methodKind) {
        switch (methodKind) {
            case 1: {
                return 21;
            }
            case 2: 
            case 8: {
                return 11;
            }
            case 16: {
                return 1;
            }
            case 4: {
                try {
                    if (((IEntityBean)bean).isCMP()) {
                        return 10;
                    }
                    return 11;
                }
                catch (EJBModelException eJBModelException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    protected boolean participantPairsConsistent(IEnterpriseBean bean) {
        if (bean.getKind() == 4) {
            return true;
        }
        IAccessibleBean aBean = (IAccessibleBean)bean;
        try {
            IType home = aBean.getParticipant(2);
            if (home != null && aBean.getParticipant(4) == null) {
                return false;
            }
            IType localhome = aBean.getParticipant(8);
            return localhome == null || aBean.getParticipant(16) != null;
        }
        catch (EJBModelException e) {
            return false;
        }
    }

    protected boolean pkMissing(IEnterpriseBean bean) {
        if (bean.getKind() != 1) {
            return false;
        }
        try {
            return ((IAccessibleBean)bean).getParticipant(32) == null;
        }
        catch (EJBModelException e) {
            return true;
        }
    }

    protected String[] addQualificationToTypes(IType context, String[] types) {
        if (types == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[types.length];
        int i = 0;
        while (i < types.length) {
            result[i] = JDTUtils.getFQN((IType)context, (String)types[i]);
            ++i;
        }
        return result;
    }
}

