/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.providers.ejb;

import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.internal.core.ejb.util.IntHashMap;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.IProject;

public class EjbModelMetaInfo {
    public static final String EJB_NATURE_ID = "com.tssap.j2ee.core.ejb.ejbNature";
    public static final String REFRESH_HIERARCHY = "$refreshHierarchy";
    public static final String BEAN_CLASS_PROPERTY = "beanClass";
    public static final String HOME_INTERFACE_PROPERTY = "homeInterface";
    public static final String REMOTE_INTERFACE_PROPERTY = "remoteInterface";
    public static final String LOCAL_HOME_INTERFACE_PROPERTY = "localHomeInterface";
    public static final String LOCAL_INTERFACE_PROPERTY = "localInterface";
    public static final String PRIMARY_KEY_CLASS_PROPERTY = "primaryKeyClass";
    public static final String RENAME_SUFFIX = "Rename";
    public static final String RENAME_HOME_INTERFACE_PROPERTY = "homeInterfaceRename";
    public static final String RENAME_REMOTE_INTERFACE_PROPERTY = "remoteInterfaceRename";
    public static final String RENAME_LOCAL_HOME_INTERFACE_PROPERTY = "localHomeInterfaceRename";
    public static final String RENAME_LOCAL_INTERFACE_PROPERTY = "localInterfaceRename";
    public static final String RENAME_PRIMARY_KEY_CLASS_PROPERTY = "primaryKeyClassRename";
    public static final String BEAN_SUPERCLASS = "beanSuperclass";
    public static final String BEAN_SUPERINTERFACES = "beanSuperinterfaces";
    public static final String HOME_SUPERINTERFACES = "homeSuperinterfaces";
    public static final String REMOTE_SUPERINTERFACES = "remoteSuperinterfaces";
    public static final String LOCAL_HOME_SUPERINTERFACES = "localhomeSuperinterfaces";
    public static final String LOCAL_SUPERINTERFACES = "localSuperinterfaces";
    public static final String CMP = "cmp";
    public static final String SIMPLE_PK = "$simplePK";
    public static final String COMPOUND_PK_TYPE = "$compoundPKType";
    public static final String IMPORTED = "imported";
    public static final String STATEFUL = "$ejbStateful";
    public static final String VERSION_1_X = "cmpVersion1_X";
    public static final String VERSION_2_X = "cmpVersion2_X";
    public static final String EJB_VERSION_1_X = "ejbVersion1_X";
    public static final String EJB_VERSION_2_X = "ejbVersion2_X";
    public static final String CONSTITUENT_TYPES_PROPERTY = "constituentTypes";
    public static final String BEAN_CLASS_OBJ_PROPERTY = "beanClassAsIType";
    public static final String HOME_INTERFACE_OBJ_PROPERTY = "homeInterfaceAsIType";
    public static final String REMOTE_INTERFACE_OBJ_PROPERTY = "remoteInterfaceAsIType";
    public static final String LOCAL_HOME_INTERFACE_OBJ_PROPERTY = "localHomeInterfaceAsIType";
    public static final String LOCAL_INTERFACE_OBJ_PROPERTY = "localInterfaceAsIType";
    public static final String PRIMARY_KEY_CLASS_OBJ_PROPERTY = "primaryKeyClassAsIType";
    public static final String CONSTITUENT_METHODS_PROPERTY = "constituentMethods";
    public static final String METHOD_PARTICIPANT_IN_BEAN_CLASS = "beanClassMethod";
    public static final String METHOD_PARTICIPANT_IN_HOME_INTERFACE = "homeInterfaceMethod";
    public static final String METHOD_PARTICIPANT_IN_REMOTE_INTERFACE = "remoteInterfaceMethod";
    public static final String METHOD_PARTICIPANT_IN_LOCAL_HOME_INTERFACE = "localHomeInterfaceMethod";
    public static final String METHOD_PARTICIPANT_IN_LOCAL_INTERFACE = "localInterfaceMethod";
    public static final String METHOD_PARTICIPANT_POST_CREATE = "beanClassPostMethod";
    public static final String PARAMETER_ARRAY_PROPERTY = "parameterArray";
    public static final String PARAMETER_FQN_ARRAY_PROPERTY = "parameterFQNArray";
    public static final String PARAMETER_NAME_ARRAY_PROPERTY = "parameterNameArray";
    public static final String EXCEPTION_ARRAY_PROPERTY = "exceptionArray";
    public static final String MULTI_FINDER_PROPERTY = "$multifinder";
    public static final String REQUIRES_QUERY_PROPERTY = "requiresQuery";
    public static final String QUETY_METHOD_RETURN_TYPE = "$queryMethodReturnType";
    public static final String QUETY_METHOD_RETURN_TYPE_SINGLE = "$single";
    public static final String QUETY_METHOD_RETURN_TYPE_COLLECTION = "java.util.Collection";
    public static final String QUETY_METHOD_RETURN_TYPE_ENUMERATION = "java.util.Enumeration";
    public static final String SPECIAL_METHOD_PROPERTY = "$special";
    public static final String IS_ACCESSOR_PROPERTY = "isAccessor";
    public static final String IS_ACCESSOR_CMP = "cmpAccessor";
    public static final String IS_ACCESSOR_CMR = "cmrAccessor";
    public static final String SHORT_UML_REPRESENTATION = "$short_uml_representation";
    public static final String FIELD_NAME_PROPERTY = "$name";
    public static final String FIELD_TYPE_PROPERTY = "$type";
    public static final String FIELD_NAME_PREFIX_PROPERTY = "$namePrefix";
    public static final String IN_PK_PROPERTY = "inPK";
    public static final String GETTER_PROPERTY = "getter";
    public static final String SETTER_PROPERTY = "setter";
    public static final String MISSING_ACCESSOR_PROPERTY = "missingAccessor";
    public static final String IS_RELATION_PROPERTY = "relation";
    public static final String EJB_DOMAIN = "com.tssap.j2ee.core.ejb";
    public static final String ENTITY_BEAN_METACLASS = "com.tssap.j2ee.core.ejb.EntityBean";
    public static final String SESSION_BEAN_METACLASS = "com.tssap.j2ee.core.ejb.SessionBean";
    public static final String MESSAGE_DRIVEN_BEAN_METACLASS = "com.tssap.j2ee.core.ejb.MessageDrivenBean";
    private static final IntHashMap KINDS_TO_METACLASSES = new IntHashMap();
    public static final String R_BEAN_CLASS = "Bean Class";
    public static final String R_HOME_INTERFACE = "Home Interface";
    public static final String R_REMOTE_INTERFACE = "Remote Interface";
    public static final String R_LOCAL_HOME_INTERFACE = "Local Home Interface";
    public static final String R_LOCAL_INTERFACE = "Local Interface";
    public static final String R_PRIMARY_KEY_CLASS = "Primary Key Class";
    private static final IntHashMap ROLES_MAPPING;
    public static final String EJB_METHOD_DOMAIN = "com.tssap.j2ee.core.ejb.method";
    public static final String CREATE_METHOD_METACLASS = "com.tssap.j2ee.core.ejb.method.Create";
    public static final String BUSINESS_METHOD_METACLASS = "com.tssap.j2ee.core.ejb.method.Business";
    public static final String HOME_METHOD_METACLASS = "com.tssap.j2ee.core.ejb.method.Home";
    public static final String FINDER_METHOD_METACLASS = "com.tssap.j2ee.core.ejb.method.Find";
    public static final String SELECT_METHOD_METACLASS = "com.tssap.j2ee.core.ejb.method.Select";
    private static final IntHashMap METHOD_KINDS_TO_METACLASSES;
    public static final String EJB_FIELD_DOMAIN = "com.tssap.j2ee.core.ejb.field";
    public static final String EJB_FIELD_METACLASS = "com.tssap.j2ee.core.ejb.field.Persistent";
    public static final String EJB_RELATION_METACLASS = "com.tssap.j2ee.core.ejb.field.Relation";
    public static final String BEAN_REGISTRY_ID = "Bean Registry";
    public static final UniqueName BEAN_REGISTRY;
    private static final HashMap METACLASSES_2_DOMAINS;
    public static final String RELATION_CARDINALITY_PROPERTY = "$cardinality";
    public static final String RELATION_CARDINALITY_SINGLE = "One";
    public static final String RELATION_CARDINALITY_COLLECTION = "Collection";
    public static final String RELATION_CARDINALITY_SET = "Set";

    private EjbModelMetaInfo() {
    }

    public static String[] getParameters(UniqueName uniqueName) {
        String[] result = new String[uniqueName.getParametersCount()];
        int i = 0;
        while (i < result.length) {
            result[i] = uniqueName.getParameter(i);
            ++i;
        }
        return result;
    }

    public static UniqueName getEntityBeanUniqueName(String packageName, String beanClassName) {
        return ModelAccess.createUniqueName((String)EJB_DOMAIN, (String)ENTITY_BEAN_METACLASS, (String)packageName, (String)beanClassName, null);
    }

    public static UniqueName getSessionBeanUniqueName(String packageName, String beanClassName) {
        return ModelAccess.createUniqueName((String)EJB_DOMAIN, (String)SESSION_BEAN_METACLASS, (String)packageName, (String)beanClassName, null);
    }

    public static UniqueName getMessageDrivenBeanUniqueName(String packageName, String beanClassName) {
        return ModelAccess.createUniqueName((String)EJB_DOMAIN, (String)MESSAGE_DRIVEN_BEAN_METACLASS, (String)packageName, (String)beanClassName, null);
    }

    public static boolean isEntityBean(UniqueName uniqueName) {
        if (!EJB_DOMAIN.equals(uniqueName.getDomain())) {
            return false;
        }
        return ENTITY_BEAN_METACLASS.equals(uniqueName.getSubDomain());
    }

    public static boolean isSessionBean(UniqueName uniqueName) {
        if (!EJB_DOMAIN.equals(uniqueName.getDomain())) {
            return false;
        }
        return SESSION_BEAN_METACLASS.equals(uniqueName.getSubDomain());
    }

    public static boolean isMessageDrivenBean(UniqueName uniqueName) {
        if (!EJB_DOMAIN.equals(uniqueName.getDomain())) {
            return false;
        }
        return MESSAGE_DRIVEN_BEAN_METACLASS.equals(uniqueName.getSubDomain());
    }

    public static boolean isEjb(UniqueName uniqueName) {
        return EjbModelMetaInfo.isEntityBean(uniqueName) || EjbModelMetaInfo.isSessionBean(uniqueName) || EjbModelMetaInfo.isMessageDrivenBean(uniqueName);
    }

    public static String getEjbPackageName(UniqueName uin) {
        return uin.getLocation();
    }

    public static String getEjbClassName(UniqueName uin) {
        return uin.getName();
    }

    public static String getEjbClassFqn(UniqueName uin) {
        String packageName = EjbModelMetaInfo.getEjbPackageName(uin);
        String className = EjbModelMetaInfo.getEjbClassName(uin);
        if (packageName != null && packageName.trim().length() > 0) {
            className = packageName + '.' + className;
        }
        return className;
    }

    public static int getKindForMetaclass(String metaclass) {
        try {
            return KINDS_TO_METACLASSES.find((Object)metaclass);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public static int getIntRole(String role) {
        try {
            return ROLES_MAPPING.find((Object)role);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public static UniqueName getEjbBusinessMethodUniqueName(String beanClassName, String name, String[] parameters) {
        return ModelAccess.createUniqueName((String)EJB_METHOD_DOMAIN, (String)BUSINESS_METHOD_METACLASS, (String)beanClassName, (String)name, (String[])parameters);
    }

    public static UniqueName getEjbCreateMethodUniqueName(String beanClassName, String name, String[] parameters) {
        return ModelAccess.createUniqueName((String)EJB_METHOD_DOMAIN, (String)CREATE_METHOD_METACLASS, (String)beanClassName, (String)name, (String[])parameters);
    }

    public static UniqueName getEjbFindMethodUniqueName(String beanClassName, String name, String[] parameters) {
        return ModelAccess.createUniqueName((String)EJB_METHOD_DOMAIN, (String)FINDER_METHOD_METACLASS, (String)beanClassName, (String)name, (String[])parameters);
    }

    public static UniqueName getEjbHomeMethodUniqueName(String beanClassName, String name, String[] parameters) {
        return ModelAccess.createUniqueName((String)EJB_METHOD_DOMAIN, (String)HOME_METHOD_METACLASS, (String)beanClassName, (String)name, (String[])parameters);
    }

    public static UniqueName getEjbSelectMethodUniqueName(String beanClassName, String name, String[] parameters) {
        return ModelAccess.createUniqueName((String)EJB_METHOD_DOMAIN, (String)SELECT_METHOD_METACLASS, (String)beanClassName, (String)name, (String[])parameters);
    }

    public static boolean isEjbBusinessMethod(UniqueName uniqueName) {
        if (!EJB_METHOD_DOMAIN.equals(uniqueName.getDomain())) {
            return false;
        }
        return BUSINESS_METHOD_METACLASS.equals(uniqueName.getSubDomain());
    }

    public static boolean isEjbCreateMethod(UniqueName uniqueName) {
        if (!EJB_METHOD_DOMAIN.equals(uniqueName.getDomain())) {
            return false;
        }
        return CREATE_METHOD_METACLASS.equals(uniqueName.getSubDomain());
    }

    public static boolean isEjbFindMethod(UniqueName uniqueName) {
        if (!EJB_METHOD_DOMAIN.equals(uniqueName.getDomain())) {
            return false;
        }
        return FINDER_METHOD_METACLASS.equals(uniqueName.getSubDomain());
    }

    public static boolean isEjbHomeMethod(UniqueName uniqueName) {
        if (!EJB_METHOD_DOMAIN.equals(uniqueName.getDomain())) {
            return false;
        }
        return HOME_METHOD_METACLASS.equals(uniqueName.getSubDomain());
    }

    public static boolean isEjbSelectMethod(UniqueName uniqueName) {
        if (!EJB_METHOD_DOMAIN.equals(uniqueName.getDomain())) {
            return false;
        }
        return SELECT_METHOD_METACLASS.equals(uniqueName.getSubDomain());
    }

    public static boolean isEjbMethod(UniqueName uniqueName) {
        return EjbModelMetaInfo.isEjbBusinessMethod(uniqueName) || EjbModelMetaInfo.isEjbCreateMethod(uniqueName) || EjbModelMetaInfo.isEjbFindMethod(uniqueName) || EjbModelMetaInfo.isEjbHomeMethod(uniqueName) || EjbModelMetaInfo.isEjbSelectMethod(uniqueName);
    }

    public static int getMethodKind(String methodMetaclass) {
        try {
            return METHOD_KINDS_TO_METACLASSES.find((Object)methodMetaclass);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public static UniqueName getEjbFieldUniqueName(String beanClassName, String name) {
        return ModelAccess.createUniqueName((String)EJB_FIELD_DOMAIN, (String)EJB_FIELD_METACLASS, (String)beanClassName, (String)name, null);
    }

    public static boolean isEjbField(UniqueName uniqueName) {
        if (!EJB_FIELD_DOMAIN.equals(uniqueName.getDomain())) {
            return false;
        }
        return EJB_FIELD_METACLASS.equals(uniqueName.getSubDomain());
    }

    public static boolean isEJBRegistryReference(UniqueName uniqueName) {
        if (!BEAN_REGISTRY_ID.equals(uniqueName.getDomain())) {
            return false;
        }
        if (uniqueName instanceof ReferenceUniqueName) {
            String dereferencedDomain = EjbModelMetaInfo.getDomainByMetaclass(uniqueName.getSubDomain());
            return dereferencedDomain != null;
        }
        return false;
    }

    public static ReferenceUniqueName getReferenceUniqueNameForEJBRegistry(IEJBElement element) {
        UniqueName elementUin = EjbModelMetaInfo.getUniqueName(element);
        return EjbModelMetaInfo.getReferenceUniqueNameForEJBRegistry(elementUin);
    }

    public static ReferenceUniqueName getReferenceUniqueNameForEJBRegistry(UniqueName elementUin) {
        UniqueName refUin = ModelAccess.createUniqueName((String)BEAN_REGISTRY_ID, (String)elementUin.getSubDomain(), (String)elementUin.getLocation(), (String)elementUin.getName(), (String[])EjbModelMetaInfo.getParameters(elementUin));
        return ModelAccess.createReferenceUniqueName((UniqueName)refUin, (UniqueName)elementUin);
    }

    public static UniqueName getDereferencedUniqueNameFromEJBRegistry(ReferenceUniqueName uin) {
        if (!BEAN_REGISTRY_ID.equals(uin.getDomain())) {
            return null;
        }
        String dereferencedDomain = EjbModelMetaInfo.getDomainByMetaclass(uin.getSubDomain());
        if (dereferencedDomain == null) {
            return null;
        }
        return ModelAccess.createUniqueName((String)dereferencedDomain, (String)uin.getSubDomain(), (String)uin.getLocation(), (String)uin.getName(), (String[])EjbModelMetaInfo.getParameters((UniqueName)uin));
    }

    private static String getDomainByMetaclass(String metaclass) {
        return (String)METACLASSES_2_DOMAINS.get(metaclass);
    }

    public static UniqueName getRelationLinkUniqueName(IRelationshipEnd relation) {
        String location = relation.getRoleSource().getBeanClassName();
        String name = relation.getName();
        return ModelAccess.createUniqueName((String)EJB_FIELD_DOMAIN, (String)EJB_RELATION_METACLASS, (String)location, (String)name, null);
    }

    public static boolean isRelationLink(UniqueName uin) {
        return EJB_FIELD_DOMAIN.equals(uin.getDomain()) && EJB_RELATION_METACLASS.equals(uin.getSubDomain());
    }

    public static UniqueName getUniqueName(IEJBElement element) {
        if (element instanceof IEnterpriseBean) {
            return EjbModelMetaInfo.getUniqueName((IEnterpriseBean)element);
        }
        if (element instanceof IEJBMethod) {
            return EjbModelMetaInfo.getUniqueName((IEJBMethod)element);
        }
        if (element instanceof EjbProject) {
            IProject project = ((EjbProject)element).getProject();
            return ModelUinSupport.createModelUin((String)project.getName());
        }
        if (element instanceof IPersistentField) {
            return EjbModelMetaInfo.getUniqueName((IPersistentField)element);
        }
        return null;
    }

    public static UniqueName getUniqueName(IEnterpriseBean bean) {
        String name;
        String location;
        String metaclass = (String)KINDS_TO_METACLASSES.get(bean.getKind());
        if (bean.getBeanClass() == null) {
            String fqn = bean.getBeanClassName();
            int dotIndex = fqn.lastIndexOf(46);
            if (dotIndex == -1) {
                location = "";
                name = fqn;
            } else {
                location = fqn.substring(0, dotIndex);
                name = fqn.substring(dotIndex + 1);
            }
        } else {
            location = bean.getBeanClass().getPackageFragment().getElementName();
            name = bean.getBeanClass().getElementName();
        }
        return ModelAccess.createUniqueName((String)EJB_DOMAIN, (String)metaclass, (String)location, (String)name, null);
    }

    public static UniqueName getUniqueName(IEJBMethod ejbMethod) {
        String metaclass = (String)METHOD_KINDS_TO_METACLASSES.get(ejbMethod.getKind());
        String location = ((IEnterpriseBean)ejbMethod.getParent()).getBeanClassName();
        String name = ejbMethod.getName();
        String[] params = ejbMethod.getParameterTypesForDD();
        return ModelAccess.createUniqueName((String)EJB_METHOD_DOMAIN, (String)metaclass, (String)location, (String)name, (String[])params);
    }

    public static UniqueName getUniqueName(IPersistentField ejbField) {
        String location = ((IEntityBean)ejbField.getParent()).getBeanClassName();
        String name = ejbField.getName();
        return ModelAccess.createUniqueName((String)EJB_FIELD_DOMAIN, (String)EJB_FIELD_METACLASS, (String)location, (String)name, null);
    }

    static {
        KINDS_TO_METACLASSES.put(1, (Object)ENTITY_BEAN_METACLASS);
        KINDS_TO_METACLASSES.put(2, (Object)SESSION_BEAN_METACLASS);
        KINDS_TO_METACLASSES.put(4, (Object)MESSAGE_DRIVEN_BEAN_METACLASS);
        ROLES_MAPPING = new IntHashMap();
        ROLES_MAPPING.put(1, (Object)R_BEAN_CLASS);
        ROLES_MAPPING.put(2, (Object)R_HOME_INTERFACE);
        ROLES_MAPPING.put(4, (Object)R_REMOTE_INTERFACE);
        ROLES_MAPPING.put(8, (Object)R_LOCAL_HOME_INTERFACE);
        ROLES_MAPPING.put(16, (Object)R_LOCAL_INTERFACE);
        ROLES_MAPPING.put(32, (Object)R_PRIMARY_KEY_CLASS);
        METHOD_KINDS_TO_METACLASSES = new IntHashMap();
        METHOD_KINDS_TO_METACLASSES.put(1, (Object)BUSINESS_METHOD_METACLASS);
        METHOD_KINDS_TO_METACLASSES.put(2, (Object)CREATE_METHOD_METACLASS);
        METHOD_KINDS_TO_METACLASSES.put(4, (Object)FINDER_METHOD_METACLASS);
        METHOD_KINDS_TO_METACLASSES.put(8, (Object)HOME_METHOD_METACLASS);
        METHOD_KINDS_TO_METACLASSES.put(16, (Object)SELECT_METHOD_METACLASS);
        BEAN_REGISTRY = ModelAccess.createUniqueName((String)BEAN_REGISTRY_ID, null, (String)BEAN_REGISTRY_ID);
        METACLASSES_2_DOMAINS = new HashMap();
        METACLASSES_2_DOMAINS.put(ENTITY_BEAN_METACLASS, EJB_DOMAIN);
        METACLASSES_2_DOMAINS.put(SESSION_BEAN_METACLASS, EJB_DOMAIN);
        METACLASSES_2_DOMAINS.put(MESSAGE_DRIVEN_BEAN_METACLASS, EJB_DOMAIN);
        METACLASSES_2_DOMAINS.put(BUSINESS_METHOD_METACLASS, EJB_METHOD_DOMAIN);
        METACLASSES_2_DOMAINS.put(HOME_METHOD_METACLASS, EJB_METHOD_DOMAIN);
        METACLASSES_2_DOMAINS.put(CREATE_METHOD_METACLASS, EJB_METHOD_DOMAIN);
        METACLASSES_2_DOMAINS.put(FINDER_METHOD_METACLASS, EJB_METHOD_DOMAIN);
        METACLASSES_2_DOMAINS.put(SELECT_METHOD_METACLASS, EJB_METHOD_DOMAIN);
        METACLASSES_2_DOMAINS.put(EJB_FIELD_METACLASS, EJB_FIELD_DOMAIN);
        METACLASSES_2_DOMAINS.put(EJB_RELATION_METACLASS, EJB_FIELD_DOMAIN);
    }
}

